/*
 * Decompiled with CFR 0.152.
 */
package cora.termination;

import charlie.trs.TRS;
import cora.config.Settings;
import cora.io.ProofObject;
import cora.termination.WrapperProofObject;
import cora.termination.dependency_pairs.DPFramework;
import cora.termination.dependency_pairs.FullDPFramework;
import cora.termination.dependency_pairs.InnermostDPFramework;
import cora.termination.reduction_pairs.ReductionPairTerminationProver;
import cora.termination.reduction_pairs.horpo.Horpo;
import cora.termination.transformation.CallByValueModifier;

public class TerminationHandler {
    public static ProofObject proveTermination(TRS trs) {
        DPFramework framework = TerminationHandler.chooseFramework(trs = TerminationHandler.updateTRSConstraints(trs), false);
        ProofObject po = framework.checkApplicable();
        if (po.queryAnswer() != ProofObject.Answer.YES) {
            ReductionPairTerminationProver prover = new ReductionPairTerminationProver(new Horpo(true));
            ProofObject ret = prover.proveTermination(trs);
            if (ret.queryAnswer() == ProofObject.Answer.YES) {
                return new WrapperProofObject(ret, trs, "termination");
            }
            return new WrapperProofObject(po, ret, trs, "termination", ProofObject.Answer.MAYBE);
        }
        return new WrapperProofObject(framework.run(), trs, "termination");
    }

    public static ProofObject proveComputability(TRS trs) {
        trs = TerminationHandler.updateTRSConstraints(trs);
        DPFramework framework = TerminationHandler.chooseFramework(trs, true);
        return new WrapperProofObject(framework.run(), trs, "universal computability");
    }

    private static TRS updateTRSConstraints(TRS trs) {
        if (Settings.queryRewritingStrategy().equals((Object)Settings.Strategy.CallByValue) && CallByValueModifier.isApplicable(trs)) {
            return CallByValueModifier.modify(trs);
        }
        return trs;
    }

    private static DPFramework chooseFramework(TRS trs, boolean extraRules) {
        return switch (Settings.queryRewritingStrategy()) {
            default -> throw new MatchException(null, null);
            case Settings.Strategy.Innermost -> new InnermostDPFramework(trs, extraRules);
            case Settings.Strategy.CallByValue -> new InnermostDPFramework(trs, extraRules);
            case Settings.Strategy.Full -> new FullDPFramework(trs, extraRules);
        };
    }
}

