/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs;

import charlie.smt.Constraint;
import charlie.smt.IVar;
import charlie.smt.SmtFactory;
import charlie.smt.SmtProblem;
import charlie.smt.SmtSolver;
import charlie.smt.Valuation;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.trs.TRS;
import charlie.types.Arrow;
import charlie.types.Base;
import charlie.types.Type;
import cora.config.Settings;
import cora.io.ProofObject;
import cora.termination.dependency_pairs.AccessibilityProofObject;
import cora.termination.dependency_pairs.MaybeAccessibleProofObject;
import cora.termination.dependency_pairs.NotAccessibleProofObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;

public class AccessibilityChecker {
    private SmtProblem _problem = new SmtProblem();
    private TreeMap<String, IVar> _sortVariables = new TreeMap();
    private TRS _trs;
    private String _result;

    public AccessibilityChecker(TRS trs) {
        this._trs = trs;
    }

    private IVar getSortVariable(String sort) {
        if (!this._sortVariables.containsKey(sort)) {
            this._sortVariables.put(sort, this._problem.createIntegerVariable(sort));
        }
        return this._sortVariables.get(sort);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Constraint posGeq(Base iota, Type sigma) {
        Type type = sigma;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Base.class, Arrow.class}, (Object)type2, n)) {
            case 0: {
                Base base = (Base)type2;
                try {
                    String string;
                    String name = string = base.name();
                    return SmtFactory.createGeq(this.getSortVariable(iota.toString()), this.getSortVariable(name));
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                Type right;
                Type left;
                Arrow arrow = (Arrow)type2;
                {
                    Type type3;
                    left = type3 = arrow.left();
                    right = type3 = arrow.right();
                }
                return SmtFactory.createConjunction(this.minGre(iota, left), this.posGeq(iota, right));
            }
        }
        return SmtFactory.createValue(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Constraint minGre(Base iota, Type sigma) {
        Type type = sigma;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Base.class, Arrow.class}, (Object)type2, n)) {
            case 0: {
                Base base = (Base)type2;
                try {
                    String string;
                    String name = string = base.name();
                    return SmtFactory.createGreater(this.getSortVariable(iota.toString()), this.getSortVariable(name));
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                Type right;
                Type left;
                Arrow arrow = (Arrow)type2;
                {
                    Type type3;
                    left = type3 = arrow.left();
                    right = type3 = arrow.right();
                }
                return SmtFactory.createConjunction(this.posGeq(iota, left), this.minGre(iota, right));
            }
        }
        return SmtFactory.createValue(false);
    }

    private Constraint accArg(int i, FunctionSymbol f) {
        Type type = f.queryType();
        for (int j = 1; j < i; ++j) {
            if (!type.isArrowType()) {
                throw new Error("Calling accArg(" + i + ", " + String.valueOf(f) + "), but f has type " + String.valueOf(type) + ".");
            }
            type = type.subtype(2);
        }
        Type argtype = type.subtype(1);
        Type output = type.queryOutputType();
        if (output.isBaseType()) {
            return this.posGeq((Base)output, argtype);
        }
        return SmtFactory.createValue(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void requireAllVarsAcc(Term s) {
        if (s.isVariable()) {
            return;
        }
        if (!s.isFunctionalTerm()) {
            this._problem.require(SmtFactory.createValue(false));
            return;
        }
        FunctionSymbol f = s.queryRoot();
        Type type = f.queryType();
        ArrayList<Type> argtypes = new ArrayList<Type>();
        while (type instanceof Arrow) {
            Type output;
            Arrow arrow = (Arrow)type;
            try {
                Type type2;
                Type input = type2 = arrow.left();
                output = type2 = arrow.right();
                argtypes.add(input);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            type = output;
        }
        if (!type.isBaseType()) {
            this._problem.require(SmtFactory.createValue(false));
            return;
        }
        Base output = (Base)type;
        if (argtypes.size() < s.numberArguments()) {
            throw new Error("allVarsAcc; this shouldn't happen due to type restrictions");
        }
        int i = 1;
        while (i <= s.numberArguments()) {
            Term arg = s.queryArgument(i);
            if (arg.freeReplaceables().size() != 0) {
                Type argtype = (Type)argtypes.get(i - 1);
                this._problem.require(this.posGeq(output, argtype));
                this.requireAllVarsAcc(arg);
            }
            ++i;
        }
        return;
    }

    private void generateTrsConstraints() {
        for (int i = 0; i < this._trs.queryRuleCount(); ++i) {
            Term left = this._trs.queryRule(i).queryLeftSide();
            for (int j = 1; j <= left.numberArguments(); ++j) {
                this.requireAllVarsAcc(left.queryArgument(j));
            }
        }
    }

    String printTrsConstraints() {
        this.generateTrsConstraints();
        String ret = this._problem.toString();
        this._problem.clear();
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProofObject checkAccessibility() {
        ProofObject proofObject;
        this.generateTrsConstraints();
        SmtSolver.Answer answer = Settings.smtSolver.checkSatisfiability(this._problem);
        Objects.requireNonNull(answer);
        SmtSolver.Answer answer2 = answer;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmtSolver.Answer.YES.class, SmtSolver.Answer.MAYBE.class, SmtSolver.Answer.NO.class}, (Object)answer2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                SmtSolver.Answer.YES yES = (SmtSolver.Answer.YES)answer2;
                try {
                    Valuation valuation;
                    Valuation solution = valuation = yES.val();
                    proofObject = new AccessibilityProofObject(solution, this._sortVariables);
                    return proofObject;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                SmtSolver.Answer.MAYBE mAYBE = (SmtSolver.Answer.MAYBE)answer2;
                {
                    String string;
                    String reason = string = mAYBE.reason();
                    proofObject = new MaybeAccessibleProofObject(reason);
                    return proofObject;
                }
            }
            case 2: 
        }
        SmtSolver.Answer.NO nO = (SmtSolver.Answer.NO)answer2;
        proofObject = new NotAccessibleProofObject();
        return proofObject;
    }

    public String querySortOrdering() {
        return this._result;
    }
}

