/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs;

import charlie.smt.IVar;
import charlie.smt.Valuation;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.io.ProofObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;

class AccessibilityProofObject
implements ProofObject {
    private ArrayList<Pair<String, Integer>> _sorts = new ArrayList();

    AccessibilityProofObject(Valuation solution, TreeMap<String, IVar> sortVariables) {
        sortVariables.forEach((x, v) -> this._sorts.add(new Pair<String, Integer>((String)x, solution.queryAssignment((IVar)v))));
        Collections.sort(this._sorts, new Comparator<Pair<String, Integer>>(this){

            @Override
            public int compare(Pair<String, Integer> p1, Pair<String, Integer> p2) {
                return p2.snd() - p1.snd();
            }
        });
    }

    @Override
    public ProofObject.Answer queryAnswer() {
        return ProofObject.Answer.YES;
    }

    @Override
    public void justify(OutputModule module) {
        module.print("The system is accessible function passing by ", new Object[0]);
        if (this._sorts.size() == 0 || this._sorts.get(0).snd().equals(this._sorts.get(this._sorts.size() - 1).snd())) {
            module.println("a sort ordering that equates all sorts.", new Object[0]);
            return;
        }
        module.print("a sort ordering with %a", this._sorts.get(0).fst());
        for (int i = 1; i < this._sorts.size(); ++i) {
            if (this._sorts.get(i).snd() < this._sorts.get(i - 1).snd()) {
                module.print(" \u227b ", new Object[0]);
            } else {
                module.print(" = ", new Object[0]);
            }
            module.print("%a", this._sorts.get(i).fst());
        }
        module.println(".", new Object[0]);
    }
}

