/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs;

import charlie.printer.PrintableObject;
import charlie.printer.Printer;
import charlie.printer.PrinterFactory;
import charlie.substitution.MutableSubstitution;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import java.util.LinkedHashSet;
import java.util.Set;

public record DP(Term lhs, Term rhs, Term constraint, Set<Variable> lvars) implements PrintableObject
{
    public DP(Term lhs, Term rhs, Term constraint, Set<Variable> lvars) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.constraint = constraint;
        if (!DP.initialVarSetCondition(constraint, lvars)) {
            throw new IllegalArgumentException("Illegal DP construction: the list of variables " + String.valueOf(lvars) + " for the DP must contain at least the variables in the constraint " + constraint.toString() + ".");
        }
        this.lvars = lvars;
    }

    public DP(Term lhs, Term rhs, Term constraint) {
        this(lhs, rhs, constraint, constraint.vars().toSet());
    }

    public DP(Term lhs, Term rhs) {
        this(lhs, rhs, TheoryFactory.createValue(true), Set.of());
    }

    private static boolean initialVarSetCondition(Term constraint, Set<Variable> set) {
        return set.containsAll(constraint.vars().toSet());
    }

    public LinkedHashSet<Variable> getAllVariables() {
        LinkedHashSet<Variable> result = new LinkedHashSet<Variable>();
        for (Variable x : this.lhs.vars()) {
            result.add(x);
        }
        for (Variable x : this.rhs.vars()) {
            result.add(x);
        }
        for (Variable x : this.constraint.vars()) {
            result.add(x);
        }
        return result;
    }

    public DP getRenamed() {
        MutableSubstitution subst = new MutableSubstitution();
        for (Variable x : this.getAllVariables()) {
            subst.extend(x, TermFactory.createVar(x.queryName(), x.queryType()));
        }
        Term newLhs = subst.substitute(this.lhs);
        Term newRhs = subst.substitute(this.rhs);
        Term newConstraint = subst.substitute(this.constraint);
        LinkedHashSet<Variable> newTheoryVars = new LinkedHashSet<Variable>();
        for (Variable x : this.lvars) {
            Term y = subst.get(x);
            if (y == null) continue;
            newTheoryVars.add(y.queryVariable());
        }
        return new DP(newLhs, newRhs, newConstraint, newTheoryVars);
    }

    @Override
    public void print(Printer printer) {
        MutableRenaming renaming = printer.generateUniqueNaming(this.lhs, this.rhs, this.constraint);
        this.printWithRenaming(printer, renaming);
    }

    public PrintableObject makePrintableWith(final Renaming renaming) {
        return new PrintableObject(){

            @Override
            public void print(Printer printer) {
                DP.this.printWithRenaming(printer, renaming);
            }
        };
    }

    private void printWithRenaming(Printer printer, Renaming naming) {
        Object[] objectArray = new Object[5];
        objectArray[0] = Printer.makePrintable(this.lhs, naming);
        objectArray[1] = " ";
        objectArray[2] = printer.symbThickArrow();
        objectArray[3] = " ";
        objectArray[4] = Printer.makePrintable(this.rhs, naming);
        printer.add(objectArray);
        if (!this.constraint.isValue() || this.constraint.toValue().getBool()) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = " | ";
            objectArray2[1] = Printer.makePrintable(this.constraint, naming);
            printer.add(objectArray2);
        }
        boolean anynew = false;
        for (Variable x : this.lvars) {
            if (this.constraint.freeReplaceables().contains(x)) continue;
            anynew = true;
        }
        if (!anynew) {
            return;
        }
        boolean first = true;
        for (Variable x : this.lvars) {
            if (naming.getName(x) == null || this.constraint.vars().contains(x)) continue;
            if (first) {
                printer.add(" { ");
            } else {
                printer.add(", ");
            }
            first = false;
            printer.add(naming.getName(x));
        }
        if (!first) {
            printer.add(" }");
        }
    }

    @Override
    public String toString() {
        Printer printer = PrinterFactory.createDebugPrinter();
        MutableRenaming renaming = printer.generateUniqueNaming(this.lhs, this.rhs, this.constraint);
        this.printWithRenaming(printer, renaming);
        return printer.toString();
    }

    public String ustr() {
        Printer printer = PrinterFactory.createPrinterNotForUserOutput();
        MutableRenaming renaming = printer.generateUniqueNaming(this.lhs, this.rhs, this.constraint);
        this.printWithRenaming(printer, renaming);
        return printer.toString();
    }
}

