/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs;

import charlie.trs.TRS;
import charlie.trs.TrsProperties;
import charlie.util.Pair;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.io.ProofObject;
import cora.termination.dependency_pairs.AccessibilityChecker;
import cora.termination.dependency_pairs.DPGenerator;
import cora.termination.dependency_pairs.DPProofObject;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.Processor;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import java.util.LinkedList;
import java.util.Set;

public abstract class DPFramework {
    private ProofObject _applicability;
    private Problem _initialProblem;
    protected final int SUCCESS = 1;
    protected final int FAILURE = -1;
    protected final int NA = 0;

    public static String queryDisabledCode() {
        return "dp";
    }

    public static String queryPrivateDisabledCode() {
        return "private";
    }

    protected DPFramework(TRS trs, boolean innermost, boolean extraRules) {
        this._applicability = this.determineApplicability(trs);
        DPGenerator generator = new DPGenerator(trs);
        this._initialProblem = generator.queryProblem(innermost, extraRules);
        if (Settings.isDisabled(DPFramework.queryPrivateDisabledCode())) {
            this._initialProblem = this._initialProblem.removeDPs(Set.of(), true);
        }
    }

    protected ProofObject determineApplicability(TRS trs) {
        if (!trs.verifyProperties(TrsProperties.Level.APPLICATIVE, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.PATTERN, TrsProperties.Root.THEORY, TrsProperties.FreshRight.CVARS, new TRS.RuleScheme[0])) {
            return new ProofObject(this){

                @Override
                public ProofObject.Answer queryAnswer() {
                    return ProofObject.Answer.NO;
                }

                @Override
                public void justify(OutputModule o) {
                    o.println("For now, static dependency pairs can only be applied on applicative systems without tuples, where the left-hand sides of rules are patterns of the form f(l1,...,lk) with f a function symbol.", new Object[0]);
                    o.println("(Note: extensions matter! If you are using an input file that describes for instance a first-order or applicative TRS, but use the extension of a format that allows for the inclusion of abstractions or product types, then these constructions are implicitly allowed to occur in terms, and hence the framework is not applicable.)", new Object[0]);
                }
            };
        }
        if (Settings.isDisabled(DPFramework.queryDisabledCode())) {
            return new ProofObject(this){

                @Override
                public ProofObject.Answer queryAnswer() {
                    return ProofObject.Answer.NO;
                }

                @Override
                public void justify(OutputModule o) {
                    o.println("Use of the dependency pair framework is disabled through runtime settings.", new Object[0]);
                }
            };
        }
        AccessibilityChecker checker = new AccessibilityChecker(trs);
        return checker.checkAccessibility();
    }

    protected abstract Processor getProcessor(int var1);

    protected abstract int getInitialProcessorIndex(Problem var1);

    protected abstract int getNextProcessorIndex(int var1, int var2, Problem var3);

    public final ProofObject checkApplicable() {
        return this._applicability;
    }

    public final DPProofObject run() {
        if (this._applicability.queryAnswer() != ProofObject.Answer.YES) {
            return new DPProofObject(this._applicability);
        }
        LinkedList<Pair<Problem, Integer>> todo = new LinkedList<Pair<Problem, Integer>>();
        DPProofObject ret = new DPProofObject(this._applicability, this._initialProblem);
        Problem problem = this._initialProblem;
        int processorIndex = this.getInitialProcessorIndex(problem);
        while (processorIndex >= 0) {
            int status;
            Processor proc = this.getProcessor(processorIndex);
            if (proc.isApplicable(problem)) {
                ProcessorProofObject ppo = proc.processDPP(problem);
                if (ppo.applicable()) {
                    for (Problem p : ppo.queryResults()) {
                        todo.add(new Pair<Problem, Integer>(p, processorIndex));
                    }
                    ret.addProcessorProof(ppo);
                    if (todo.isEmpty()) {
                        ret.setTerminating();
                        return ret;
                    }
                    Pair pair = (Pair)todo.removeFirst();
                    problem = (Problem)pair.fst();
                    processorIndex = (Integer)pair.snd();
                    status = 1;
                } else {
                    status = -1;
                }
            } else {
                status = 0;
            }
            processorIndex = this.getNextProcessorIndex(processorIndex, status, problem);
        }
        ret.setFailedProof(problem);
        return ret;
    }
}

