/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.trs.Alphabet;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.types.Arrow;
import charlie.types.Base;
import charlie.types.Product;
import charlie.types.Type;
import charlie.types.TypeFactory;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;

public class DPGenerator {
    private TRS _trs;
    private Base _dpSort;
    private TreeMap<FunctionSymbol, FunctionSymbol> _sharpSymbols;
    private TreeMap<FunctionSymbol, FunctionSymbol> _originalSymbols;
    private TreeSet<String> _usedNames;
    private ArrayList<DP> _dps;
    private Alphabet _extendedAlphabet;

    public DPGenerator(TRS trs) {
        this._trs = trs;
        this._dpSort = this.chooseDPSort();
        this._sharpSymbols = new TreeMap();
        this._originalSymbols = new TreeMap();
        this._usedNames = new TreeSet();
        this._dps = new ArrayList();
        for (int i = 0; i < this._trs.queryRuleCount(); ++i) {
            this.storeDPsForRule(this._trs.queryRule(i));
        }
        this._extendedAlphabet = this._trs.queryAlphabet().add(this._sharpSymbols.values());
    }

    public Base queryDPSort() {
        return this._dpSort;
    }

    public Optional<FunctionSymbol> querySharpSymbolFor(FunctionSymbol f) {
        FunctionSymbol ret = this._sharpSymbols.get(f);
        if (ret == null) {
            return Optional.empty();
        }
        return Optional.of(ret);
    }

    public Optional<FunctionSymbol> queryUnsharpSymbolFor(FunctionSymbol f) {
        FunctionSymbol ret = this._originalSymbols.get(f);
        if (ret == null) {
            return Optional.empty();
        }
        return Optional.of(ret);
    }

    public Problem queryProblem(boolean innermost, boolean extraRules) {
        TreeSet<Integer> priv = new TreeSet<Integer>();
        for (int i = 0; i < this._dps.size(); ++i) {
            if (!this._trs.isPrivate(this._originalSymbols.get(this._dps.get(i).lhs().queryRoot()))) continue;
            priv.add(i);
        }
        TRS newtrs = this._trs.createDerivative(this._trs.queryRules(), this._extendedAlphabet);
        return new Problem(this._dps, this._trs.queryRules(), priv, newtrs, innermost, extraRules, Problem.TerminationFlag.Computable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Base chooseDPSort() {
        int i;
        TreeSet<String> sorts = new TreeSet<String>();
        ArrayList<Type> types = new ArrayList<Type>();
        for (FunctionSymbol f : this._trs.queryAlphabet().getSymbols()) {
            types.add(f.queryType());
        }
        for (i = 0; i < types.size(); ++i) {
            Object e = types.get(i);
            if (e instanceof Base) {
                Base f = (Base)e;
                try {
                    String string;
                    String name = string = f.name();
                    sorts.add(name);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            for (int j = 1; j <= ((Type)types.get(i)).numberSubtypes(); ++j) {
                types.add(((Type)types.get(i)).subtype(j));
            }
        }
        if (!sorts.contains("dpsort")) {
            return TypeFactory.createSort("dpsort");
        }
        if (!sorts.contains("DPSORT")) {
            return TypeFactory.createSort("DPSORT");
        }
        if (!sorts.contains("dp_sort")) {
            return TypeFactory.createSort("dp_sort");
        }
        if (!sorts.contains("DP_SORT")) {
            return TypeFactory.createSort("DP_SORT");
        }
        i = 1;
        String attempt;
        while (sorts.contains(attempt = "dpsort" + i)) {
            ++i;
        }
        return TypeFactory.createSort(attempt);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Type generateDpType(Type ty) {
        Type right;
        Type left;
        Type type;
        Type type2 = ty;
        Objects.requireNonNull(type2);
        Type type22 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Base.class, Product.class, Arrow.class}, (Object)type22, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Base base = (Base)type22;
                try {
                    String string;
                    String name = string = base.name();
                    type = this._dpSort;
                    return type;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                Product p = (Product)type22;
                type = this._dpSort;
                return type;
            }
            case 2: 
        }
        Arrow arrow = (Arrow)type22;
        {
            Type type3;
            left = type3 = arrow.left();
            right = type3 = arrow.right();
        }
        type = TypeFactory.createArrow(left, this.generateDpType(right));
        return type;
    }

    private FunctionSymbol generateSharpFn(FunctionSymbol fn) {
        if (this._sharpSymbols.containsKey(fn)) {
            return this._sharpSymbols.get(fn);
        }
        String newname = fn.queryName() + "#";
        int i = 1;
        while (this._trs.lookupSymbol(newname) != null || this._usedNames.contains(newname)) {
            newname = fn.queryName() + "#" + i;
            ++i;
        }
        FunctionSymbol ret = TermFactory.createConstant(newname, this.generateDpType(fn.queryType()));
        this._sharpSymbols.put(fn, ret);
        this._originalSymbols.put(ret, fn);
        this._usedNames.add(newname);
        return ret;
    }

    private Term generateSharpTm(Term tm) {
        FunctionSymbol newHead = this.generateSharpFn(tm.queryRoot());
        return newHead.apply(tm.queryArguments());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<Term> generateFlatteningVars(Type ty, String basename, int startIndex) {
        ArrayList<Term> ret = new ArrayList<Term>();
        while (ty instanceof Arrow) {
            Type right;
            Arrow arrow = (Arrow)ty;
            try {
                Type type;
                Type left = type = arrow.left();
                right = type = arrow.right();
                ret.add(TermFactory.createVar(basename + startIndex, left));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ++startIndex;
            ty = right;
        }
        return ret;
    }

    private ArrayList<Term> generateCandidates(Term tm) {
        ArrayList<Term> cands = new ArrayList<Term>();
        tm.visitSubterms((s, p) -> {
            FunctionSymbol f;
            if (s.isFunctionalTerm() && this._trs.isDefined(f = s.queryRoot())) {
                cands.add(s.apply(this.generateFlatteningVars(s.queryType(), "fresh", 1)));
            }
        });
        return cands;
    }

    private void storeDPsForRule(Rule rule) {
        Term lhs = rule.queryLeftSide();
        Term rhs = rule.queryRightSide();
        Term ctr = rule.queryConstraint();
        ArrayList<Term> xs = this.generateFlatteningVars(lhs.queryType(), "arg", lhs.numberArguments() + 1);
        lhs = lhs.apply(xs);
        rhs = rhs.apply(xs);
        Term dpLeft = this.generateSharpTm(lhs);
        ArrayList<Term> cands = this.generateCandidates(rhs);
        for (Term candidate : cands) {
            this._dps.add(new DP(dpLeft, this.generateSharpTm(candidate), ctr));
        }
    }
}

