/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs;

import charlie.trs.Rule;
import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.io.ProofObject;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class DPProofObject
implements ProofObject {
    private ProofObject _accessibilityCheck;
    private Problem _initialProblem;
    private ArrayList<ProcessorProofObject> _processorProofs;
    private ProofObject.Answer _answer;
    private Problem _failure;

    DPProofObject(ProofObject accessibility) {
        this._accessibilityCheck = accessibility;
        this._initialProblem = null;
        this._processorProofs = new ArrayList();
        this._answer = ProofObject.Answer.MAYBE;
        this._failure = null;
    }

    DPProofObject(ProofObject accessibility, Problem initial) {
        this._accessibilityCheck = accessibility;
        this._initialProblem = initial;
        this._processorProofs = new ArrayList();
        this._answer = ProofObject.Answer.MAYBE;
        this._failure = null;
    }

    void setTerminating() {
        this._answer = ProofObject.Answer.YES;
    }

    void setNonTerminating() {
        this._answer = ProofObject.Answer.NO;
    }

    void setFailedProof(Problem problem) {
        this._failure = problem;
        this._answer = ProofObject.Answer.MAYBE;
    }

    void addProcessorProof(ProcessorProofObject procproof) {
        this._processorProofs.add(procproof);
    }

    @Override
    public ProofObject.Answer queryAnswer() {
        return this._answer;
    }

    @Override
    public void justify(OutputModule module) {
        this._accessibilityCheck.justify(module);
        if (this._initialProblem == null) {
            return;
        }
        HashMap<Problem, String> names = new HashMap<Problem, String>();
        HashMap<List<DP>, String> pnames = new HashMap<List<DP>, String>();
        HashMap<FixedList<Rule>, String> rnames = new HashMap<FixedList<Rule>, String>();
        rnames.put(this._initialProblem.getOriginalTRS().queryRules(), "R");
        this.justifyStart(module, names, pnames, rnames);
        for (ProcessorProofObject po : this._processorProofs) {
            this.justifyProcessor(module, po, names, pnames, rnames);
        }
        this.justifyEnd(module, names, pnames, rnames);
    }

    private boolean storeDPP(Problem prob, HashMap<Problem, String> names) {
        if (names.containsKey(prob)) {
            return false;
        }
        names.put(prob, "D" + (names.size() + 1));
        return true;
    }

    private boolean storeDPList(Problem prob, HashMap<List<DP>, String> pnames) {
        if (pnames.containsKey(prob.getDPList())) {
            return false;
        }
        pnames.put(prob.getDPList(), "P" + (pnames.size() + 1));
        return true;
    }

    private boolean storeRuleList(Problem prob, HashMap<FixedList<Rule>, String> rnames) {
        if (prob.getRuleList().isEmpty()) {
            return false;
        }
        if (rnames.containsKey(prob.getRuleList())) {
            return false;
        }
        rnames.put(prob.getRuleList(), "R" + (rnames.size() + 1));
        return true;
    }

    private void printDPP(OutputModule module, Problem problem, HashMap<Problem, String> probnames, HashMap<List<DP>, String> pnames, HashMap<FixedList<Rule>, String> rnames) {
        String name = probnames.get(problem);
        String pname = pnames.get(problem.getDPList());
        String rules = problem.getRuleList().isEmpty() ? "%{emptyset}" : rnames.get(problem.getRuleList());
        String extrarules = problem.hasExtraRules() ? " %{union} R_?" : "";
        String innermost = problem.isInnermost() ? "i" : "f";
        String termination = switch (problem.queryTerminationStatus()) {
            default -> throw new MatchException(null, null);
            case Problem.TerminationFlag.Computable -> "c";
            case Problem.TerminationFlag.Terminating -> "t";
            case Problem.TerminationFlag.Arbitrary -> "a";
        };
        module.print("%a = (%a, " + rules + extrarules + ", %a, %a)", name, pname, innermost, termination);
    }

    private void printDPs(OutputModule module, Problem problem, String name) {
        module.startTable();
        int counter = 0;
        for (int i = 0; i < problem.getDPList().size(); ++i) {
            DP dp = problem.getDPList().get(i);
            module.nextColumn((String)(counter == 0 ? name + "." : ""), new Object[0]);
            module.nextColumn("(%a)", ++counter);
            module.nextColumn("%a", dp);
            if (problem.isPrivate(i)) {
                module.nextColumn("(private)", new Object[0]);
            }
            module.println();
        }
        if (counter == 0) {
            module.nextColumn(name, new Object[0]);
            module.println("[empty set of DPs]", new Object[0]);
        }
        module.endTable();
    }

    private void printRules(OutputModule module, Problem problem, String name) {
        module.startTable();
        int counter = 0;
        for (Rule rule : problem.getRuleList()) {
            module.nextColumn((String)(counter == 0 ? name + "." : ""), new Object[0]);
            module.nextColumn("(%a)", ++counter);
            module.nextColumn("%a", rule);
            module.println();
        }
        if (counter == 0) {
            module.nextColumn(name, new Object[0]);
            module.println("[empty set of rules]", new Object[0]);
        }
        module.endTable();
    }

    private void justifyStart(OutputModule module, HashMap<Problem, String> probnames, HashMap<List<DP>, String> pnames, HashMap<FixedList<Rule>, String> rnames) {
        this.storeDPP(this._initialProblem, probnames);
        boolean dpnew = this.storeDPList(this._initialProblem, pnames);
        boolean rnew = this.storeRuleList(this._initialProblem, rnames);
        module.print("We start by computing the initial DP problem ", new Object[0]);
        this.printDPP(module, this._initialProblem, probnames, pnames, rnames);
        module.println(", where:", new Object[0]);
        if (dpnew) {
            this.printDPs(module, this._initialProblem, pnames.get(this._initialProblem.getDPList()));
        }
        if (rnew) {
            this.printRules(module, this._initialProblem, rnames.get(this._initialProblem.getRuleList()));
        }
    }

    private void justifyProcessor(OutputModule module, ProcessorProofObject po, HashMap<Problem, String> probnames, HashMap<List<DP>, String> pnames, HashMap<FixedList<Rule>, String> rnames) {
        module.print("***** We apply the %a Processor on ", po.queryProcessorName());
        Problem input = po.queryInput();
        if (!probnames.containsKey(input)) {
            this.describeUnknownDPP(module, input, probnames, pnames, rnames);
        } else {
            this.printDPP(module, input, probnames, pnames, rnames);
            module.println(".", new Object[0]);
        }
        po.justify(module);
        ArrayList<Problem> newDPs = new ArrayList<Problem>();
        ArrayList<Problem> newRules = new ArrayList<Problem>();
        for (Problem out : po.queryResults()) {
            this.storeDPP(out, probnames);
            if (this.storeDPList(out, pnames)) {
                newDPs.add(out);
            }
            if (!this.storeRuleList(out, rnames)) continue;
            newRules.add(out);
        }
        module.print("Processor output: { ", new Object[0]);
        boolean first = true;
        for (Problem out : po.queryResults()) {
            if (first) {
                first = false;
            } else {
                module.print("; ", new Object[0]);
            }
            this.printDPP(module, out, probnames, pnames, rnames);
            module.print(" ", new Object[0]);
        }
        if (newDPs.size() == 0 && newRules.size() == 0) {
            module.println("}.", new Object[0]);
        } else {
            module.println("}, where:", new Object[0]);
            for (Problem prob : newDPs) {
                this.printDPs(module, prob, pnames.get(prob.getDPList()));
            }
            for (Problem prob : newRules) {
                this.printRules(module, prob, rnames.get(prob.getRuleList()));
            }
        }
    }

    private void justifyEnd(OutputModule module, HashMap<Problem, String> probnames, HashMap<List<DP>, String> pnames, HashMap<FixedList<Rule>, String> rnames) {
        if (this._failure != null) {
            module.print("***** No progress could be made on DP problem ", new Object[0]);
            if (probnames.containsKey(this._failure)) {
                this.printDPP(module, this._failure, probnames, pnames, rnames);
                module.println(".", new Object[0]);
            } else {
                this.describeUnknownDPP(module, this._failure, probnames, pnames, rnames);
            }
        }
    }

    private void describeUnknownDPP(OutputModule module, Problem problem, HashMap<Problem, String> probnames, HashMap<List<DP>, String> pnames, HashMap<FixedList<Rule>, String> rnames) {
        this.storeDPP(problem, probnames);
        boolean dpnew = this.storeDPList(problem, pnames);
        boolean rnew = this.storeRuleList(problem, rnames);
        module.print("the DP problem ", new Object[0]);
        this.printDPP(module, problem, probnames, pnames, rnames);
        if (dpnew || rnew) {
            module.println(", where:", new Object[0]);
        } else {
            module.println();
        }
        if (dpnew) {
            this.printDPs(module, problem, pnames.get(problem.getDPList()));
        }
        if (rnew) {
            this.printRules(module, problem, rnames.get(problem.getRuleList()));
        }
    }
}

