/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs;

import charlie.terms.FunctionSymbol;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.util.FixedList;
import charlie.util.NullStorageException;
import cora.termination.dependency_pairs.DP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class Problem {
    private final List<DP> _dps;
    private final FixedList<Rule> _rules;
    private final Set<Integer> _privateIndexes;
    private TRS _originalTrs;
    private boolean _innermost;
    private boolean _extraRules;
    private TerminationFlag _terminationFlag;

    public Problem(List<DP> dps, FixedList<Rule> rules, Set<Integer> privates, TRS original, boolean innermost, boolean extraRules, TerminationFlag flag) {
        if (dps == null) {
            throw new NullStorageException("Problem", "set of dependency pairs");
        }
        if (rules == null) {
            throw new NullStorageException("Problem", "set of rules");
        }
        if (original == null) {
            throw new NullStorageException("Problem", "original TRS");
        }
        this._dps = dps;
        this._rules = rules;
        this._privateIndexes = privates == null ? Set.of() : privates;
        this._originalTrs = original;
        this._innermost = innermost;
        this._extraRules = extraRules;
        this._terminationFlag = flag;
    }

    public boolean isEmpty() {
        return this._dps.isEmpty();
    }

    public List<DP> getDPList() {
        return this._dps;
    }

    public FixedList<Rule> getRuleList() {
        return this._rules;
    }

    public boolean hasExtraRules() {
        return this._extraRules;
    }

    public TRS getOriginalTRS() {
        return this._originalTrs;
    }

    public boolean hasPrivateDPs() {
        return !this._privateIndexes.isEmpty();
    }

    public boolean isPrivate(int dpIndex) {
        return this._privateIndexes.contains(dpIndex);
    }

    public Set<Integer> queryPrivateIndexes() {
        return Collections.unmodifiableSet(this._privateIndexes);
    }

    public boolean isInnermost() {
        return this._innermost;
    }

    public TerminationFlag queryTerminationStatus() {
        return this._terminationFlag;
    }

    public boolean terminating() {
        return switch (this._terminationFlag.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> false;
            case 1 -> true;
            case 0 -> true;
        };
    }

    public Set<FunctionSymbol> getHeads() {
        TreeSet<FunctionSymbol> allFns = new TreeSet<FunctionSymbol>();
        for (DP dp : this._dps) {
            if (dp.lhs().isFunctionalTerm()) {
                allFns.add(dp.lhs().queryRoot());
            }
            if (!dp.rhs().isFunctionalTerm()) continue;
            allFns.add(dp.rhs().queryRoot());
        }
        return allFns;
    }

    public Problem removeDPs(Set<Integer> remove, boolean emptyPrivates) {
        ArrayList<DP> newList = new ArrayList<DP>();
        TreeSet<Integer> newPriv = new TreeSet<Integer>();
        for (int i = 0; i < this._dps.size(); ++i) {
            if (remove.contains(i)) continue;
            if (!emptyPrivates && this._privateIndexes.contains(i)) {
                newPriv.add(newList.size());
            }
            newList.add(this._dps.get(i));
        }
        return new Problem(newList, this._rules, newPriv, this._originalTrs, this._innermost, this._extraRules, this._terminationFlag);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean forUnit) {
        StringBuilder builder = new StringBuilder();
        builder.append("DPs:\n");
        for (int i = 0; i < this._dps.size(); ++i) {
            builder.append("  ");
            if (forUnit) {
                builder.append(this._dps.get(i).ustr());
            } else {
                builder.append(this._dps.get(i).toString());
            }
            if (this._privateIndexes.contains(i)) {
                builder.append(" (private)\n");
                continue;
            }
            builder.append("\n");
        }
        builder.append("Rules:\n");
        for (Rule rule : this._rules) {
            builder.append("  ");
            builder.append(rule.toString());
            builder.append("\n");
        }
        if (this._extraRules) {
            builder.append("  ... and an unknown number of additional rules\n");
        }
        builder.append("Evaluation is " + (this._innermost ? "innermost" : "arbitrary") + ".\n");
        builder.append("Right-hand sides are expected to be " + String.valueOf((Object)this._terminationFlag) + ".\n");
        return builder.toString();
    }

    public static enum TerminationFlag {
        Computable,
        Terminating,
        Arbitrary;

    }
}

