/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors;

import charlie.substitution.MutableSubstitution;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import java.util.List;
import java.util.Map;
import java.util.Set;

class IntegerMappingProof
extends ProcessorProofObject {
    private Set<Integer> _oriented;
    private Map<FunctionSymbol, List<Variable>> _argvars;
    private Map<FunctionSymbol, Term> _intp;

    IntegerMappingProof(Problem inp) {
        super(inp);
        this._oriented = null;
        this._intp = null;
    }

    IntegerMappingProof(Problem inp, Set<Integer> oriented, Map<FunctionSymbol, List<Variable>> argvars, Map<FunctionSymbol, Term> intp) {
        super(inp, inp.removeDPs(oriented, true));
        this._oriented = oriented;
        this._argvars = argvars;
        this._intp = intp;
    }

    @Override
    public String queryProcessorName() {
        return "Integer Function";
    }

    @Override
    public void justify(OutputModule module) {
        if (this._intp == null) {
            module.println("No suitable integer maping could be found", new Object[0]);
            return;
        }
        this.printFunction(module);
        module.println("We thus have:", new Object[0]);
        this.printOriented(module);
        if (this._oriented.size() == this._input.getDPList().size()) {
            module.println("All DPs are strictly oriented, and may be removed.  Hence, this DP problem is finite.", new Object[0]);
        } else {
            module.println("We may remove the strictly oriented DPs, which yields:", new Object[0]);
        }
    }

    private void printFunction(OutputModule module) {
        module.println("We use the following integer mapping:", new Object[0]);
        module.startTable();
        this._intp.forEach((f, t) -> {
            module.nextColumn("J(%a)", f.toString());
            module.nextColumn("=", new Object[0]);
            module.println("%a", t);
        });
        module.endTable();
    }

    private Term instantiateCandidate(Term candidate, Term term) {
        MutableSubstitution subst = new MutableSubstitution();
        FunctionSymbol f = term.queryRoot();
        for (int varL = 0; varL < f.queryArity(); ++varL) {
            subst.extend(this._argvars.get(f).get(varL), term.queryArgument(varL + 1));
        }
        return subst.substitute(candidate);
    }

    private void printOriented(OutputModule module) {
        module.startTable();
        List<DP> originalDPs = this._input.getDPList();
        for (int index = 0; index < originalDPs.size(); ++index) {
            DP dp = originalDPs.get(index);
            Term left = this.instantiateCandidate(this._intp.get(dp.lhs().queryRoot()), dp.lhs());
            Term right = this.instantiateCandidate(this._intp.get(dp.rhs().queryRoot()), dp.rhs());
            MutableRenaming renaming = module.generateUniqueNaming(left, right, dp.constraint());
            boolean oriented = this._oriented.contains(index);
            module.nextColumn("(" + (index + 1) + ")", new Object[0]);
            module.nextColumn("%a", new Pair<Term, MutableRenaming>(dp.constraint(), renaming));
            module.nextColumn("%{Vdash}", new Object[0]);
            module.nextColumn("%a", new Pair<Term, MutableRenaming>(left, renaming));
            module.nextColumn(oriented ? "%{greater}" : "%{geq}", new Object[0]);
            module.nextColumn("%a", new Pair<Term, MutableRenaming>(right, renaming));
            if (oriented) {
                module.nextColumn("(and %a %{geq} 0)", new Pair<Term, MutableRenaming>(left, renaming));
            }
            module.println();
        }
        module.endTable();
    }
}

