/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors;

import cora.io.OutputModule;
import cora.termination.dependency_pairs.Problem;
import java.util.List;

public abstract class ProcessorProofObject {
    protected Problem _input;
    protected List<Problem> _output;

    protected ProcessorProofObject(Problem input, List<Problem> output) {
        this._input = input;
        this._output = output;
    }

    protected ProcessorProofObject(Problem input, Problem output) {
        this._input = input;
        this._output = output.isEmpty() ? List.of() : List.of(output);
    }

    protected ProcessorProofObject(Problem input) {
        this._input = input;
        this._output = null;
    }

    public boolean applicable() {
        return this._output != null && (this._output.size() != 1 || this._output.get(0) != this._input);
    }

    public Problem queryInput() {
        return this._input;
    }

    public Problem queryOutput() {
        if (this._output == null) {
            return this._input;
        }
        if (this._output.size() == 0) {
            return new Problem(List.of(), this._input.getRuleList(), null, this._input.getOriginalTRS(), this._input.isInnermost(), this._input.hasExtraRules(), this._input.queryTerminationStatus());
        }
        if (this._output.size() == 1) {
            return this._output.get(0);
        }
        throw new Error("Calling queryOutput() when there are " + this._output.size() + " results!");
    }

    public List<Problem> queryResults() {
        return this._output;
    }

    public abstract void justify(OutputModule var1);

    public abstract String queryProcessorName();

    public String toString() {
        OutputModule module = OutputModule.createPlainModule(this._input.getOriginalTRS());
        this.justify(module);
        String justification = module.toString();
        return this.queryProcessorName() + "\n" + justification;
    }
}

