/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.util.Pair;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.Processor;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;

public class SplittingProcessor
implements Processor {
    private boolean _anythingChanged;

    public static String queryDisabledCode() {
        return "split";
    }

    @Override
    public boolean isApplicable(Problem dp) {
        return !Settings.isDisabled(SplittingProcessor.queryDisabledCode());
    }

    private void addJunctionParts(Term constraint, FunctionSymbol root, ArrayList<Term> sofar) {
        if (!constraint.isFunctionalTerm()) {
            sofar.add(constraint);
        } else if (!constraint.queryRoot().equals(root)) {
            sofar.add(constraint);
        } else {
            for (int i = 1; i <= constraint.numberArguments(); ++i) {
                this.addJunctionParts(constraint.queryArgument(i), root, sofar);
            }
        }
    }

    private ArrayList<Term> getConjunctionComponents(Term constraint) {
        ArrayList<Term> ret = new ArrayList<Term>();
        this.addJunctionParts(constraint, TheoryFactory.andSymbol, ret);
        return ret;
    }

    private Optional<ArrayList<Term>> split(Term constraint) {
        if (!constraint.isFunctionalTerm()) {
            return Optional.empty();
        }
        if (constraint.queryRoot().equals(TheoryFactory.intDistinctSymbol) && constraint.numberArguments() == 2) {
            Term arg1 = constraint.queryArgument(1);
            Term arg2 = constraint.queryArgument(2);
            ArrayList<Term> ret = new ArrayList<Term>();
            ret.add(TermFactory.createApp(TheoryFactory.greaterSymbol, arg1, arg2));
            ret.add(TermFactory.createApp(TheoryFactory.smallerSymbol, arg1, arg2));
            return Optional.of(ret);
        }
        if (constraint.queryRoot().equals(TheoryFactory.orSymbol)) {
            ArrayList<Term> ret = new ArrayList<Term>();
            this.addJunctionParts(constraint, TheoryFactory.orSymbol, ret);
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    private Term makeConj(Term a, Term b) {
        return TermFactory.createApp(TheoryFactory.andSymbol, a, b);
    }

    private void combine(ArrayList<Term> constraintlist, Term addition) {
        for (int i = 0; i < constraintlist.size(); ++i) {
            constraintlist.set(i, this.makeConj(constraintlist.get(i), addition));
        }
    }

    private void multiply(ArrayList<Term> constraintlist, ArrayList<Term> otherlist) {
        int n = constraintlist.size();
        for (int j = 1; j < otherlist.size(); ++j) {
            for (int i = 0; i < n; ++i) {
                constraintlist.add(this.makeConj(constraintlist.get(i), otherlist.get(j)));
            }
        }
        for (int i = 0; i < n; ++i) {
            constraintlist.set(i, this.makeConj(constraintlist.get(i), otherlist.get(0)));
        }
    }

    private Optional<ArrayList<DP>> split(DP dp) {
        ArrayList<Object> results;
        Term constraint = dp.constraint();
        ArrayList<Term> parts = this.getConjunctionComponents(constraint);
        int numSplit = 0;
        Optional<ArrayList<Term>> first = this.split(parts.get(0));
        if (first.isEmpty()) {
            results = new ArrayList();
            results.add(parts.get(0));
        } else {
            results = first.get();
            numSplit = 1;
        }
        for (int i = 1; i < parts.size(); ++i) {
            Optional<ArrayList<Term>> next = this.split(parts.get(i));
            if (next.isEmpty()) {
                this.combine(results, parts.get(i));
                continue;
            }
            if (++numSplit > 2) {
                return Optional.empty();
            }
            this.multiply(results, next.get());
        }
        if (numSplit == 0) {
            return Optional.empty();
        }
        ArrayList<DP> ret = new ArrayList<DP>();
        for (int i = 0; i < results.size(); ++i) {
            ret.add(new DP(dp.lhs(), dp.rhs(), (Term)results.get(i), dp.lvars()));
        }
        return Optional.of(ret);
    }

    @Override
    public ProcessorProofObject processDPP(Problem dpp) {
        this._anythingChanged = false;
        List<DP> dps = dpp.getDPList();
        ArrayList<DP> ret = new ArrayList<DP>();
        TreeSet<Integer> priv = new TreeSet<Integer>();
        ArrayList<Pair<DP, List<DP>>> info = new ArrayList<Pair<DP, List<DP>>>();
        for (int i = 0; i < dps.size(); ++i) {
            Optional<ArrayList<DP>> splitDP = this.split(dps.get(i));
            if (splitDP.isEmpty()) {
                if (dpp.isPrivate(i)) {
                    priv.add(ret.size());
                }
                ret.add(dps.get(i));
                continue;
            }
            this._anythingChanged = true;
            info.add(new Pair<DP, List>(dps.get(i), splitDP.get()));
            for (DP dp : splitDP.get()) {
                if (dpp.isPrivate(i)) {
                    priv.add(ret.size());
                }
                ret.add(dp);
            }
        }
        if (this._anythingChanged) {
            Problem newprob = new Problem(ret, dpp.getRuleList(), priv, dpp.getOriginalTRS(), dpp.isInnermost(), dpp.hasExtraRules(), dpp.queryTerminationStatus());
            return new SplittingProofObject(this, dpp, newprob, info);
        }
        return new SplittingProofObject(this, dpp);
    }

    private class SplittingProofObject
    extends ProcessorProofObject {
        private List<Pair<DP, List<DP>>> _splitDP;

        public SplittingProofObject(SplittingProcessor splittingProcessor, Problem inp) {
            super(inp);
            this._splitDP = null;
        }

        public SplittingProofObject(SplittingProcessor splittingProcessor, Problem inp, Problem out, List<Pair<DP, List<DP>>> splitDP) {
            super(inp, out);
            this._splitDP = splitDP;
        }

        @Override
        public String queryProcessorName() {
            return "Constraint Modification";
        }

        @Override
        public void justify(OutputModule module) {
            if (this._splitDP == null) {
                return;
            }
            for (Pair<DP, List<DP>> p : this._splitDP) {
                module.println("We replace %a by:", p.fst());
                module.startTable();
                for (DP result : p.snd()) {
                    module.println("%a", result);
                }
                module.endTable();
            }
        }
    }
}

