/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.replaceable.MutableRenaming;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SubtermCriterionProof
extends ProcessorProofObject {
    private Set<Integer> _oriented;
    private Map<FunctionSymbol, Integer> _proj;

    SubtermCriterionProof(Problem inp) {
        super(inp);
        this._oriented = null;
        this._proj = null;
    }

    SubtermCriterionProof(Problem inp, Set<Integer> oriented, Map<FunctionSymbol, Integer> proj) {
        super(inp, inp.removeDPs(oriented, true));
        this._oriented = oriented;
        this._proj = proj;
    }

    @Override
    public String queryProcessorName() {
        return "Subterm Criterion";
    }

    @Override
    public void justify(OutputModule module) {
        if (this._proj == null) {
            module.println("No suitable projection could be found", new Object[0]);
            return;
        }
        this.printProjection(module);
        module.println("We thus have:", new Object[0]);
        this.printOriented(module);
        if (this._oriented.size() == this._input.getDPList().size()) {
            module.println("All DPs are strictly oriented, and may be removed.  Hence, this DP problem is finite.", new Object[0]);
        } else {
            module.println("We may remove the strictly oriented DPs.", new Object[0]);
        }
    }

    private void printProjection(OutputModule module) {
        module.println("We use the following projection function:", new Object[0]);
        module.startTable();
        this._proj.forEach((f, num) -> {
            module.nextColumn("%{nu}(%a)", f.toString());
            module.nextColumn("=", new Object[0]);
            module.println("%a", num);
        });
        module.endTable();
    }

    private void printOriented(OutputModule module) {
        module.startTable();
        List<DP> originalDPs = this._input.getDPList();
        for (int index = 0; index < originalDPs.size(); ++index) {
            DP dp = originalDPs.get(index);
            FunctionSymbol f = dp.lhs().queryRoot();
            FunctionSymbol g = dp.rhs().queryRoot();
            if (!this._proj.containsKey(f) || !this._proj.containsKey(g)) {
                throw new Error("Illegal proof: no projection given for " + String.valueOf(dp) + ".");
            }
            Term left = dp.lhs().queryArgument(this._proj.get(f));
            Term right = dp.rhs().queryArgument(this._proj.get(g));
            MutableRenaming renaming = module.generateUniqueNaming(left, right);
            boolean oriented = this._oriented.contains(index);
            module.nextColumn("(" + (index + 1) + ")", new Object[0]);
            module.nextColumn("%a", new Pair<Term, MutableRenaming>(left, renaming));
            module.nextColumn(oriented ? "%{supterm}" : "%{suptermeq}", new Object[0]);
            module.nextColumn("%a", new Pair<Term, MutableRenaming>(right, renaming));
            module.println();
        }
        module.endTable();
    }
}

