/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors;

import charlie.smt.BVar;
import charlie.smt.Constraint;
import charlie.smt.IVar;
import charlie.smt.SmtFactory;
import charlie.smt.SmtProblem;
import charlie.smt.SmtSolver;
import charlie.smt.Valuation;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.trs.TRS;
import charlie.trs.TrsProperties;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.Processor;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import cora.termination.dependency_pairs.processors.SubtermCriterionProof;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class SubtermProcessor
implements Processor {
    private SmtProblem _smt;

    public static String queryDisabledCode() {
        return "subcrit";
    }

    @Override
    public boolean isApplicable(Problem dpp) {
        return !Settings.isDisabled(SubtermProcessor.queryDisabledCode()) && (dpp.isInnermost() || dpp.terminating()) && dpp.getOriginalTRS().verifyProperties(TrsProperties.Level.APPLICATIVE, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLEPRODUCTS, TrsProperties.Lhs.NONPATTERN, TrsProperties.Root.ANY, TrsProperties.FreshRight.ANY, new TRS.RuleScheme[0]);
    }

    private Map<FunctionSymbol, IVar> generateFnIvarMap(Problem dpp) {
        Set<FunctionSymbol> allFns = dpp.getHeads();
        TreeMap<FunctionSymbol, IVar> retMap = new TreeMap<FunctionSymbol, IVar>();
        for (FunctionSymbol f : allFns) {
            retMap.put(f, this._smt.createIntegerVariable());
        }
        return retMap;
    }

    private Map<DP, BVar> generateDpBVarMap(Problem dpp) {
        LinkedHashMap<DP, BVar> retMap = new LinkedHashMap<DP, BVar>(dpp.getDPList().size());
        dpp.getDPList().forEach(dp -> retMap.put((DP)dp, this._smt.createBooleanVariable()));
        return retMap;
    }

    private void addFnConstraintsToSMT(Map<FunctionSymbol, IVar> map) {
        map.forEach((fn, ivar) -> {
            int arity = fn.queryArity();
            this._smt.require(SmtFactory.createLeq(SmtFactory.createValue(1), ivar));
            this._smt.require(SmtFactory.createGeq(SmtFactory.createValue(arity), ivar));
        });
    }

    private void requireAtLeastOneStrict(Map<DP, BVar> boolMap) {
        ArrayList<Constraint> disj = new ArrayList<Constraint>();
        for (BVar b : boolMap.values()) {
            disj.add(b);
        }
        this._smt.require(SmtFactory.createDisjunction(disj));
    }

    private void addProblemConstraintsToSMT(Map<FunctionSymbol, IVar> fSharpMap, Map<DP, BVar> dpbVarMap, Problem dpp) {
        for (DP dp : dpp.getDPList()) {
            Term lhs = dp.lhs();
            FunctionSymbol f = lhs.queryRoot();
            Term rhs = dp.rhs();
            FunctionSymbol g = rhs.queryRoot();
            for (int i = 1; i <= lhs.numberArguments(); ++i) {
                for (int j = 1; j <= rhs.numberArguments(); ++j) {
                    Constraint disjunction;
                    Constraint c2;
                    if (f.equals(g) && i != j) continue;
                    Term si = lhs.queryArgument(i);
                    Term tj = rhs.queryArgument(j);
                    Constraint c0 = SmtFactory.createUnequal(fSharpMap.get(f), SmtFactory.createValue(i));
                    Constraint c1 = SmtFactory.createUnequal(fSharpMap.get(g), SmtFactory.createValue(j));
                    if (si.equals(tj)) {
                        c2 = SmtFactory.createNegation(dpbVarMap.get(dp));
                        disjunction = SmtFactory.createDisjunction(new ArrayList<Constraint>(List.of(c0, c1, c2)));
                        this._smt.require(disjunction);
                        continue;
                    }
                    if (si.hasSubterm(tj)) {
                        c2 = dpbVarMap.get(dp);
                        disjunction = SmtFactory.createDisjunction(new ArrayList<Constraint>(List.of(c0, c1, c2)));
                        this._smt.require(disjunction);
                        continue;
                    }
                    Constraint disjunction2 = SmtFactory.createDisjunction(new ArrayList<Constraint>(List.of(c0, c1)));
                    this._smt.require(disjunction2);
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public ProcessorProofObject processDPP(Problem dpp) {
        this._smt = new SmtProblem();
        Map<FunctionSymbol, IVar> fSharpMap = this.generateFnIvarMap(dpp);
        this.addFnConstraintsToSMT(fSharpMap);
        Map<DP, BVar> dpbVarMap = this.generateDpBVarMap(dpp);
        this.requireAtLeastOneStrict(dpbVarMap);
        this.addProblemConstraintsToSMT(fSharpMap, dpbVarMap, dpp);
        Valuation valuation = null;
        SmtSolver.Answer answer = Settings.smtSolver.checkSatisfiability(this._smt);
        Objects.requireNonNull(answer);
        SmtSolver.Answer answer2 = answer;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmtSolver.Answer.YES.class}, (Object)answer2, n)) {
            case 0: {
                Valuation valuation2;
                Valuation val;
                SmtSolver.Answer.YES yES = (SmtSolver.Answer.YES)answer2;
                valuation = val = (valuation2 = yES.val());
                break;
            }
            default: {
                return new FailedSubcritProofObject(this, dpp);
            }
        }
        TreeSet<Integer> indexOfOrientedDPs = new TreeSet<Integer>();
        TreeMap<FunctionSymbol, Integer> nu = new TreeMap<FunctionSymbol, Integer>();
        List<DP> originalDPs = dpp.getDPList();
        Valuation v = valuation;
        fSharpMap.forEach((f, ivar) -> nu.put((FunctionSymbol)f, v.queryAssignment((IVar)ivar)));
        for (int index = 0; index < originalDPs.size(); ++index) {
            DP dp = originalDPs.get(index);
            BVar bvar = dpbVarMap.get(dp);
            if (!valuation.queryAssignment(bvar)) continue;
            indexOfOrientedDPs.add(index);
        }
        return new SubtermCriterionProof(dpp, indexOfOrientedDPs, nu);
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private class FailedSubcritProofObject
    extends ProcessorProofObject {
        public FailedSubcritProofObject(SubtermProcessor subtermProcessor, Problem inp) {
            super(inp);
        }

        @Override
        public void justify(OutputModule module) {
        }

        @Override
        public String queryProcessorName() {
            return "Subterm Criterion";
        }
    }
}

