/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.trs.TRS;
import charlie.trs.TrsProperties;
import charlie.types.Type;
import cora.config.Settings;
import cora.io.OutputModule;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.Processor;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TheoryArgumentsProcessor
implements Processor {
    private boolean _fixPublic;
    private TreeMap<FunctionSymbol, TreeSet<Integer>> _targs;

    public static String queryDisabledCode() {
        return "thargs";
    }

    public TheoryArgumentsProcessor(boolean fixPublic) {
        this._fixPublic = fixPublic;
    }

    public static TheoryArgumentsProcessor generalTArgsProcessor() {
        return new TheoryArgumentsProcessor(false);
    }

    @Override
    public boolean isApplicable(Problem dpp) {
        return !Settings.isDisabled(TheoryArgumentsProcessor.queryDisabledCode()) && (!this._fixPublic || dpp.hasPrivateDPs()) && dpp.getOriginalTRS().verifyProperties(TrsProperties.Level.APPLICATIVE, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.PATTERN, TrsProperties.Root.THEORY, TrsProperties.FreshRight.CVARS, new TRS.RuleScheme[0]);
    }

    private void setupInitialArgumentsFunction(Problem dpp) {
        this._targs = new TreeMap();
        Set<FunctionSymbol> allFns = dpp.getHeads();
        for (FunctionSymbol f : allFns) {
            this._targs.put(f, new TreeSet());
            Type t = f.queryType();
            int i = 1;
            while (t.isArrowType()) {
                Type argtype = t.subtype(1);
                if (argtype.isBaseType() && argtype.isTheoryType()) {
                    this._targs.get(f).add(i);
                }
                ++i;
                t = t.subtype(2);
            }
        }
    }

    private void imposeMinimalLimitations(Problem dpp) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (DP dp : dpp.getDPList()) {
            terms.add(dp.lhs());
            terms.add(dp.rhs());
        }
        for (Term term : terms) {
            FunctionSymbol root = term.queryRoot();
            TreeSet<Integer> rootset = this._targs.get(root);
            for (int i = 1; i <= term.numberArguments(); ++i) {
                if (!rootset.contains(i) || term.queryArgument(i).isTheoryTerm()) continue;
                rootset.remove(i);
            }
        }
    }

    private void imposeConsistencyLimitations(Problem dpp) {
        for (DP dp : dpp.getDPList()) {
            TreeSet<Variable> goodvars = new TreeSet<Variable>(dp.lvars());
            FunctionSymbol f = dp.lhs().queryRoot();
            for (int i : this._targs.get(f)) {
                for (Variable x : dp.lhs().queryArgument(i).vars()) {
                    goodvars.add(x);
                }
            }
            FunctionSymbol g = dp.rhs().queryRoot();
            TreeSet<Integer> badindexes = new TreeSet<Integer>();
            Iterator<Object> iterator = this._targs.get(g).iterator();
            block3: while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                for (Variable x : dp.rhs().queryArgument(j).vars()) {
                    if (goodvars.contains(x)) continue;
                    badindexes.add(j);
                    continue block3;
                }
            }
            iterator = badindexes.iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                this._targs.get(g).remove(j);
            }
        }
    }

    private boolean checkFixes(DP dp) {
        Term lhs = dp.lhs();
        FunctionSymbol f = lhs.queryRoot();
        for (int i : this._targs.get(f)) {
            Term arg = lhs.queryArgument(i);
            for (Variable x : arg.vars()) {
                if (dp.lvars().contains(x)) continue;
                return false;
            }
        }
        return true;
    }

    private void ensureFixes(DP dp) {
        Term lhs = dp.lhs();
        FunctionSymbol f = lhs.queryRoot();
        TreeSet<Integer> rootset = this._targs.get(f);
        TreeSet<Integer> bad = new TreeSet<Integer>();
        block0: for (int i : rootset) {
            Term arg = lhs.queryArgument(i);
            for (Variable x : arg.vars()) {
                if (dp.lvars().contains(x)) continue;
                bad.add(i);
                continue block0;
            }
        }
        for (int i : bad) {
            rootset.remove(i);
        }
    }

    private DP updateVariables(DP dp, boolean innermost) {
        TreeSet<Variable> newvars = new TreeSet<Variable>(dp.lvars());
        Term lhs = dp.lhs();
        FunctionSymbol f = lhs.queryRoot();
        Term constraint = dp.constraint();
        for (int i : this._targs.get(f)) {
            Term arg = lhs.queryArgument(i);
            for (Variable x : arg.vars()) {
                newvars.add(x);
                if (!innermost) continue;
                Term eq = TheoryFactory.createEquality(x, x);
                constraint = TheoryFactory.createConjunction(constraint, eq);
            }
        }
        return new DP(lhs, dp.rhs(), constraint, newvars);
    }

    @Override
    public TAProofObject processDPP(Problem dpp) {
        this.setupInitialArgumentsFunction(dpp);
        this.imposeMinimalLimitations(dpp);
        if (this._fixPublic) {
            return this.transform(dpp);
        }
        return this.fixSomething(dpp);
    }

    private TAProofObject transform(Problem dpp) {
        List<DP> dps = dpp.getDPList();
        for (int i = 0; i < dps.size(); ++i) {
            if (dpp.isPrivate(i)) continue;
            this.ensureFixes(dps.get(i));
        }
        this.imposeConsistencyLimitations(dpp);
        ArrayList<DP> newdps = new ArrayList<DP>();
        TreeSet<Integer> priv = new TreeSet<Integer>();
        boolean anythingChanged = false;
        for (int i = 0; i < dps.size(); ++i) {
            if (this.checkFixes(dps.get(i))) {
                newdps.add(dps.get(i));
            } else {
                anythingChanged = true;
                newdps.add(this.updateVariables(dps.get(i), dpp.isInnermost()));
            }
            if (!dpp.isPrivate(i)) continue;
            priv.add(i);
        }
        if (!anythingChanged) {
            return new TAProofObject(dpp);
        }
        Problem ret = new Problem(newdps, dpp.getRuleList(), priv, dpp.getOriginalTRS(), dpp.isInnermost(), dpp.hasExtraRules(), dpp.queryTerminationStatus());
        return new TAProofObject(dpp, ret);
    }

    private int getNumFixed(Problem dpp) {
        int numfixed = 0;
        for (DP dp : dpp.getDPList()) {
            if (!this.checkFixes(dp)) continue;
            ++numfixed;
        }
        return numfixed;
    }

    private TAProofObject fixSomething(Problem dpp) {
        this.imposeConsistencyLimitations(dpp);
        List<DP> dps = dpp.getDPList();
        int numfixed = this.getNumFixed(dpp);
        if (numfixed == dps.size()) {
            return new TAProofObject(dpp);
        }
        if (numfixed == 0) {
            this.ensureFixes(dps.get(0));
            this.imposeConsistencyLimitations(dpp);
            numfixed = this.getNumFixed(dpp);
            if (numfixed == dps.size() || numfixed == 0) {
                return new TAProofObject(dpp);
            }
        }
        ArrayList<DP> newdpsA = new ArrayList<DP>();
        ArrayList<DP> newdpsB = new ArrayList<DP>();
        TreeSet<Integer> privB = new TreeSet<Integer>();
        for (int i = 0; i < dps.size(); ++i) {
            DP dp = dps.get(i);
            if (this.checkFixes(dp)) {
                newdpsA.add(dp);
                continue;
            }
            if (dpp.isPrivate(i)) {
                privB.add(newdpsB.size());
            }
            newdpsB.add(dp);
            newdpsA.add(this.updateVariables(dp, dpp.isInnermost()));
        }
        Problem retA = new Problem(newdpsA, dpp.getRuleList(), new TreeSet<Integer>(), dpp.getOriginalTRS(), dpp.isInnermost(), dpp.hasExtraRules(), dpp.queryTerminationStatus());
        Problem retB = new Problem(newdpsB, dpp.getRuleList(), privB, dpp.getOriginalTRS(), dpp.isInnermost(), dpp.hasExtraRules(), dpp.queryTerminationStatus());
        return new TAProofObject(dpp, List.of(retA, retB));
    }

    private class TAProofObject
    extends ProcessorProofObject {
        public TAProofObject(Problem inp) {
            super(inp);
        }

        public TAProofObject(Problem inp, Problem out) {
            super(inp, out);
        }

        public TAProofObject(Problem inp, List<Problem> out) {
            super(inp, out);
        }

        @Override
        public String queryProcessorName() {
            return "Theory Arguments";
        }

        @Override
        public void justify(OutputModule module) {
            if (this._output.size() == 1) {
                module.println("We use the following theory arguments function, which fixes all public dependency pairs:", new Object[0]);
            } else {
                module.println("We use the following theory arguments function:", new Object[0]);
            }
            module.startTable();
            for (FunctionSymbol f : TheoryArgumentsProcessor.this._targs.keySet()) {
                module.nextColumn("%a", f.toString());
                module.nextColumn(":", new Object[0]);
                module.println("%a", TheoryArgumentsProcessor.this._targs.get(f).toString());
            }
            module.endTable();
        }
    }
}

