/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors;

import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.Variable;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsFactory;
import charlie.trs.TrsProperties;
import charlie.util.FixedList;
import cora.config.Settings;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.Processor;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import cora.termination.dependency_pairs.processors.URProofObject;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class UsableRulesProcessor
implements Processor {
    @Override
    public boolean isApplicable(Problem dpp) {
        return dpp.isInnermost() && !Settings.isDisabled(UsableRulesProcessor.queryDisabledCode()) && dpp.getOriginalTRS().verifyProperties(TrsProperties.Level.APPLICATIVE, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.PATTERN, TrsProperties.Root.THEORY, TrsProperties.FreshRight.CVARS, new TRS.RuleScheme[0]);
    }

    public static String queryDisabledCode() {
        return "ur";
    }

    private TreeMap<FunctionSymbol, LinkedList<Rule>> indexRulesByRoot(FixedList<Rule> source) {
        TreeMap<FunctionSymbol, LinkedList<Rule>> ret = new TreeMap<FunctionSymbol, LinkedList<Rule>>();
        for (Rule rho : source) {
            FunctionSymbol f = rho.queryRoot();
            LinkedList<Rule> lst = ret.get(f);
            if (lst == null) {
                lst = new LinkedList();
                ret.put(f, lst);
            }
            lst.add(rho);
        }
        return ret;
    }

    private TreeMap<FunctionSymbol, TreeSet<Integer>> computeUsableSymbols(Problem dpp, TreeMap<FunctionSymbol, LinkedList<Rule>> index) {
        TreeMap<FunctionSymbol, TreeSet<Integer>> ret = new TreeMap<FunctionSymbol, TreeSet<Integer>>();
        LinkedList<Term> todo = new LinkedList<Term>();
        BoolWrapper containsBad = new BoolWrapper(this);
        containsBad.b = false;
        for (DP dp : dpp.getDPList()) {
            todo.add(dp.rhs());
        }
        while (!todo.isEmpty() && !containsBad.b) {
            Term t = (Term)todo.pop();
            t.visitSubterms((s, p) -> {
                if (s.isVarTerm() && s.numberArguments() > 0) {
                    containsBad.b = true;
                }
                if (s.isFunctionalTerm()) {
                    FunctionSymbol f = s.queryRoot();
                    this.updateUsableSymbols(f, s.numberArguments(), (LinkedList)index.get(f), ret, todo);
                }
            });
            if (!containsBad.b) continue;
            return null;
        }
        return ret;
    }

    private void updateUsableSymbols(FunctionSymbol f, int n, LinkedList<Rule> rules, TreeMap<FunctionSymbol, TreeSet<Integer>> symbols, LinkedList<Term> todo) {
        if (rules == null) {
            return;
        }
        TreeSet<Integer> set = symbols.get(f);
        if (set == null) {
            set = new TreeSet();
            symbols.put(f, set);
        } else if (set.contains(n)) {
            return;
        }
        set.add(n);
        for (Rule rule : rules) {
            int k = rule.queryLeftSide().numberArguments();
            if (k > n) continue;
            Term t = rule.queryRightSide();
            while (k < n) {
                Variable x = TermFactory.createVar(t.queryType().subtype(1));
                t = t.apply(x);
                ++k;
            }
            todo.add(t);
        }
    }

    String printUsableSymbols(Problem dpp) {
        TreeMap<FunctionSymbol, LinkedList<Rule>> index = this.indexRulesByRoot(dpp.getRuleList());
        TreeMap<FunctionSymbol, TreeSet<Integer>> ret = this.computeUsableSymbols(dpp, index);
        if (ret == null) {
            return "NA";
        }
        StringBuilder answer = new StringBuilder();
        for (Map.Entry<FunctionSymbol, TreeSet<Integer>> entry : ret.entrySet()) {
            for (int i : entry.getValue()) {
                answer.append("(" + String.valueOf(entry.getKey()) + "," + i + ") ");
            }
        }
        return answer.toString();
    }

    private Rule getUsableForm(Rule rho, TreeSet<Integer> usableIndexes) {
        Term left = rho.queryLeftSide();
        FunctionSymbol f = left.queryRoot();
        int k = left.numberArguments();
        for (int n : usableIndexes) {
            if (n < k) continue;
            if (n == k) {
                return rho;
            }
            Term right = rho.queryRightSide();
            for (int i = k + 1; i <= n; ++i) {
                Variable x = TermFactory.createVar("arg" + (i + 1), left.queryType().subtype(1));
                left = left.apply(x);
                right = right.apply(x);
            }
            return TrsFactory.createRule(left, right, rho.queryConstraint());
        }
        return null;
    }

    private FixedList<Rule> computeUsableRules(TreeMap<FunctionSymbol, TreeSet<Integer>> usableSymbs, TreeMap<FunctionSymbol, LinkedList<Rule>> index, int originalRuleCount) {
        int rulesFromOriginal = 0;
        FixedList.Builder<Rule> ret = new FixedList.Builder<Rule>();
        for (Map.Entry<FunctionSymbol, TreeSet<Integer>> entry : usableSymbs.entrySet()) {
            FunctionSymbol f = entry.getKey();
            LinkedList<Rule> relevant = index.get(f);
            if (relevant == null) continue;
            for (Rule rho : relevant) {
                Rule rule = this.getUsableForm(rho, entry.getValue());
                if (rule != null) {
                    ret.add(rule);
                }
                if (rule != rho) continue;
                ++rulesFromOriginal;
            }
        }
        if (rulesFromOriginal == originalRuleCount) {
            return null;
        }
        return ret.build();
    }

    @Override
    public ProcessorProofObject processDPP(Problem dpp) {
        FixedList<Rule> orgrules = dpp.getRuleList();
        TreeMap<FunctionSymbol, LinkedList<Rule>> index = this.indexRulesByRoot(orgrules);
        TreeMap<FunctionSymbol, TreeSet<Integer>> usableSymbols = this.computeUsableSymbols(dpp, index);
        if (usableSymbols == null) {
            return new URProofObject(dpp, "The Usable Rules method is not applicable.");
        }
        FixedList<Rule> ret = this.computeUsableRules(usableSymbols, index, orgrules.size());
        Object message = null;
        if (ret == null) {
            if (!dpp.hasExtraRules()) {
                return new URProofObject(dpp, "All rules are usable.");
            }
            ret = orgrules;
            message = "All known rules are usable, but the Usable Rules method is applicable so the extra rules are not usable, and may be dropped.";
        }
        Problem result = new Problem(dpp.getDPList(), ret, dpp.queryPrivateIndexes(), dpp.getOriginalTRS(), dpp.isInnermost(), false, dpp.queryTerminationStatus());
        if (message == null) {
            message = "We obtain " + ret.size() + " usable rules (out of " + orgrules.size() + " rules in the input problem).";
        }
        return new URProofObject(dpp, result, (String)message);
    }

    private class BoolWrapper {
        boolean b;

        private BoolWrapper(UsableRulesProcessor usableRulesProcessor) {
        }
    }
}

