/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors.graph;

import charlie.substitution.MutableSubstitution;
import charlie.terms.Environment;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.theorytranslation.TermAnalyser;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsProperties;
import charlie.util.FixedList;
import charlie.util.NullStorageException;
import charlie.util.Pair;
import cora.config.Settings;
import cora.termination.dependency_pairs.DP;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;

class ApproximateReducer {
    private TRS _coreTRS;
    private FixedList<Rule> _rules;

    public ApproximateReducer(TRS trs) {
        if (trs == null) {
            throw new NullStorageException("ApproximateReducer", "trs argument.");
        }
        this._coreTRS = trs;
        this._rules = trs.queryRules();
    }

    public ApproximateReducer(TRS trs, FixedList<Rule> rules) {
        if (trs == null) {
            throw new NullStorageException("ApproximateReducer", "trs argument.");
        }
        this._coreTRS = trs;
        this._rules = rules;
    }

    public boolean isApplicable() {
        if (!this._coreTRS.verifyProperties(TrsProperties.Level.APPLICATIVE, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.NONPATTERN, TrsProperties.Root.ANY, TrsProperties.FreshRight.CVARS, new TRS.RuleScheme[0])) {
            return false;
        }
        for (Rule rule : this._rules) {
            if (!rule.queryLeftSide().isFunctionalTerm()) {
                return false;
            }
            if (rule.queryLeftSide().isPattern()) continue;
            return false;
        }
        return true;
    }

    static DP rename(DP dp) {
        MutableSubstitution subst = new MutableSubstitution();
        for (Variable x : dp.lhs().vars()) {
            if (subst.get(x) != null) continue;
            subst.extend(x, TermFactory.createVar(x.queryName(), x.queryType()));
        }
        for (Variable x : dp.rhs().vars()) {
            if (subst.get(x) != null) continue;
            subst.extend(x, TermFactory.createVar(x.queryName(), x.queryType()));
        }
        for (Variable x : dp.constraint().vars()) {
            if (subst.get(x) != null) continue;
            subst.extend(x, TermFactory.createVar(x.queryName(), x.queryType()));
        }
        Term newleft = subst.substitute(dp.lhs());
        Term newright = subst.substitute(dp.rhs());
        Term newconstraint = subst.substitute(dp.constraint());
        TreeSet<Variable> theory = new TreeSet<Variable>();
        for (Variable x : dp.lvars()) {
            if (subst.get(x) == null) continue;
            theory.add(subst.get(x).queryVariable());
        }
        return new DP(newleft, newright, newconstraint, theory);
    }

    private Term makeAnd(Term phi, Term psi) {
        return TheoryFactory.createConjunction(phi, psi);
    }

    TreeMap<FunctionSymbol, Integer> computeRuleArities() {
        TreeMap<FunctionSymbol, Integer> ret = new TreeMap<FunctionSymbol, Integer>();
        for (Rule rule : this._rules) {
            FunctionSymbol f = rule.queryLeftSide().queryRoot();
            int k = rule.queryLeftSide().numberArguments();
            if (ret.containsKey(f) && ret.get(f) <= k) continue;
            ret.put(f, k);
        }
        return ret;
    }

    private boolean allVarsInTheory(Environment<Variable> vars, Set<Variable> theory) {
        for (Variable x : vars) {
            if (theory.contains(x)) continue;
            return false;
        }
        return true;
    }

    public boolean mayReduce(DP dp1, DP dp2) {
        TreeMap<FunctionSymbol, Integer> ruleArity = this.computeRuleArities();
        dp2 = ApproximateReducer.rename(dp2);
        Stack<Pair<Term, Term>> todo = new Stack<Pair<Term, Term>>();
        todo.push(new Pair<Term, Term>(dp1.rhs(), dp2.lhs()));
        Term requirements = this.makeAnd(dp1.constraint(), dp2.constraint());
        while (!todo.isEmpty()) {
            int i;
            FunctionSymbol f;
            Pair pair = (Pair)todo.pop();
            Term from = (Term)pair.fst();
            Term to = (Term)pair.snd();
            if (from.isTheoryTerm() && from.queryType().isBaseType() && this.allVarsInTheory(from.vars(), dp1.lvars())) {
                if (!to.isTheoryTerm()) {
                    return false;
                }
                if (to.isValue() || to.isVariable()) {
                    requirements = this.makeAnd(requirements, TheoryFactory.createEquality(from, to));
                    continue;
                }
                if (from.isValue()) {
                    return false;
                }
                if (from.isVariable() && dp1.constraint().vars().contains(from.queryVariable())) {
                    return false;
                }
            }
            if (!from.isFunctionalTerm() || to.isVariable() && !dp2.lvars().contains(to.queryVariable()) || ruleArity.containsKey(f = from.queryRoot()) && ruleArity.get(f) <= from.numberArguments() || f.isTheorySymbol() && from.queryType().isBaseType() && to.isValue() || from.isTheoryTerm() && (to.isValue() || to.isVariable())) continue;
            if (to.isFunctionalTerm()) {
                if (!f.equals(to.queryRoot())) {
                    return false;
                }
                if (from.numberArguments() != to.numberArguments()) {
                    return false;
                }
                for (i = from.numberArguments(); i > 0; --i) {
                    todo.push(new Pair<Term, Term>(from.queryArgument(i), to.queryArgument(i)));
                }
                continue;
            }
            if (to.numberArguments() > from.numberArguments()) {
                return false;
            }
            if (!to.queryHead().isVariable()) {
                return false;
            }
            for (i = 0; i < to.numberArguments(); ++i) {
                Term a = from.queryArgument(from.numberArguments() - i);
                Term b = to.queryArgument(to.numberArguments() - i);
                if (!a.queryType().equals(b.queryType())) {
                    return false;
                }
                todo.push(new Pair<Term, Term>(a, b));
            }
        }
        return !(TermAnalyser.satisfy(requirements, Settings.smtSolver) instanceof TermAnalyser.Result.NO);
    }
}

