/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors.graph;

import cora.config.Settings;
import cora.data.digraph.Digraph;
import cora.data.digraph.SCC;
import cora.io.OutputModule;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.Processor;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import cora.termination.dependency_pairs.processors.graph.Approximator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GraphProcessor
implements Processor {
    public static String queryDisabledCode() {
        return "graph";
    }

    @Override
    public boolean isApplicable(Problem dpp) {
        return !Settings.isDisabled(GraphProcessor.queryDisabledCode());
    }

    private Digraph computeGraph(Problem dpp) {
        return Approximator.problemToGraph(dpp);
    }

    private List<Problem> computeAllSubproblems(Problem dpp, Digraph graphOfDPP) {
        SCC scc = new SCC(graphOfDPP);
        List<List> nonTrivalSCCs = scc.getSccData().stream().filter(component -> component.size() > 1 || component.size() == 1 && graphOfDPP.getNeighbours((Integer)component.getFirst()).contains(component.getFirst())).toList();
        int numberOfNontrivialSCCs = nonTrivalSCCs.size();
        ArrayList<Problem> subproblems = new ArrayList<Problem>(numberOfNontrivialSCCs);
        for (int i = 0; i < numberOfNontrivialSCCs; ++i) {
            List sccVertices = nonTrivalSCCs.get(i);
            ArrayList<DP> dps = new ArrayList<DP>();
            Iterator iterator = sccVertices.iterator();
            while (iterator.hasNext()) {
                int vertex = (Integer)iterator.next();
                dps.add(dpp.getDPList().get(vertex));
            }
            subproblems.add(new Problem(dps, dpp.getRuleList(), Set.of(), dpp.getOriginalTRS(), dpp.isInnermost(), dpp.hasExtraRules(), dpp.queryTerminationStatus()));
        }
        return subproblems;
    }

    @Override
    public ProcessorProofObject processDPP(Problem dpp) {
        Digraph graph = this.computeGraph(dpp);
        List<Problem> ret = this.computeAllSubproblems(dpp, graph);
        if (ret.size() == 1 && ret.get(0).getDPList().size() == dpp.getDPList().size()) {
            return new GraphProofObject(this, dpp, graph);
        }
        return new GraphProofObject(this, dpp, ret, graph);
    }

    private class GraphProofObject
    extends ProcessorProofObject {
        private Digraph _graph;

        public GraphProofObject(GraphProcessor graphProcessor, Problem inp, Digraph graph) {
            super(inp);
            this._graph = graph;
        }

        public GraphProofObject(GraphProcessor graphProcessor, Problem inp, List<Problem> out, Digraph graph) {
            super(inp, out);
            this._graph = graph;
        }

        @Override
        public String queryProcessorName() {
            return "Graph";
        }

        @Override
        public void justify(OutputModule module) {
            module.println("We compute a graph approximation with the following edges:", new Object[0]);
            module.startTable();
            for (int i = 0; i < this._input.getDPList().size(); ++i) {
                Set<Integer> neighbours = this._graph.getNeighbours(i);
                module.nextColumn(i + 1 + ":", new Object[0]);
                for (int n : neighbours) {
                    module.print(n + 1 + " ", new Object[0]);
                }
                module.println();
            }
            module.endTable();
            if (this._output == null) {
                module.println("All DPs are on the same SCC.", new Object[0]);
            } else if (this._output.size() == 0) {
                module.println("As there are no SCCs, this DP problem is removed.", new Object[0]);
            } else if (this._output.size() == 1) {
                module.println("There is only one SCC, so all DPs not inside the SCC can be removed.", new Object[0]);
            } else {
                module.println("There are " + this._output.size() + " SCCs.", new Object[0]);
            }
        }
    }
}

