/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors.graph;

import cora.config.Settings;
import cora.data.digraph.Digraph;
import cora.data.digraph.Reachability;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.Processor;
import cora.termination.dependency_pairs.processors.graph.Approximator;
import cora.termination.dependency_pairs.processors.graph.ReachabilityProofObject;
import java.util.ArrayList;
import java.util.HashSet;

public class ReachabilityProcessor
implements Processor {
    public static String queryDisabledCode() {
        return "reach";
    }

    @Override
    public boolean isApplicable(Problem dp) {
        return !Settings.isDisabled(ReachabilityProcessor.queryDisabledCode()) && dp.hasPrivateDPs();
    }

    @Override
    public ReachabilityProofObject processDPP(Problem dpp) {
        Digraph overApproximationGraph = Approximator.problemToGraph(dpp);
        int n = dpp.getDPList().size();
        ArrayList<Integer> publicDPsIndex = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            if (dpp.isPrivate(i)) continue;
            publicDPsIndex.add(i);
        }
        Reachability reachability = new Reachability(overApproximationGraph, publicDPsIndex);
        int m = reachability.getReachableVertices().size();
        if (n > m) {
            ArrayList<DP> newDPs = new ArrayList<DP>(m);
            HashSet<Integer> newPrivate = new HashSet<Integer>(m);
            for (int index : reachability.getReachableVertices()) {
                if (dpp.isPrivate(index)) {
                    newPrivate.add(newDPs.size());
                }
                newDPs.add(dpp.getDPList().get(index));
            }
            Problem ret = new Problem(newDPs, dpp.getRuleList(), newPrivate, dpp.getOriginalTRS(), dpp.isInnermost(), dpp.hasExtraRules(), dpp.queryTerminationStatus());
            return new ReachabilityProofObject(dpp, ret, overApproximationGraph);
        }
        return new ReachabilityProofObject(dpp, overApproximationGraph);
    }
}

