/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors.graph;

import cora.data.digraph.Digraph;
import cora.io.OutputModule;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import java.util.Set;

class ReachabilityProofObject
extends ProcessorProofObject {
    private Digraph _graph;

    public ReachabilityProofObject(Problem inp, Digraph graph) {
        super(inp);
        this._graph = graph;
    }

    public ReachabilityProofObject(Problem inp, Problem out, Digraph graph) {
        super(inp, out);
        this._graph = graph;
    }

    @Override
    public String queryProcessorName() {
        return "Reachability";
    }

    @Override
    public void justify(OutputModule module) {
        module.println("We compute a graph approximation with the following edges:", new Object[0]);
        module.startTable();
        for (int i = 0; i < this._input.getDPList().size(); ++i) {
            if (this._input.isPrivate(i)) {
                module.nextColumn("", new Object[0]);
            } else {
                module.nextColumn("!", new Object[0]);
            }
            Set<Integer> neighbours = this._graph.getNeighbours(i);
            module.nextColumn(i + 1 + ":", new Object[0]);
            for (int n : neighbours) {
                module.print(n + 1 + " ", new Object[0]);
            }
            module.println();
        }
        module.endTable();
        int num = this._input.getDPList().size();
        if (this._output.size() > 0) {
            num = this._input.getDPList().size() - ((Problem)this._output.get(0)).getDPList().size();
        }
        if (num == 0) {
            module.println("All dependency pairs are reachable.", new Object[0]);
        } else if (num == 1) {
            module.println("There is one unreachable dependency pair, which is removed.", new Object[0]);
        } else if (num == this._input.getDPList().size()) {
            module.println("There are no public dependency pairs, so clearly this problem is finite.", new Object[0]);
        } else {
            module.println("There are %a unreachable dependency pairs, which are removed.", num);
        }
    }
}

