/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors.redpair;

import charlie.terms.FunctionSymbol;
import charlie.terms.TermFactory;
import charlie.trs.Alphabet;
import charlie.types.Base;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.LookupMap;
import charlie.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

class AlphabetMap {
    private TreeMap<FunctionSymbol, TreeMap<Integer, FunctionSymbol>> _translation = new TreeMap();
    private TreeSet<String> _used = new TreeSet();
    private static final String BULLETSTR = "$";

    AlphabetMap() {
        this._used.add(BULLETSTR);
    }

    public FunctionSymbol getTranslation(FunctionSymbol f, int n) {
        TreeMap<Integer, FunctionSymbol> map = this._translation.get(f);
        if (map == null) {
            map = new TreeMap();
            this._translation.put(f, map);
        } else {
            FunctionSymbol ret = map.get(n);
            if (ret != null) {
                return ret;
            }
        }
        FunctionSymbol g = this.generateFresh(f, n);
        this._used.add(g.queryName());
        map.put(n, g);
        return g;
    }

    public Alphabet generateAlphabet() {
        LookupMap.Builder<FunctionSymbol> builder = new LookupMap.Builder<FunctionSymbol>();
        for (Map.Entry<FunctionSymbol, TreeMap<Integer, FunctionSymbol>> p1 : this._translation.entrySet()) {
            for (Map.Entry<Integer, FunctionSymbol> p2 : p1.getValue().entrySet()) {
                FunctionSymbol g = p2.getValue();
                builder.put(g.queryName(), g);
            }
        }
        return new Alphabet(builder.build());
    }

    public ArrayList<Pair<Pair<FunctionSymbol, Integer>, FunctionSymbol>> getAll() {
        ArrayList<Pair<Pair<FunctionSymbol, Integer>, FunctionSymbol>> ret = new ArrayList<Pair<Pair<FunctionSymbol, Integer>, FunctionSymbol>>();
        for (Map.Entry<FunctionSymbol, TreeMap<Integer, FunctionSymbol>> p1 : this._translation.entrySet()) {
            FunctionSymbol f = p1.getKey();
            for (Map.Entry<Integer, FunctionSymbol> p2 : p1.getValue().entrySet()) {
                int n = p2.getKey();
                FunctionSymbol g = p2.getValue();
                ret.add(new Pair<Pair<FunctionSymbol, Integer>, FunctionSymbol>(new Pair<FunctionSymbol, Integer>(f, n), g));
            }
        }
        return ret;
    }

    private FunctionSymbol generateFresh(FunctionSymbol f, int n) {
        String name = f.queryName() + n;
        if (this._used.contains(name)) {
            name = f.queryName() + "_" + n;
            while (this._used.contains(name)) {
                name = name + "'";
            }
        }
        Type type = f.queryType();
        ArrayList<Base> args = new ArrayList<Base>(n);
        for (int i = 1; i <= n; ++i) {
            args.add(this.sortFor(type.subtype(1)));
            type = type.subtype(2);
        }
        Type rettype = TypeFactory.createSortDeclaration(args, this.sortFor(type));
        FunctionSymbol g = TermFactory.createConstant(name, rettype);
        return g;
    }

    public FunctionSymbol generateBulletSymbol(Type t) {
        return TermFactory.createConstant(BULLETSTR, this.sortFor(t));
    }

    public Base sortFor(Type type) {
        if (type instanceof Base) {
            Base b = (Base)type;
            return b;
        }
        return TypeFactory.createSort("[" + type.toString() + "]");
    }
}

