/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors.redpair;

import charlie.smt.SmtProblem;
import charlie.trs.Rule;
import cora.config.Settings;
import cora.io.ProofObject;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.Processor;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import cora.termination.dependency_pairs.processors.redpair.RPProofObject;
import cora.termination.reduction_pairs.ArgumentFilter;
import cora.termination.reduction_pairs.OrderingProblem;
import cora.termination.reduction_pairs.OrderingRequirement;
import cora.termination.reduction_pairs.ReductionPair;
import cora.termination.reduction_pairs.ReductionPairProofObject;
import java.util.List;
import java.util.TreeSet;

public class ReductionPairProcessor
implements Processor {
    private ReductionPair _redpair;
    private static Problem _cachedDPP = null;
    private static SmtProblem _cachedSMT = null;
    private static OrderingProblem _cachedOP = null;

    public ReductionPairProcessor(ReductionPair rp) {
        this._redpair = rp;
    }

    public static String queryDisabledCode() {
        return "redpair";
    }

    private OrderingProblem makeOProb(Problem dpp) {
        if (dpp == _cachedDPP) {
            return _cachedOP;
        }
        _cachedSMT = new SmtProblem();
        OrderingProblem oprob = new OrderingProblem(dpp.getOriginalTRS(), new ArgumentFilter(_cachedSMT));
        List<DP> dps = dpp.getDPList();
        for (int i = 0; i < dps.size(); ++i) {
            DP dp = dps.get(i);
            oprob.requireEither(new OrderingRequirement(dp.lhs(), dp.rhs(), dp.constraint(), OrderingRequirement.Relation.Strict, dp.lvars()), i);
        }
        for (Rule rule : dpp.getRuleList()) {
            oprob.require(new OrderingRequirement(rule, OrderingRequirement.Relation.Weak));
        }
        _cachedDPP = dpp;
        _cachedOP = oprob;
        return oprob;
    }

    @Override
    public boolean isApplicable(Problem dpp) {
        return !Settings.isDisabled(ReductionPairProcessor.queryDisabledCode()) && !dpp.hasExtraRules() && this._redpair.isApplicable(this.makeOProb(dpp));
    }

    @Override
    public ProcessorProofObject processDPP(Problem dpp) {
        OrderingProblem oprob = this.makeOProb(dpp);
        String name = this._redpair.toString();
        if (!this._redpair.isApplicable(oprob)) {
            return new RPProofObject(name, dpp);
        }
        ReductionPairProofObject result = this._redpair.solve(oprob, _cachedSMT);
        _cachedOP = null;
        _cachedSMT = null;
        _cachedDPP = null;
        if (result.queryAnswer() == ProofObject.Answer.YES) {
            TreeSet<Integer> remove = new TreeSet<Integer>();
            List<DP> dps = dpp.getDPList();
            for (int i = 0; i < dps.size(); ++i) {
                if (!result.isStrictlyOriented(i)) continue;
                remove.add(i);
            }
            Problem altered = dpp.removeDPs(remove, true);
            return new RPProofObject(name, dpp, altered, result);
        }
        return new RPProofObject(name, dpp, result);
    }
}

