/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.dependency_pairs.processors.redpair;

import charlie.smt.BVar;
import charlie.smt.Constraint;
import charlie.smt.SmtFactory;
import charlie.smt.SmtProblem;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsFactory;
import charlie.trs.TrsProperties;
import charlie.types.Arrow;
import charlie.types.Base;
import charlie.types.Product;
import charlie.types.Type;
import charlie.util.Pair;
import cora.config.Settings;
import cora.io.ProofObject;
import cora.termination.dependency_pairs.DP;
import cora.termination.dependency_pairs.Problem;
import cora.termination.dependency_pairs.processors.Processor;
import cora.termination.dependency_pairs.processors.ProcessorProofObject;
import cora.termination.dependency_pairs.processors.redpair.AlphabetMap;
import cora.termination.dependency_pairs.processors.redpair.WrtProofObject;
import cora.termination.reduction_pairs.ArgumentFilter;
import cora.termination.reduction_pairs.OrderingProblem;
import cora.termination.reduction_pairs.OrderingRequirement;
import cora.termination.reduction_pairs.ReductionPair;
import cora.termination.reduction_pairs.ReductionPairProofObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class URWrtRedPairProcessor
implements Processor {
    private ReductionPair _redpair;

    public static String queryDisabledCode() {
        return "urwrt";
    }

    public URWrtRedPairProcessor(ReductionPair rp) {
        this._redpair = rp;
    }

    @Override
    public boolean isApplicable(Problem dpp) {
        return !Settings.isDisabled(URWrtRedPairProcessor.queryDisabledCode()) && dpp.isInnermost() && dpp.getOriginalTRS().verifyProperties(TrsProperties.Level.APPLICATIVE, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.PATTERN, TrsProperties.Root.THEORY, TrsProperties.FreshRight.CVARS, new TRS.RuleScheme[0]);
    }

    private Term translateTerm(AlphabetMap amap, TreeMap<Variable, Variable> vmap, Term t, Set<Variable> lvar) {
        if (t.queryType().isBaseType() && t.queryType().isTheoryType() && t.isTheoryTerm() && t.isFirstOrder()) {
            boolean ok = true;
            for (Variable x : t.vars()) {
                if (lvar.contains(x)) continue;
                ok = false;
                break;
            }
            if (ok) {
                return t;
            }
        }
        if (t.isVariable()) {
            Variable x = t.queryVariable();
            if (vmap.containsKey(x)) {
                return vmap.get(x);
            }
            Variable y = TermFactory.createVar(x.queryName(), amap.sortFor(x.queryType()));
            vmap.put(x, y);
            return y;
        }
        if (t.isFunctionalTerm()) {
            FunctionSymbol f = amap.getTranslation(t.queryRoot(), t.numberArguments());
            ArrayList<Term> args = new ArrayList<Term>(t.numberArguments());
            for (int i = 1; i <= t.numberArguments(); ++i) {
                args.add(this.translateTerm(amap, vmap, t.queryArgument(i), lvar));
            }
            return f.apply(args);
        }
        return amap.generateBulletSymbol(t.queryType());
    }

    private DP translateDP(AlphabetMap amap, DP dp) {
        TreeMap<Variable, Variable> vmap = new TreeMap<Variable, Variable>();
        Term lhs = this.translateTerm(amap, vmap, dp.lhs(), dp.lvars());
        Term rhs = this.translateTerm(amap, vmap, dp.rhs(), dp.lvars());
        return new DP(lhs, rhs, dp.constraint(), dp.lvars());
    }

    /*
     * Loose catch block
     */
    private void translateAndStoreRule(AlphabetMap amap, Rule rule, boolean constrained, ArrayList<Rule> storage) {
        block10: {
            TreeMap<Variable, Variable> vmap = new TreeMap<Variable, Variable>();
            Term lhs = rule.queryLeftSide();
            Term rhs = rule.queryRightSide();
            TreeSet<Variable> lvar = new TreeSet<Variable>(rule.queryLVars());
            int k = lhs.numberArguments() + 1;
            while (true) {
                Type sub;
                Type type2;
                Term l = this.translateTerm(amap, vmap, lhs, lvar);
                Term r = this.translateTerm(amap, vmap, rhs, lvar);
                Rule rho = constrained ? TrsFactory.createRule(l, r, rule.queryConstraint(), TrsFactory.LCTRS) : TrsFactory.createRule(l, r, TrsFactory.MSTRS);
                storage.add(rho);
                Objects.requireNonNull(lhs.queryType());
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class, Base.class, Product.class}, (Object)type2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Type type22;
                        Arrow arrow = (Arrow)type2;
                        Type in = type22 = arrow.left();
                        Type out = type22 = arrow.right();
                        Type type3 = in;
                        break;
                    }
                    case 1: {
                        Base x = (Base)type2;
                        Type type3 = null;
                        break;
                    }
                    case 2: {
                        Product x = (Product)type2;
                        Type type3 = sub = null;
                    }
                }
                if (sub != null) {
                    Variable x = TermFactory.createVar("arg" + k, sub);
                    lhs = lhs.apply(x);
                    rhs = rhs.apply(x);
                    ++k;
                    continue;
                }
                break block10;
                break;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeFilteredCalculationRule(FunctionSymbol original, FunctionSymbol filtered, ArrayList<Rule> storage) {
        ArrayList<Term> args = new ArrayList<Term>(original.queryArity());
        Type t = original.queryType();
        int i = 1;
        while (true) {
            Type out;
            if (!(t instanceof Arrow)) {
                Term left = filtered.apply(args);
                Variable right = TermFactory.createVar("y", t);
                Term constraint = TheoryFactory.createEquality(right, original.apply(args));
                storage.add(TrsFactory.createRule(left, right, constraint, TrsFactory.LCTRS));
                return;
            }
            Arrow arrow = (Arrow)t;
            try {
                Type type;
                Type in = type = arrow.left();
                out = type = arrow.right();
                args.add(TermFactory.createVar("x" + i, in));
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            t = out;
            ++i;
        }
    }

    private void storeUsableVariables(Rule rho, TreeMap<FunctionSymbol, BVar> map, SmtProblem smt) {
        FunctionSymbol f = rho.queryRoot();
        BVar x = map.get(f);
        if (x == null) {
            x = smt.createBooleanVariable("usable_{" + f.queryName() + "}");
            map.put(f, x);
        }
    }

    private OrderingRequirement createOrderingReq(DP dp) {
        return new OrderingRequirement(dp.lhs(), dp.rhs(), dp.constraint(), OrderingRequirement.Relation.Strict, dp.lvars());
    }

    private OrderingProblem makeOrderingProblem(Problem dpp, SmtProblem smt, ArgumentFilter filter, TreeMap<FunctionSymbol, BVar> conditions, AlphabetMap amap) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        ArrayList<DP> dps = new ArrayList<DP>();
        boolean constrained = dpp.getOriginalTRS().theoriesIncluded();
        for (DP dP : dpp.getDPList()) {
            dps.add(this.translateDP(amap, dP));
        }
        for (Rule rule : dpp.getRuleList()) {
            this.translateAndStoreRule(amap, rule, constrained, rules);
        }
        for (Pair pair : amap.getAll()) {
            if (!((FunctionSymbol)((Pair)pair.fst()).fst()).isTheorySymbol() || ((Integer)((Pair)pair.fst()).snd()).intValue() != ((FunctionSymbol)((Pair)pair.fst()).fst()).queryArity()) continue;
            this.storeFilteredCalculationRule((FunctionSymbol)((Pair)pair.fst()).fst(), (FunctionSymbol)pair.snd(), rules);
        }
        for (Rule rule : rules) {
            this.storeUsableVariables(rule, conditions, smt);
        }
        TRS trs = TrsFactory.createTrs(amap.generateAlphabet(), rules, constrained ? TrsFactory.LCTRS : TrsFactory.MSTRS);
        OrderingProblem orderingProblem = new OrderingProblem(trs, filter);
        for (int i = 0; i < dps.size(); ++i) {
            orderingProblem.requireEither(this.createOrderingReq((DP)dps.get(i)), i);
        }
        for (Rule rho : rules) {
            orderingProblem.requireConditionally(new OrderingRequirement(rho, OrderingRequirement.Relation.Weak), conditions.get(rho.queryRoot()));
        }
        return orderingProblem;
    }

    private void storeEquivalentRegards(AlphabetMap amap, ArgumentFilter filter, SmtProblem smt) {
        ArrayList<Pair<Pair<FunctionSymbol, Integer>, FunctionSymbol>> all = amap.getAll();
        for (Pair<Pair<FunctionSymbol, Integer>, FunctionSymbol> p : all) {
            FunctionSymbol f = p.fst().fst();
            int n = p.fst().snd();
            FunctionSymbol g = p.snd();
            for (int i = 1; i <= n; ++i) {
                smt.requireImplication(filter.regards(f, i), filter.regards(g, i));
                smt.requireImplication(filter.regards(g, i), filter.regards(f, i));
            }
        }
    }

    private void storeRegardsRequirements(AlphabetMap amap, Problem dpp, ArgumentFilter filter, TreeMap<FunctionSymbol, BVar> conditions, SmtProblem smt) {
        ArrayList<Constraint> sofar = new ArrayList<Constraint>();
        for (DP dp : dpp.getDPList()) {
            this.addUsableRequirements(dp.rhs(), sofar, filter, conditions, amap, dp.lvars(), smt);
        }
        for (Rule rho : dpp.getRuleList()) {
            FunctionSymbol f = rho.queryRoot();
            int k = rho.queryLeftSide().numberArguments();
            Term rhs = rho.queryRightSide();
            for (int n = k; n <= f.queryArity(); ++n) {
                Type in;
                Type type;
                FunctionSymbol g = amap.getTranslation(f, n);
                BVar x = conditions.get(g);
                conditions.put(g, null);
                sofar.add(x.negate());
                TreeSet<Variable> lvar = new TreeSet<Variable>(rho.queryLVars());
                this.addUsableRequirements(rhs, sofar, filter, conditions, amap, lvar, smt);
                conditions.put(g, x);
                sofar.clear();
                Type type2 = rhs.queryType();
                if (!(type2 instanceof Arrow)) continue;
                Arrow arrow = (Arrow)type2;
                try {
                    in = type = arrow.left();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Type out = type = arrow.right();
                rhs = rhs.apply(TermFactory.createVar(in));
            }
        }
    }

    private void addUsableRequirements(Term term, ArrayList<Constraint> sofar, ArgumentFilter filter, TreeMap<FunctionSymbol, BVar> conditions, AlphabetMap amap, Set<Variable> lvar, SmtProblem smt) {
        if (term.isVariable()) {
            return;
        }
        if (term.queryType().isBaseType() && term.queryType().isTheoryType() && term.isTheoryTerm() && term.isFirstOrder()) {
            boolean ok = true;
            for (Variable x : term.vars()) {
                if (lvar.contains(x)) continue;
                ok = false;
                break;
            }
            if (ok) {
                return;
            }
        }
        if (term.isFunctionalTerm()) {
            int n;
            FunctionSymbol f = term.queryRoot();
            FunctionSymbol g = amap.getTranslation(f, n = term.numberArguments());
            BVar bvar = conditions.get(g);
            if (bvar != null) {
                sofar.add(bvar);
                smt.require(SmtFactory.createDisjunction(sofar));
                sofar.remove(sofar.size() - 1);
            }
            int k = term.numberArguments();
            for (int i = 1; i <= k; ++i) {
                sofar.add(filter.regards(g, i).negate());
                this.addUsableRequirements(term.queryArgument(i), sofar, filter, conditions, amap, lvar, smt);
                sofar.remove(sofar.size() - 1);
            }
        } else {
            smt.require(SmtFactory.createDisjunction(sofar));
        }
    }

    private void storeHORuleRegardsRequirement(AlphabetMap amap, Problem dpp, ArgumentFilter filter, TreeMap<FunctionSymbol, BVar> conditions, SmtProblem smt) {
        for (Rule rule : dpp.getRuleList()) {
            Term lhs = rule.queryLeftSide();
            Term rhs = rule.queryRightSide();
            if (rhs.queryType().isBaseType() || !rhs.isFunctionalTerm()) continue;
            FunctionSymbol f = lhs.queryRoot();
            FunctionSymbol g = rhs.queryRoot();
            int k = rule.queryLeftSide().numberArguments();
            int p = rhs.numberArguments();
            for (int n = k + 1; n <= f.queryArity(); ++n) {
                FunctionSymbol fn = amap.getTranslation(f, n);
                for (int i = k + 1; i <= n; ++i) {
                    ArrayList<Constraint> parts = new ArrayList<Constraint>(3);
                    parts.add(conditions.get(fn).negate());
                    parts.add(filter.regards(f, i));
                    parts.add(filter.regards(g, p + i - k).negate());
                    smt.require(SmtFactory.createDisjunction(parts));
                }
            }
        }
    }

    @Override
    public ProcessorProofObject processDPP(Problem dpp) {
        SmtProblem smt = new SmtProblem();
        ArgumentFilter filter = new ArgumentFilter(smt);
        TreeMap<FunctionSymbol, BVar> conditions = new TreeMap<FunctionSymbol, BVar>();
        AlphabetMap amap = new AlphabetMap();
        OrderingProblem oprob = this.makeOrderingProblem(dpp, smt, filter, conditions, amap);
        this.storeEquivalentRegards(amap, filter, smt);
        this.storeRegardsRequirements(amap, dpp, filter, conditions, smt);
        this.storeHORuleRegardsRequirement(amap, dpp, filter, conditions, smt);
        if (!this._redpair.isApplicable(oprob)) {
            return new WrtProofObject(dpp, this._redpair.queryName());
        }
        ReductionPairProofObject ob = this._redpair.solve(oprob, smt);
        if (ob.queryAnswer() == ProofObject.Answer.YES) {
            TreeSet<Integer> remove = new TreeSet<Integer>();
            List<DP> dps = dpp.getDPList();
            for (int i = 0; i < dps.size(); ++i) {
                if (!ob.isStrictlyOriented(i)) continue;
                remove.add(i);
            }
            Problem altered = dpp.removeDPs(remove, true);
            return new WrtProofObject(dpp, altered, this._redpair.queryName(), ob);
        }
        return new WrtProofObject(dpp, this._redpair.queryName(), ob);
    }
}

