/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.reduction_pairs;

import charlie.smt.BVar;
import charlie.smt.SmtProblem;
import charlie.smt.Valuation;
import charlie.terms.FunctionSymbol;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;

public class ArgumentFilter {
    private SmtProblem _problem;
    private TreeMap<FunctionSymbol, TreeMap<Integer, BVar>> _variables;
    private boolean _strict;
    private BVar _everythingRegarded;

    public ArgumentFilter(SmtProblem problem) {
        this._problem = problem;
        this._variables = new TreeMap();
        this._strict = false;
        this._everythingRegarded = null;
    }

    public void forceEmpty() {
        if (this._strict) {
            return;
        }
        this._strict = true;
        if (this._everythingRegarded == null) {
            this._everythingRegarded = this._problem.createBooleanVariable("alwaystrue");
            for (Map.Entry<FunctionSymbol, TreeMap<Integer, BVar>> entry : this._variables.entrySet()) {
                for (Map.Entry<Integer, BVar> e : entry.getValue().entrySet()) {
                    this._problem.require(e.getValue());
                }
            }
        }
        this._problem.require(this._everythingRegarded);
    }

    public static ArgumentFilter createEmptyFilter(SmtProblem problem) {
        ArgumentFilter ret = new ArgumentFilter(problem);
        ret.forceEmpty();
        return ret;
    }

    public BVar regards(FunctionSymbol f, int index) {
        TreeMap<Integer, BVar> fmap;
        if (this._strict) {
            return this._everythingRegarded;
        }
        if (!this._variables.containsKey(f)) {
            this._variables.put(f, new TreeMap());
        }
        if ((fmap = this._variables.get(f)).containsKey(index)) {
            return fmap.get(index);
        }
        BVar newvar = this._problem.createBooleanVariable("regards{" + f.queryName() + "," + index + "}");
        fmap.put(index, newvar);
        if (this._everythingRegarded != null) {
            this._problem.requireImplication(this._everythingRegarded, newvar);
        }
        return newvar;
    }

    public BVar regardsEverything() {
        if (this._everythingRegarded == null) {
            this._everythingRegarded = this._problem.createBooleanVariable("regardsall");
            for (Map.Entry<FunctionSymbol, TreeMap<Integer, BVar>> entry : this._variables.entrySet()) {
                for (Map.Entry<Integer, BVar> e : entry.getValue().entrySet()) {
                    this._problem.requireImplication(this._everythingRegarded, e.getValue());
                }
            }
        }
        return this._everythingRegarded;
    }

    public BiFunction<FunctionSymbol, Integer, Boolean> getRegardedArguments(Valuation valuation) {
        TreeMap ret = new TreeMap();
        for (FunctionSymbol f2 : this._variables.keySet()) {
            TreeMap<Integer, BVar> map = this._variables.get(f2);
            TreeSet<Integer> tmp = null;
            for (Integer i2 : map.keySet()) {
                BVar x = map.get(i2);
                if (valuation.queryAssignment(x)) continue;
                if (tmp == null) {
                    tmp = new TreeSet<Integer>();
                    ret.put(f2, tmp);
                }
                tmp.add(i2);
            }
        }
        return (f, i) -> ret.containsKey(f) ? !((TreeSet)ret.get(f)).contains(i) : true;
    }

    public boolean everythingIsRegarded(Valuation valuation) {
        if (this._everythingRegarded != null && valuation.queryAssignment(this._everythingRegarded)) {
            return true;
        }
        for (Map.Entry<FunctionSymbol, TreeMap<Integer, BVar>> entry : this._variables.entrySet()) {
            for (Map.Entry<Integer, BVar> e : entry.getValue().entrySet()) {
                if (valuation.queryAssignment(e.getValue())) continue;
                return false;
            }
        }
        return true;
    }
}

