/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.reduction_pairs;

import charlie.smt.Constraint;
import charlie.trs.TRS;
import charlie.util.Pair;
import cora.termination.reduction_pairs.ArgumentFilter;
import cora.termination.reduction_pairs.OrderingRequirement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OrderingProblem {
    private List<OrderingRequirement> _alwaysReqs = new ArrayList<OrderingRequirement>();
    private List<Pair<Constraint, OrderingRequirement>> _conditionalReqs = new ArrayList<Pair<Constraint, OrderingRequirement>>();
    private List<Pair<Integer, OrderingRequirement>> _eitherReqs = new ArrayList<Pair<Integer, OrderingRequirement>>();
    private TRS _originalTRS;
    private ArgumentFilter _filter;

    public OrderingProblem(TRS original, ArgumentFilter regards) {
        this._originalTRS = original;
        this._filter = regards;
    }

    public TRS queryOriginalTRS() {
        return this._originalTRS;
    }

    public ArgumentFilter queryArgumentFilter() {
        return this._filter;
    }

    public void require(OrderingRequirement req) {
        this._alwaysReqs.add(req);
    }

    public void requireConditionally(OrderingRequirement req, Constraint constraint) {
        this._conditionalReqs.add(new Pair<Constraint, OrderingRequirement>(constraint, req));
    }

    public void requireEither(OrderingRequirement req, int identifier) {
        this._eitherReqs.add(new Pair<Integer, OrderingRequirement>(identifier, req));
    }

    public List<Pair<Integer, OrderingRequirement>> eitherReqs() {
        return Collections.unmodifiableList(this._eitherReqs);
    }

    public List<Pair<Constraint, OrderingRequirement>> conditionalReqs() {
        return Collections.unmodifiableList(this._conditionalReqs);
    }

    public List<OrderingRequirement> unconditionalReqs() {
        return Collections.unmodifiableList(this._alwaysReqs);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (OrderingRequirement orderingRequirement : this._alwaysReqs) {
            builder.append("U) " + orderingRequirement.toString() + "\n");
        }
        for (Pair pair : this._conditionalReqs) {
            builder.append("C) " + String.valueOf(pair.fst()) + "  ==>  " + String.valueOf(pair.snd()) + "\n");
        }
        for (Pair pair : this._eitherReqs) {
            builder.append("E) " + String.valueOf(pair.fst()) + "  :  " + String.valueOf(pair.snd()) + "\n");
        }
        return builder.toString();
    }
}

