/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.reduction_pairs;

import charlie.printer.PrintableObject;
import charlie.printer.Printer;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.trs.Rule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public record OrderingRequirement(Term left, Term right, Term constraint, Relation rel, Set<Variable> tvar) implements PrintableObject
{
    public OrderingRequirement(Term l, Term r, Term co, Relation relation, Collection<Variable> tv) {
        this(l, r, co, relation, Collections.unmodifiableSet(new TreeSet<Variable>(tv)));
    }

    public OrderingRequirement(Rule rho, Relation relation) {
        this(rho.queryLeftSide(), rho.queryRightSide(), rho.queryConstraint(), relation, Collections.unmodifiableSet(new TreeSet<Variable>(rho.queryLVars())));
    }

    @Override
    public void print(Printer printer) {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(this.left);
        components.add(" ");
        components.add(switch (this.rel.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> printer.symbSucc();
            case 1 -> printer.symbSucceq();
        });
        components.add(" ");
        components.add(this.right);
        if (!this.constraint.isValue() || !this.constraint.toValue().getBool()) {
            components.add(" | ");
            components.add(this.constraint);
        }
        if (!this.allVarsInConstraint()) {
            components.add(" { ");
            for (Variable x : this.tvar) {
                if (!this.left.vars().contains(x) && !this.right.vars().contains(x) && !this.constraint.vars().contains(x)) continue;
                components.add(x);
                components.add(" ");
            }
            components.add("}");
        }
        printer.add(components);
    }

    private boolean allVarsInConstraint() {
        for (Variable x : this.tvar) {
            if (this.constraint.vars().contains(x) || !this.left.vars().contains(x) && !this.right.vars().contains(x)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.left.toString() + " " + String.valueOf((Object)this.rel) + " " + this.right.toString() + " | " + this.constraint.toString() + " {" + this.tvar.toString() + " }";
    }

    public static enum Relation {
        Strict,
        Weak;

    }
}

