/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.reduction_pairs;

import charlie.terms.FunctionSymbol;
import charlie.util.Pair;
import cora.io.OutputModule;
import cora.io.ProofObject;
import cora.termination.reduction_pairs.OrderingProblem;
import cora.termination.reduction_pairs.OrderingRequirement;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.BiFunction;

public abstract class ReductionPairProofObject
implements ProofObject {
    protected Set<Integer> _strictlyOriented;
    protected ArrayList<OrderingRequirement> _reqs;
    protected BiFunction<FunctionSymbol, Integer, Boolean> _regards;

    protected ReductionPairProofObject(OrderingProblem problem, Set<Integer> strictlyOriented, Set<Integer> conditionSatisfied, BiFunction<FunctionSymbol, Integer, Boolean> regards) {
        this._strictlyOriented = strictlyOriented;
        this._reqs = new ArrayList();
        this._regards = regards;
        for (Pair<Integer, OrderingRequirement> p : problem.eitherReqs()) {
            OrderingRequirement.Relation rel = strictlyOriented.contains(p.fst()) ? OrderingRequirement.Relation.Strict : OrderingRequirement.Relation.Weak;
            this._reqs.add(new OrderingRequirement(p.snd().left(), p.snd().right(), p.snd().constraint(), rel, p.snd().tvar()));
        }
        this._reqs.addAll(problem.unconditionalReqs());
        int n = problem.conditionalReqs().size();
        for (int i = 0; i < n; ++i) {
            if (!conditionSatisfied.contains(i)) continue;
            this._reqs.add(problem.conditionalReqs().get(i).snd());
        }
    }

    protected ReductionPairProofObject(OrderingProblem problem) {
        this._strictlyOriented = null;
        this._reqs = null;
        this._regards = null;
    }

    @Override
    public ProofObject.Answer queryAnswer() {
        if (this._reqs == null) {
            return ProofObject.Answer.MAYBE;
        }
        return ProofObject.Answer.YES;
    }

    public final boolean isStrictlyOriented(int identifier) {
        if (this._strictlyOriented == null) {
            return false;
        }
        return this._strictlyOriented.contains(identifier);
    }

    public final boolean regards(FunctionSymbol f, int index) {
        if (this._regards == null) {
            return false;
        }
        return this._regards.apply(f, index);
    }

    protected void printOrderingProblem(OutputModule module) {
        module.startTable();
        for (OrderingRequirement req : this._reqs) {
            module.println("%a", req);
        }
        module.endTable();
    }

    @Override
    public abstract void justify(OutputModule var1);
}

