/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.reduction_pairs;

import charlie.smt.SmtProblem;
import charlie.trs.Rule;
import charlie.trs.TRS;
import cora.io.ProofObject;
import cora.termination.reduction_pairs.ArgumentFilter;
import cora.termination.reduction_pairs.OrderingProblem;
import cora.termination.reduction_pairs.OrderingRequirement;
import cora.termination.reduction_pairs.ReductionPair;
import cora.termination.reduction_pairs.ReductionPairNotApplicableProofObject;

public class ReductionPairTerminationProver {
    private ReductionPair _reductionPair;

    public ReductionPairTerminationProver(ReductionPair redpair) {
        this._reductionPair = redpair;
        if (!redpair.isStronglyMonotonic()) {
            throw new IllegalArgumentException("The ReductionPairTerminationProver may only be called with a strongly monotonic reduction pair; I was given " + redpair.toString());
        }
    }

    public ProofObject proveTermination(TRS trs) {
        SmtProblem smt = new SmtProblem();
        OrderingProblem prob = new OrderingProblem(trs, ArgumentFilter.createEmptyFilter(smt));
        for (Rule rule : trs.queryRules()) {
            prob.require(new OrderingRequirement(rule, OrderingRequirement.Relation.Strict));
        }
        if (!this._reductionPair.isApplicable(prob)) {
            return new ReductionPairNotApplicableProofObject(this._reductionPair.toString());
        }
        return this._reductionPair.solve(prob, smt);
    }
}

