/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.reduction_pairs.horpo;

import charlie.smt.BVar;
import charlie.smt.Constraint;
import charlie.smt.SmtFactory;
import charlie.smt.SmtProblem;
import charlie.smt.SmtSolver;
import charlie.smt.Valuation;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermPrinter;
import charlie.terms.Value;
import charlie.terms.Variable;
import charlie.trs.TRS;
import charlie.trs.TrsProperties;
import charlie.types.TypeFactory;
import charlie.util.Pair;
import cora.config.Settings;
import cora.termination.reduction_pairs.ArgumentFilter;
import cora.termination.reduction_pairs.OrderingProblem;
import cora.termination.reduction_pairs.OrderingRequirement;
import cora.termination.reduction_pairs.ReductionPair;
import cora.termination.reduction_pairs.ReductionPairProofObject;
import cora.termination.reduction_pairs.horpo.HorpoConstraintList;
import cora.termination.reduction_pairs.horpo.HorpoParameters;
import cora.termination.reduction_pairs.horpo.HorpoResult;
import cora.termination.reduction_pairs.horpo.HorpoSimplifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Horpo
implements ReductionPair {
    private boolean _strong;

    public Horpo(boolean stronglyMonotonic) {
        this._strong = stronglyMonotonic;
    }

    public static String queryDisabledCode() {
        return "horpo";
    }

    @Override
    public boolean isStronglyMonotonic() {
        return this._strong;
    }

    @Override
    public boolean isApplicable(OrderingProblem prob) {
        return !Settings.isDisabled(Horpo.queryDisabledCode()) && prob.queryOriginalTRS().verifyProperties(TrsProperties.Level.APPLICATIVE, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.NONPATTERN, TrsProperties.Root.ANY, TrsProperties.FreshRight.ANY, new TRS.RuleScheme[0]);
    }

    @Override
    public String queryName() {
        if (this._strong) {
            return "strict-HORPO";
        }
        return "HORPO";
    }

    public String toString() {
        return this.queryName();
    }

    @Override
    public ReductionPairProofObject solve(OrderingProblem problem, SmtProblem smt) {
        int bound = this.computeIntegerVariableBound(problem);
        TreeSet<FunctionSymbol> symbols = this.getFunctionSymbols(problem);
        ArgumentFilter filter = problem.queryArgumentFilter();
        HorpoParameters param = new HorpoParameters(bound, symbols, filter, smt);
        TermPrinter printer = new TermPrinter(this.getFunctionSymbolNames(symbols));
        HorpoConstraintList lst = new HorpoConstraintList(printer, smt);
        TreeMap<Integer, BVar> choices = this.setupConstraintList(lst, problem, smt);
        if (this._strong) {
            filter.forceEmpty();
        }
        HorpoSimplifier simplifier = new HorpoSimplifier(param, lst, filter);
        for (int i = 0; i < lst.size(); ++i) {
            simplifier.simplify(lst.get(i));
        }
        return this.finish(problem, choices, param, lst);
    }

    private void addTerms(LinkedList<Term> terms, OrderingRequirement req) {
        terms.add(req.left());
        terms.add(req.right());
        terms.add(req.constraint());
    }

    private LinkedList<Term> getAllTerms(OrderingProblem problem) {
        LinkedList<Term> ret = new LinkedList<Term>();
        for (OrderingRequirement orderingRequirement : problem.unconditionalReqs()) {
            this.addTerms(ret, orderingRequirement);
        }
        for (Pair pair : problem.conditionalReqs()) {
            this.addTerms(ret, (OrderingRequirement)pair.snd());
        }
        for (Pair pair : problem.eitherReqs()) {
            this.addTerms(ret, (OrderingRequirement)pair.snd());
        }
        return ret;
    }

    private LinkedList<Pair<Term, Set<Variable>>> getSideTerms(OrderingProblem problem) {
        OrderingRequirement req;
        LinkedList<Pair<Term, Set<Variable>>> ret = new LinkedList<Pair<Term, Set<Variable>>>();
        for (OrderingRequirement orderingRequirement : problem.unconditionalReqs()) {
            ret.add(new Pair<Term, Set<Variable>>(orderingRequirement.left(), orderingRequirement.tvar()));
            ret.add(new Pair<Term, Set<Variable>>(orderingRequirement.right(), orderingRequirement.tvar()));
        }
        for (Pair pair : problem.conditionalReqs()) {
            req = (OrderingRequirement)pair.snd();
            ret.add(new Pair<Term, Set<Variable>>(req.left(), req.tvar()));
            ret.add(new Pair<Term, Set<Variable>>(req.right(), req.tvar()));
        }
        for (Pair pair : problem.eitherReqs()) {
            req = (OrderingRequirement)pair.snd();
            ret.add(new Pair<Term, Set<Variable>>(req.left(), req.tvar()));
            ret.add(new Pair<Term, Set<Variable>>(req.right(), req.tvar()));
        }
        return ret;
    }

    private int computeIntegerVariableBound(OrderingProblem problem) {
        IntWrapper wrapper = new IntWrapper(this, 500);
        for (Term term : this.getAllTerms(problem)) {
            term.visitSubterms((s, p) -> {
                if (s.isValue() && s.queryType().equals(TypeFactory.intSort)) {
                    Value value = s.toValue();
                    if (value.getInt() > wrapper.num) {
                        wrapper.num = value.getInt();
                    }
                    if (-value.getInt() > wrapper.num) {
                        wrapper.num = -value.getInt();
                    }
                }
            });
        }
        return wrapper.num * 2;
    }

    private TreeSet<FunctionSymbol> getFunctionSymbols(OrderingProblem problem) {
        LinkedList<Pair<Term, Set<Variable>>> relevant = this.getSideTerms(problem);
        TreeSet<FunctionSymbol> symbs = new TreeSet<FunctionSymbol>();
        for (Pair pair : relevant) {
            Set set = (Set)pair.snd();
            ((Term)pair.fst()).visitSubterms((s, pos) -> {
                if (s.isFunctionalTerm()) {
                    if (s.isTheoryTerm() && s.queryType().isBaseType()) {
                        for (Variable x : s.vars()) {
                            if (set.contains(x)) continue;
                            symbs.add(s.queryRoot());
                            break;
                        }
                    } else {
                        symbs.add(s.queryRoot());
                    }
                }
            });
        }
        return symbs;
    }

    private TreeSet<String> getFunctionSymbolNames(TreeSet<FunctionSymbol> symbols) {
        TreeSet<String> ret = new TreeSet<String>();
        for (FunctionSymbol f : symbols) {
            ret.add(f.queryName());
        }
        return ret;
    }

    private TreeMap<Integer, BVar> setupConstraintList(HorpoConstraintList lst, OrderingProblem problem, SmtProblem smt) {
        BVar x;
        for (OrderingRequirement orderingRequirement : problem.unconditionalReqs()) {
            HorpoConstraintList.HRelation rel = switch (orderingRequirement.rel()) {
                default -> throw new MatchException(null, null);
                case OrderingRequirement.Relation.Strict -> HorpoConstraintList.HRelation.GREATER;
                case OrderingRequirement.Relation.Weak -> HorpoConstraintList.HRelation.GEQ;
            };
            x = lst.store(orderingRequirement.left(), rel, orderingRequirement.right(), orderingRequirement.constraint(), orderingRequirement.tvar());
            smt.require(x);
        }
        for (Pair pair : problem.conditionalReqs()) {
            OrderingRequirement req = (OrderingRequirement)pair.snd();
            HorpoConstraintList.HRelation rel = switch (req.rel()) {
                default -> throw new MatchException(null, null);
                case OrderingRequirement.Relation.Strict -> HorpoConstraintList.HRelation.GREATER;
                case OrderingRequirement.Relation.Weak -> HorpoConstraintList.HRelation.GEQ;
            };
            x = lst.store(req.left(), rel, req.right(), req.constraint(), req.tvar());
            smt.requireImplication((Constraint)pair.fst(), x);
        }
        TreeMap<Integer, BVar> ret = new TreeMap<Integer, BVar>();
        if (problem.eitherReqs().isEmpty()) {
            return ret;
        }
        LinkedList<Constraint> linkedList = new LinkedList<Constraint>();
        for (Pair<Integer, OrderingRequirement> p : problem.eitherReqs()) {
            OrderingRequirement req = p.snd();
            x = lst.store(req.left(), HorpoConstraintList.HRelation.GREATER, req.right(), req.constraint(), req.tvar());
            BVar y = lst.store(req.left(), HorpoConstraintList.HRelation.GEQNOGR, req.right(), req.constraint(), req.tvar());
            smt.require(SmtFactory.createDisjunction((Constraint)x, (Constraint)y));
            linkedList.add(x);
            ret.put(p.fst(), x);
        }
        smt.require(SmtFactory.createDisjunction(linkedList));
        return ret;
    }

    /*
     * Loose catch block
     */
    private HorpoResult finish(OrderingProblem orderingProblem, TreeMap<Integer, BVar> choices, HorpoParameters param, HorpoConstraintList lst) {
        Valuation valuation = null;
        SmtSolver.Answer answer = Settings.smtSolver.checkSatisfiability(param.queryProblem());
        Objects.requireNonNull(answer);
        SmtSolver.Answer answer2 = answer;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmtSolver.Answer.YES.class}, (Object)answer2, n)) {
            case 0: {
                Valuation valuation2;
                Valuation val;
                SmtSolver.Answer.YES yES = (SmtSolver.Answer.YES)answer2;
                valuation = val = (valuation2 = yES.val());
                break;
            }
            default: {
                return new HorpoResult(orderingProblem, "No HORPO proof could be found.");
            }
        }
        TreeSet<Integer> strict = new TreeSet<Integer>();
        for (Map.Entry<Integer, BVar> entry : choices.entrySet()) {
            BVar x = entry.getValue();
            if (!valuation.queryBoolAssignment(x.queryIndex())) continue;
            strict.add(entry.getKey());
        }
        TreeSet<Integer> conditions = new TreeSet<Integer>();
        List<Pair<Constraint, OrderingRequirement>> creqs = orderingProblem.conditionalReqs();
        for (int i = 0; i < creqs.size(); ++i) {
            if (!creqs.get(i).fst().evaluate(valuation)) continue;
            conditions.add(i);
        }
        return new HorpoResult(orderingProblem, strict, conditions, valuation, param, lst);
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private class IntWrapper {
        int num;

        IntWrapper(Horpo horpo, int n) {
            this.num = n;
        }
    }
}

