/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.reduction_pairs.horpo;

import charlie.smt.BVar;
import charlie.smt.SmtProblem;
import charlie.terms.Term;
import charlie.terms.TermPrinter;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class HorpoConstraintList {
    private final TermPrinter _printer;
    private SmtProblem _problem;
    private ArrayList<HorpoRequirement> _constraints;
    private TreeMap<String, BVar> _definingVariables;

    HorpoConstraintList(TermPrinter printer, SmtProblem problem) {
        this._printer = printer;
        this._problem = problem;
        this._constraints = new ArrayList();
        this._definingVariables = new TreeMap();
    }

    BVar store(Term left, HRelation relation, Term right, Term constraint) {
        TreeSet<Variable> constraintvars = new TreeSet<Variable>();
        for (Variable x : constraint.vars()) {
            constraintvars.add(x);
        }
        return this.store(left, relation, right, constraint, constraintvars);
    }

    BVar store(Term left, HRelation relation, Term right, Term constraint, Set<Variable> tvar) {
        TreeSet<Variable> myvars = new TreeSet<Variable>();
        for (Variable x : tvar) {
            if (!left.vars().contains(x) && !right.vars().contains(x)) continue;
            myvars.add(x);
        }
        String representation = this.reqToString(left, relation, right, constraint, myvars);
        BVar ret = this._definingVariables.get(representation);
        if (ret != null) {
            return ret;
        }
        ret = this._problem.createBooleanVariable(representation);
        this._definingVariables.put(representation, ret);
        HorpoRequirement req = new HorpoRequirement(left, relation, right, constraint, myvars, ret);
        this._constraints.add(req);
        return ret;
    }

    int size() {
        return this._constraints.size();
    }

    HorpoRequirement get(int i) {
        return this._constraints.get(i);
    }

    private String reqToString(Term left, HRelation relation, Term right, Term constraint, TreeSet<Variable> theorvar) {
        MutableRenaming naming = this._printer.generateUniqueNaming(constraint, left, right);
        StringBuilder builder = new StringBuilder();
        this._printer.print(left, naming, builder);
        builder.append(switch (relation.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> " \u227b ";
            case 1 -> " \u227b{theory} ";
            case 2 -> " \u227b{var} ";
            case 3 -> " \u227b{fun} ";
            case 4 -> " \u227b{rpo} ";
            case 5 -> " \u227d ";
            case 6 -> " \u227d{theory} ";
            case 7 -> " \u227d{var} ";
            case 8 -> " \u227d{fun} ";
            case 9 -> " \u227d{equal} ";
            case 10 -> " \u2248 ";
            case 11 -> " \u2248{theory} ";
            case 12 -> " \u2248{var} ";
            case 13 -> " \u2248{fun} ";
            case 14 -> " \u2248{equal} ";
            case 15 -> " \u25b7 ";
            case 16 -> " \u25b7{select} ";
            case 17 -> " \u25b7{copy} ";
            case 18 -> " \u25b7{ext} ";
            case 19 -> " \u25b7{th} ";
        });
        this._printer.print(right, naming, builder);
        builder.append(" | ");
        this._printer.print(constraint, naming, builder);
        builder.append(" {");
        for (Variable v : theorvar) {
            builder.append(" ");
            this._printer.print(v, naming, builder);
        }
        builder.append(" }");
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this._constraints.size(); ++i) {
            builder.append(this._constraints.get(i).variable().queryName());
            builder.append("\n");
        }
        return builder.toString();
    }

    static enum HRelation {
        GREATER,
        GREATERTHEORY,
        GREATERVAR,
        GREATERFUN,
        GREATERRPO,
        GEQ,
        GEQTHEORY,
        GEQVAR,
        GEQFUN,
        GEQEQUAL,
        GEQNOGR,
        GEQNOGRTHEORY,
        GEQNOGRVAR,
        GEQNOGRFUN,
        GEQNOGREQUAL,
        RPO,
        RPOSELECT,
        RPOCOPY,
        RPOEXT,
        RPOTH;

    }

    record HorpoRequirement(Term left, HRelation relation, Term right, Term constraint, TreeSet<Variable> theoryVariables, BVar variable) {
    }
}

