/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.reduction_pairs.horpo;

import charlie.smt.BVar;
import charlie.smt.IVar;
import charlie.smt.IntegerExpression;
import charlie.smt.SmtFactory;
import charlie.smt.SmtProblem;
import charlie.smt.Valuation;
import charlie.terms.FunctionSymbol;
import cora.termination.reduction_pairs.ArgumentFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.TreeSet;

class HorpoParameters {
    private final SmtProblem _problem;
    private final TreeMap<FunctionSymbol, IVar> _precedence;
    private final TreeMap<FunctionSymbol, TreeMap<Integer, IVar>> _permutation;
    private final BVar _down;
    private final int _M;

    HorpoParameters(int bound, TreeSet<FunctionSymbol> allsymbols, ArgumentFilter regards, SmtProblem problem) {
        this._problem = problem;
        this._precedence = new TreeMap();
        this._permutation = new TreeMap();
        this._down = this._problem.createBooleanVariable("down");
        this._M = bound > 0 ? bound : 1;
        this.setupPrecedence(allsymbols);
        this.setupPermutation(allsymbols, regards);
    }

    private void setupPrecedence(TreeSet<FunctionSymbol> symbols) {
        IntegerExpression zero = SmtFactory.createValue(0);
        IntegerExpression max = SmtFactory.createValue(symbols.size());
        IVar valuevar = null;
        for (FunctionSymbol f : symbols) {
            if (f.isValue()) {
                if (valuevar == null) {
                    valuevar = this._problem.createIntegerVariable("zero");
                    this._problem.require(SmtFactory.createEqual(valuevar, zero));
                }
                this._precedence.put(f, valuevar);
                continue;
            }
            IVar x = this._problem.createIntegerVariable("pred(" + f.queryName() + ")");
            this._problem.require(SmtFactory.createSmaller(zero, x));
            this._problem.require(SmtFactory.createGeq(max, x));
            this._precedence.put(f, x);
        }
    }

    private void setupPermutation(TreeSet<FunctionSymbol> symbols, ArgumentFilter filter) {
        IntegerExpression zero = SmtFactory.createValue(0);
        IntegerExpression one = SmtFactory.createValue(1);
        for (FunctionSymbol f : symbols) {
            int m = f.queryArity();
            if (m == 0) continue;
            IntegerExpression mexp = SmtFactory.createValue(m);
            TreeMap<Integer, IVar> map = new TreeMap<Integer, IVar>();
            this._permutation.put(f, map);
            for (int i = 1; i <= m; ++i) {
                IVar x = this._problem.createIntegerVariable("pi{" + f.queryName() + "}(" + i + ")");
                BVar reg = filter.regards(f, i);
                this._problem.requireImplication(reg.negate(), SmtFactory.createEqual(x, zero));
                if (m == 1) {
                    this._problem.requireImplication(reg, SmtFactory.createEqual(x, one));
                } else {
                    this._problem.requireImplication(reg, SmtFactory.createGreater(x, zero));
                    this._problem.require(SmtFactory.createGeq(mexp, x));
                }
                map.put(i, x);
                for (int j = 1; j < i; ++j) {
                    this._problem.requireImplication(SmtFactory.createEqual(x, (IntegerExpression)map.get(j)), SmtFactory.createEqual(x, one));
                }
            }
        }
    }

    SmtProblem queryProblem() {
        return this._problem;
    }

    public IVar getPrecedence(FunctionSymbol f) {
        return this._precedence.get(f);
    }

    public IVar getPermutation(FunctionSymbol f, int pos) {
        return this._permutation.get(f).get(pos);
    }

    BVar getDirectionIsDownVariable() {
        return this._down;
    }

    int queryIntegerBound() {
        return this._M;
    }

    public ArrayList<SymbolData> getSymbolData(Valuation valuation) {
        ArrayList<SymbolData> info = new ArrayList<SymbolData>();
        for (FunctionSymbol symbol : this._precedence.keySet()) {
            int p = valuation.queryAssignment(this._precedence.get(symbol));
            TreeSet<Integer> one = new TreeSet<Integer>();
            TreeMap<Integer, Integer> other = new TreeMap<Integer, Integer>();
            for (int i = 1; i <= symbol.queryArity(); ++i) {
                IVar x = this._permutation.get(symbol).get(i);
                int value = valuation.queryAssignment(x);
                if (value == 1) {
                    one.add(i);
                    continue;
                }
                if (value <= 1) continue;
                other.put(value, i);
            }
            info.add(new SymbolData(symbol, p, one, other));
        }
        Collections.sort(info, new Comparator<SymbolData>(this){

            @Override
            public int compare(SymbolData inf1, SymbolData inf2) {
                if (inf1.prec != inf2.prec) {
                    return inf2.prec - inf1.prec;
                }
                return inf1.symbol.compareTo(inf2.symbol);
            }
        });
        return info;
    }

    record SymbolData(FunctionSymbol symbol, int prec, TreeSet<Integer> mappedToOne, TreeMap<Integer, Integer> mappedToGreater) {
        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append(this.symbol.queryName());
            ret.append(" : [ {");
            for (int i : this.mappedToOne) {
                ret.append(" " + i);
            }
            ret.append(" }");
            for (int i = 2; i <= this.symbol.queryArity(); ++i) {
                if (this.mappedToGreater.containsKey(i)) {
                    ret.append(" " + String.valueOf(this.mappedToGreater.get(i)));
                    continue;
                }
                ret.append(" _");
            }
            ret.append(" ] (" + this.prec + ")");
            return ret.toString();
        }
    }
}

