/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.reduction_pairs.horpo;

import charlie.smt.Valuation;
import charlie.terms.FunctionSymbol;
import cora.io.OutputModule;
import cora.termination.reduction_pairs.OrderingProblem;
import cora.termination.reduction_pairs.OrderingRequirement;
import cora.termination.reduction_pairs.ReductionPairProofObject;
import cora.termination.reduction_pairs.horpo.HorpoConstraintList;
import cora.termination.reduction_pairs.horpo.HorpoParameters;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;

class HorpoResult
extends ReductionPairProofObject {
    private final HorpoParameters _parameters;
    private final HorpoConstraintList _constraints;
    private final Valuation _valuation;
    private final String _failReason;
    private final boolean _stronglyMonotonic;

    HorpoResult(OrderingProblem problem, String reason) {
        super(problem);
        this._parameters = null;
        this._constraints = null;
        this._valuation = null;
        this._stronglyMonotonic = false;
        this._failReason = reason;
    }

    HorpoResult(OrderingProblem problem, Set<Integer> strict, Set<Integer> conds, Valuation valuation, HorpoParameters param, HorpoConstraintList hclst) {
        super(problem, strict, conds, problem.queryArgumentFilter().getRegardedArguments(valuation));
        this._parameters = param;
        this._constraints = hclst;
        this._valuation = valuation;
        this._stronglyMonotonic = problem.queryArgumentFilter().everythingIsRegarded(valuation);
        this._failReason = null;
    }

    public int precedence(FunctionSymbol f, FunctionSymbol g) {
        if (this._valuation == null) {
            return 0;
        }
        int k = this._parameters.getPrecedence(f).evaluate(this._valuation) - this._parameters.getPrecedence(g).evaluate(this._valuation);
        return k;
    }

    public int permutation(FunctionSymbol f, int index) {
        if (this._valuation == null) {
            return 0;
        }
        return this._parameters.getPermutation(f, index).evaluate(this._valuation);
    }

    public boolean stronglyMonotonic() {
        return this._stronglyMonotonic;
    }

    private void printIntegerOrdering(OutputModule module) {
        module.print("{(x,y) | ", new Object[0]);
        boolean down = this._parameters.getDirectionIsDownVariable().evaluate(this._valuation);
        int bound = this._parameters.queryIntegerBound();
        if (down) {
            module.print("x %{greater} -%a %{and} x %{greater} y }", bound);
        } else {
            module.print("x %{smaller} %a %{and} x %{smaller} y }", bound);
        }
    }

    private TreeSet<FunctionSymbol> getSymbols() {
        TreeSet<FunctionSymbol> ret = new TreeSet<FunctionSymbol>();
        for (OrderingRequirement req : this._reqs) {
            req.left().storeFunctionSymbols(ret);
            req.right().storeFunctionSymbols(ret);
        }
        return ret;
    }

    private void printSymbolData(OutputModule o) {
        ArrayList<HorpoParameters.SymbolData> data = this._parameters.getSymbolData(this._valuation);
        o.println("* Precedence and permutation:", new Object[0]);
        o.startTable();
        for (int index = 0; index < data.size(); ++index) {
            HorpoParameters.SymbolData d = data.get(index);
            if (index == 0) {
                o.nextColumn();
            } else if (d.prec() == data.get(index - 1).prec()) {
                o.nextColumn("=", new Object[0]);
            } else {
                o.nextColumn(">", new Object[0]);
            }
            o.nextColumn("%a ", d.symbol().queryName());
            o.print("{", new Object[0]);
            for (int i : d.mappedToOne()) {
                o.print(" %a", i);
            }
            o.nextColumn(" }", new Object[0]);
            int skip = 0;
            for (int i = 2; i <= d.symbol().queryArity(); ++i) {
                if (d.mappedToGreater().containsKey(i)) {
                    for (int j = 0; j < skip; ++j) {
                        o.nextColumn("_", new Object[0]);
                    }
                    o.nextColumn("%a", d.mappedToGreater().get(i));
                    continue;
                }
                ++skip;
            }
            o.println();
        }
        o.endTable();
    }

    private void printOrderings(OutputModule o) {
        o.println("* Well-founded theory orderings:", new Object[0]);
        o.startTable();
        o.nextColumn("%{sqSupset}_{Bool}", new Object[0]);
        o.nextColumn("=", new Object[0]);
        o.println("{(true,false)}", new Object[0]);
        o.nextColumn("%{sqSupset}_{Int}", new Object[0]);
        o.nextColumn("=", new Object[0]);
        this.printIntegerOrdering(o);
        o.println();
        o.endTable();
    }

    private void printFilterings(OutputModule o) {
        if (this._stronglyMonotonic) {
            o.println("* Monotonicity requirements: this is a strongly monotonic reduction pair (all arguments of function symbols were regarded).", new Object[0]);
            return;
        }
        o.println("* Disregarded arguments:", new Object[0]);
        o.startTable();
        for (FunctionSymbol f : this.getSymbols()) {
            boolean first = true;
            for (int i = 1; i <= f.queryArity(); ++i) {
                if (this.regards(f, i)) continue;
                if (first) {
                    o.nextColumn("%a", f.queryName());
                    first = false;
                }
                o.print("%a ", i);
            }
            if (first) continue;
            o.println();
        }
        o.endTable();
    }

    @Override
    public void justify(OutputModule o) {
        if (this._parameters == null) {
            if (this._failReason != null) {
                o.println(this._failReason, new Object[0]);
            }
            return;
        }
        o.println("Constrained HORPO yields:", new Object[0]);
        this.printOrderingProblem(o);
        o.println("We do this using the following settings:", new Object[0]);
        this.printFilterings(o);
        this.printSymbolData(o);
        this.printOrderings(o);
    }
}

