/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.reduction_pairs.horpo;

import charlie.smt.BVar;
import charlie.smt.Constraint;
import charlie.smt.IVar;
import charlie.smt.IntegerExpression;
import charlie.smt.SmtFactory;
import charlie.smt.SmtProblem;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.Variable;
import charlie.terms.replaceable.Replaceable;
import charlie.theorytranslation.TermSmtTranslator;
import charlie.types.Arrow;
import charlie.types.Type;
import charlie.types.TypeFactory;
import cora.config.Settings;
import cora.termination.reduction_pairs.ArgumentFilter;
import cora.termination.reduction_pairs.horpo.HorpoConstraintList;
import cora.termination.reduction_pairs.horpo.HorpoParameters;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;

class HorpoSimplifier {
    private final HorpoParameters _parameters;
    private final HorpoConstraintList _hcl;
    private final ArgumentFilter _filter;
    private final SmtProblem _smt;
    private int _counter;

    HorpoSimplifier(HorpoParameters params, HorpoConstraintList lst, ArgumentFilter filter) {
        this._parameters = params;
        this._hcl = lst;
        this._filter = filter;
        this._smt = this._parameters.queryProblem();
        this._counter = 0;
    }

    void simplify(HorpoConstraintList.HorpoRequirement req) {
        switch (req.relation()) {
            case GREATER: {
                this.handleGreater(req);
                break;
            }
            case GREATERTHEORY: {
                this.handleTheory(req);
                break;
            }
            case GREATERVAR: {
                this.handleVar(req);
                break;
            }
            case GREATERFUN: {
                this.handleFun(req);
                break;
            }
            case GREATERRPO: {
                this.handleGrRpo(req);
                break;
            }
            case GEQ: {
                this.handleGeq(req);
                break;
            }
            case GEQTHEORY: {
                this.handleTheory(req);
                break;
            }
            case GEQVAR: {
                this.handleVar(req);
                break;
            }
            case GEQFUN: {
                this.handleFun(req);
                break;
            }
            case GEQEQUAL: {
                this.handleEqual(req);
                break;
            }
            case GEQNOGR: {
                this.handleGeqNoGr(req);
                break;
            }
            case GEQNOGRTHEORY: {
                this.handleTheory(req);
                break;
            }
            case GEQNOGRVAR: {
                this.handleVar(req);
                break;
            }
            case GEQNOGRFUN: {
                this.handleFun(req);
                break;
            }
            case GEQNOGREQUAL: {
                this.handleEqual(req);
                break;
            }
            case RPO: {
                this.handleRpo(req);
                break;
            }
            case RPOSELECT: {
                this.handleSelect(req);
                break;
            }
            case RPOCOPY: {
                this.handleCopy(req);
                break;
            }
            case RPOEXT: {
                this.handleExt(req);
                break;
            }
            case RPOTH: {
                this.handleRpoTh(req);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sameTypeStructure(Type a, Type b) {
        Type type = a;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class}, (Object)type2, n)) {
            case 0: {
                Type type3;
                Type out1;
                Type in1;
                Type type32;
                Arrow arrow = (Arrow)type2;
                try {
                    in1 = type32 = arrow.left();
                    out1 = type32 = arrow.right();
                    type3 = b;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Objects.requireNonNull(type3);
                type32 = type3;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class}, (Object)type32, n2)) {
                    case 0: {
                        Arrow arrow2 = (Arrow)type32;
                        {
                            Type type5;
                            Type in2 = type5 = arrow2.left();
                            Type out2 = type5 = arrow2.right();
                            if (!this.sameTypeStructure(in1, in2)) return false;
                            if (!this.sameTypeStructure(out1, out2)) return false;
                            return true;
                        }
                    }
                }
                return false;
            }
        }
        Type type4 = b;
        Objects.requireNonNull(type4);
        Type type7 = type4;
        int n3 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class}, (Object)type7, n3)) {
            case 0: {
                Arrow arrow = (Arrow)type7;
                {
                    Type type8;
                    Type in2 = type8 = arrow.left();
                    Type out2 = type8 = arrow.right();
                    return false;
                }
            }
        }
        return true;
    }

    private void requireOr(Constraint ... args) {
        this._smt.require(SmtFactory.createDisjunction(args));
    }

    private void handleGreater(HorpoConstraintList.HorpoRequirement req) {
        Term l = req.left();
        Term r = req.right();
        if (!this.sameTypeStructure(l.queryType(), r.queryType())) {
            this._smt.require(req.variable().negate());
            return;
        }
        if (l.equals(r)) {
            this._smt.require(req.variable().negate());
            return;
        }
        Term c = req.constraint();
        TreeSet<Variable> v = req.theoryVariables();
        if (l.isTheoryTerm()) {
            this._smt.requireImplication(req.variable(), this._hcl.store(l, HorpoConstraintList.HRelation.GREATERTHEORY, r, c, v));
        } else {
            this.requireOr(req.variable().negate(), this._hcl.store(l, HorpoConstraintList.HRelation.GREATERRPO, r, c, v), this._hcl.store(l, HorpoConstraintList.HRelation.GREATERVAR, r, c, v), this._hcl.store(l, HorpoConstraintList.HRelation.GREATERFUN, r, c, v));
        }
    }

    private void handleGeq(HorpoConstraintList.HorpoRequirement req) {
        Term l = req.left();
        Term r = req.right();
        if (!this.sameTypeStructure(l.queryType(), r.queryType())) {
            this._smt.require(req.variable().negate());
            return;
        }
        Term c = req.constraint();
        TreeSet<Variable> v = req.theoryVariables();
        if (l.equals(r)) {
            this._smt.requireImplication(req.variable(), this._hcl.store(l, HorpoConstraintList.HRelation.GEQEQUAL, r, c, v));
        } else if (l.isTheoryTerm()) {
            this._smt.requireImplication(req.variable(), this._hcl.store(l, HorpoConstraintList.HRelation.GEQTHEORY, r, c, v));
        } else {
            this.requireOr(req.variable().negate(), this._hcl.store(l, HorpoConstraintList.HRelation.GREATERRPO, r, c, v), this._hcl.store(l, HorpoConstraintList.HRelation.GEQVAR, r, c, v), this._hcl.store(l, HorpoConstraintList.HRelation.GEQFUN, r, c, v));
        }
    }

    private void handleGeqNoGr(HorpoConstraintList.HorpoRequirement req) {
        Term l = req.left();
        Term r = req.right();
        if (!this.sameTypeStructure(l.queryType(), r.queryType())) {
            this._smt.require(req.variable().negate());
            return;
        }
        Term c = req.constraint();
        TreeSet<Variable> v = req.theoryVariables();
        if (l.equals(r)) {
            this._smt.requireImplication(req.variable(), this._hcl.store(l, HorpoConstraintList.HRelation.GEQNOGREQUAL, r, c, v));
        } else if (l.isTheoryTerm()) {
            this._smt.requireImplication(req.variable(), this._hcl.store(l, HorpoConstraintList.HRelation.GEQNOGRTHEORY, r, c, v));
        } else {
            this.requireOr(req.variable().negate(), this._hcl.store(l, HorpoConstraintList.HRelation.GEQNOGRVAR, r, c, v), this._hcl.store(l, HorpoConstraintList.HRelation.GEQNOGRFUN, r, c, v));
        }
    }

    private void handleRpo(HorpoConstraintList.HorpoRequirement req) {
        Term l = req.left();
        Term r = req.right();
        Term c = req.constraint();
        TreeSet<Variable> v = req.theoryVariables();
        this.requireOr(req.variable().negate(), this._hcl.store(l, HorpoConstraintList.HRelation.RPOTH, r, c, v), this._hcl.store(l, HorpoConstraintList.HRelation.RPOSELECT, r, c, v), this._hcl.store(l, HorpoConstraintList.HRelation.RPOCOPY, r, c, v), this._hcl.store(l, HorpoConstraintList.HRelation.RPOEXT, r, c, v));
    }

    private void handleTheory(HorpoConstraintList.HorpoRequirement req) {
        Term l = req.left();
        Term r = req.right();
        Term phi = req.constraint();
        TreeSet<Variable> v = req.theoryVariables();
        BVar variable = req.variable();
        HorpoConstraintList.HRelation relation = req.relation();
        if (!this.theoryAllowed(l, r, v)) {
            this._smt.require(variable.negate());
        } else if (relation == HorpoConstraintList.HRelation.GEQNOGRTHEORY) {
            BVar x = this._hcl.store(l, HorpoConstraintList.HRelation.GEQTHEORY, r, phi, v);
            BVar y = this._hcl.store(l, HorpoConstraintList.HRelation.GREATERTHEORY, r, phi, v);
            this._smt.require(SmtFactory.createIff(variable, SmtFactory.createConjunction(x, y.negate())));
        } else if (l.queryType().equals(TypeFactory.intSort)) {
            this.handleIntComparison(l, r, phi, variable, relation, this._parameters);
        } else if (l.queryType().equals(TypeFactory.boolSort)) {
            this.handleBoolComparison(l, r, phi, variable, relation, this._parameters);
        } else {
            this._smt.require(variable.negate());
        }
    }

    private boolean isTheory(Term s, TreeSet<Variable> theoryVariables) {
        if (!(s.isTheoryTerm() && s.queryType().isBaseType() && s.queryType().isTheoryType())) {
            return false;
        }
        for (Replaceable x : s.freeReplaceables()) {
            if (theoryVariables.contains(x)) continue;
            return false;
        }
        return true;
    }

    private boolean theoryAllowed(Term l, Term r, TreeSet<Variable> theoryVariables) {
        return this.isTheory(l, theoryVariables) && l.queryType().equals(r.queryType()) && this.isTheory(r, theoryVariables);
    }

    private void handleIntComparison(Term l, Term r, Term phi, BVar x, HorpoConstraintList.HRelation rel, HorpoParameters _parameters) {
        Constraint upProblem;
        Constraint downProblem;
        SmtProblem validityProblem = new SmtProblem();
        TermSmtTranslator tst = new TermSmtTranslator(validityProblem);
        IntegerExpression el = tst.translateIntegerExpression(l);
        IntegerExpression er = tst.translateIntegerExpression(r);
        Constraint c = tst.translateConstraint(phi);
        if (rel == HorpoConstraintList.HRelation.GREATERTHEORY) {
            IntegerExpression eMM = SmtFactory.createValue(-_parameters.queryIntegerBound());
            downProblem = SmtFactory.createConjunction(SmtFactory.createGreater(el, er), SmtFactory.createGeq(el, eMM));
            eMM = SmtFactory.createValue(_parameters.queryIntegerBound());
            upProblem = SmtFactory.createConjunction(SmtFactory.createSmaller(el, er), SmtFactory.createLeq(el, eMM));
        } else {
            downProblem = SmtFactory.createGeq(el, er);
            upProblem = SmtFactory.createLeq(el, er);
        }
        validityProblem.requireImplication(c, downProblem);
        boolean downValid = Settings.smtSolver.checkValidity(validityProblem);
        validityProblem.clear();
        validityProblem.requireImplication(c, upProblem);
        boolean upValid = Settings.smtSolver.checkValidity(validityProblem);
        if (downValid && upValid) {
            this._smt.require(x);
        } else if (downValid) {
            this._smt.require(SmtFactory.createIff(x, _parameters.getDirectionIsDownVariable()));
        } else if (upValid) {
            this._smt.require(SmtFactory.createIff(x, _parameters.getDirectionIsDownVariable().negate()));
        } else {
            this._smt.require(x.negate());
        }
    }

    private void handleBoolComparison(Term l, Term r, Term phi, BVar x, HorpoConstraintList.HRelation rel, HorpoParameters _parameters) {
        SmtProblem validityProblem = new SmtProblem();
        TermSmtTranslator tst = new TermSmtTranslator(validityProblem);
        Constraint cl = tst.translateConstraint(l);
        Constraint cr = tst.translateConstraint(r);
        Constraint cp = tst.translateConstraint(phi);
        Constraint negr = SmtFactory.createNegation(cr);
        Constraint constr = rel == HorpoConstraintList.HRelation.GREATERTHEORY ? SmtFactory.createConjunction(cl, negr) : SmtFactory.createDisjunction(cl, negr);
        validityProblem.requireImplication(cp, constr);
        if (Settings.smtSolver.checkValidity(validityProblem)) {
            this._smt.require(x);
        } else {
            this._smt.require(x.negate());
        }
    }

    private void handleEqual(HorpoConstraintList.HorpoRequirement req) {
        this._smt.require(req.variable());
    }

    private void handleVar(HorpoConstraintList.HorpoRequirement req) {
        Term left = req.left();
        Term right = req.right();
        int n = left.numberArguments();
        if (!left.isVarTerm() || n != right.numberArguments() || !left.queryHead().equals(right.queryHead())) {
            this._smt.require(req.variable().negate());
            return;
        }
        HorpoConstraintList.HRelation subrel = req.relation() == HorpoConstraintList.HRelation.GEQNOGRVAR ? HorpoConstraintList.HRelation.GEQNOGR : HorpoConstraintList.HRelation.GEQ;
        for (int i = 1; i <= n; ++i) {
            BVar x = this._hcl.store(left.queryArgument(i), subrel, right.queryArgument(i), req.constraint(), req.theoryVariables());
            this._smt.requireImplication(req.variable(), x);
        }
        if (req.relation() == HorpoConstraintList.HRelation.GREATERVAR) {
            this._smt.requireImplication(req.variable(), this._filter.regardsEverything());
            ArrayList<Constraint> oneof = new ArrayList<Constraint>(n);
            for (int i = 1; i <= n; ++i) {
                oneof.add(this._hcl.store(left.queryArgument(i), HorpoConstraintList.HRelation.GREATER, right.queryArgument(i), req.constraint(), req.theoryVariables()));
            }
            this._smt.requireImplication(req.variable(), SmtFactory.createDisjunction(oneof));
        }
    }

    private void handleFun(HorpoConstraintList.HorpoRequirement req) {
        Term left = req.left();
        Term right = req.right();
        if (!left.isFunctionalTerm() || !right.isFunctionalTerm() || this.isTheory(right, req.theoryVariables()) || left.numberArguments() == 0 && req.relation() == HorpoConstraintList.HRelation.GREATERFUN) {
            this._smt.require(req.variable().negate());
            return;
        }
        FunctionSymbol f = left.queryRoot();
        FunctionSymbol g = right.queryRoot();
        int k = left.numberArguments();
        int n = right.numberArguments();
        ++this._counter;
        this.requireOr(req.variable().negate(), SmtFactory.createEqual(this._parameters.getPrecedence(f), this._parameters.getPrecedence(g)));
        this.requireFunRest(f, k, g, n, req.variable());
        ArrayList<IVar> chi = this.createChiForFun(f, k, g, n, req.variable(), null);
        this.requireInjective(k, g, n, req.variable(), chi);
        this.requireSamePermutation(f, k, g, n, req.variable(), chi);
        this.requireChiGeq(k, n, req, chi, req.relation() == HorpoConstraintList.HRelation.GEQNOGRFUN ? HorpoConstraintList.HRelation.GEQNOGR : HorpoConstraintList.HRelation.GEQ, null);
        if (req.relation() == HorpoConstraintList.HRelation.GREATERFUN) {
            this.requireChiGreater(f, k, n, req, chi);
        } else if (req.relation() == HorpoConstraintList.HRelation.GEQNOGRFUN) {
            this.requireChiSurjective(f, k, n, req.variable(), chi);
        }
    }

    private void requireFunRest(FunctionSymbol f, int k, FunctionSymbol g, int n, BVar reqvar) {
        int m = f.queryArity() - k;
        if (m != g.queryArity() - n) {
            this._smt.require(reqvar.negate());
            return;
        }
        for (int i = 1; i <= m; ++i) {
            IVar gni = this._parameters.getPermutation(g, n + i);
            Constraint equal = SmtFactory.createEqual(gni, this._parameters.getPermutation(f, k + i));
            Constraint zero = SmtFactory.createEqual(gni, SmtFactory.createValue(0));
            this._smt.requireImplication(reqvar, SmtFactory.createDisjunction(equal, zero));
        }
    }

    private ArrayList<IVar> createChiForFun(FunctionSymbol f, int k, FunctionSymbol g, int n, BVar reqvar, IVar aa) {
        ArrayList<IVar> ret = new ArrayList<IVar>(n);
        IntegerExpression zero = SmtFactory.createValue(0);
        IntegerExpression one = SmtFactory.createValue(1);
        for (int i = 1; i <= n; ++i) {
            IVar chi_i = SmtFactory.createIntegerVariable(this._smt, "chi" + this._counter + "(" + i + ")", 0, k);
            ret.add(chi_i);
            this.requireOr(reqvar.negate(), this._filter.regards(g, i), SmtFactory.createEqual(chi_i, zero));
            if (aa == null) {
                this.requireOr(reqvar.negate(), this._filter.regards(g, i).negate(), SmtFactory.createGeq(chi_i, one));
                continue;
            }
            this.requireOr(reqvar.negate(), SmtFactory.createLeq(this._parameters.getPermutation(g, i), aa), SmtFactory.createEqual(chi_i, zero));
            this.requireOr(reqvar.negate(), this._filter.regards(g, i).negate(), SmtFactory.createGreater(this._parameters.getPermutation(g, i), aa), SmtFactory.createGeq(chi_i, one));
        }
        return ret;
    }

    private void requireInjective(int k, FunctionSymbol g, int n, BVar reqvar, ArrayList<IVar> chi) {
        if (k == 0) {
            return;
        }
        for (int i = 1; i < n; ++i) {
            IVar chi_i = chi.get(i - 1);
            for (int j = i + 1; j <= n; ++j) {
                IVar chi_j = chi.get(j - 1);
                this.requireOr(reqvar.negate(), this._filter.regards(g, i).negate(), SmtFactory.createUnequal(chi_i, chi_j));
            }
        }
    }

    private void requireSamePermutation(FunctionSymbol f, int k, FunctionSymbol g, int n, BVar reqvar, ArrayList<IVar> chi) {
        for (int i = 1; i <= n; ++i) {
            IVar chi_i = chi.get(i - 1);
            for (int j = 1; j <= k; ++j) {
                this.requireOr(reqvar.negate(), SmtFactory.createUnequal(chi_i, SmtFactory.createValue(j)), SmtFactory.createEqual(this._parameters.getPermutation(f, j), this._parameters.getPermutation(g, i)));
            }
        }
    }

    private void requireChiGeq(int k, int n, HorpoConstraintList.HorpoRequirement req, List<IVar> chi, HorpoConstraintList.HRelation rel, List<BVar> onlyforthese) {
        Term left = req.left();
        Term right = req.right();
        Term constr = req.constraint();
        TreeSet<Variable> tvar = req.theoryVariables();
        for (int i = 1; i <= n; ++i) {
            IVar chi_i = chi.get(i - 1);
            for (int j = 1; j <= k; ++j) {
                Constraint uneq = SmtFactory.createUnequal(chi_i, SmtFactory.createValue(j));
                BVar comp = this._hcl.store(left.queryArgument(j), rel, right.queryArgument(i), constr, tvar);
                if (onlyforthese == null) {
                    this.requireOr(req.variable().negate(), uneq, comp);
                    continue;
                }
                BVar bvar = onlyforthese.get(j - 1);
                this.requireOr(req.variable().negate(), bvar.negate(), uneq, comp);
            }
        }
    }

    private void requireChiGreater(FunctionSymbol f, int k, int n, HorpoConstraintList.HorpoRequirement req, List<IVar> chi) {
        ArrayList parts = new ArrayList();
        if (k == 0) {
            this._smt.require(req.variable().negate());
            return;
        }
        IVar a = SmtFactory.createIntegerVariable(this._smt, "decrease" + this._counter, 1, k);
        for (int j = 1; j <= k; ++j) {
            this.requireOr(req.variable().negate(), SmtFactory.createUnequal(a, SmtFactory.createValue(j)), this._filter.regards(f, j));
        }
        Term left = req.left();
        Term right = req.right();
        Term constr = req.constraint();
        TreeSet<Variable> tvar = req.theoryVariables();
        for (int i = 1; i <= n; ++i) {
            IVar chi_i = chi.get(i - 1);
            for (int j = 1; j <= k; ++j) {
                BVar sjgreaterti = this._hcl.store(left.queryArgument(j), HorpoConstraintList.HRelation.GREATER, right.queryArgument(i), constr, tvar);
                this.requireOr(req.variable().negate(), SmtFactory.createUnequal(chi_i, a), SmtFactory.createUnequal(a, SmtFactory.createValue(j)), sjgreaterti);
            }
        }
    }

    private void requireChiSurjective(FunctionSymbol f, int k, int n, BVar reqvar, List<IVar> chi) {
        for (int j = 1; j <= k; ++j) {
            ArrayList<Constraint> parts = new ArrayList<Constraint>(n + 2);
            parts.add(reqvar.negate());
            parts.add(this._filter.regards(f, j).negate());
            IntegerExpression jj = SmtFactory.createValue(j);
            for (int i = 1; i <= n; ++i) {
                parts.add(SmtFactory.createEqual(chi.get(i - 1), jj));
            }
            this._smt.require(SmtFactory.createDisjunction(parts));
        }
    }

    private void handleGrRpo(HorpoConstraintList.HorpoRequirement req) {
        if (!req.left().isFunctionalTerm() || req.left().isTheoryTerm()) {
            this._smt.require(req.variable().negate());
        } else {
            if (req.left().queryType().isArrowType()) {
                FunctionSymbol f = req.left().queryRoot();
                int m = f.queryArity();
                for (int i = req.left().numberArguments() + 1; i <= m; ++i) {
                    this._smt.requireImplication(req.variable(), this._filter.regards(f, i));
                }
            }
            BVar x = this._hcl.store(req.left(), HorpoConstraintList.HRelation.RPO, req.right(), req.constraint(), req.theoryVariables());
            this._smt.requireImplication(req.variable(), x);
        }
    }

    private void handleSelect(HorpoConstraintList.HorpoRequirement req) {
        Term l = req.left();
        FunctionSymbol f = l.queryRoot();
        int k = l.numberArguments();
        Term r = req.right();
        int n = r.numberArguments();
        int rest = r.queryType().queryArity();
        int m = n + rest;
        ArrayList<Constraint> options = new ArrayList<Constraint>(k + 1);
        options.add(req.variable().negate());
        for (int i = 1; i <= k; ++i) {
            Constraint c = this.createSelectConstraint(l, f, i, r, n, m, req.constraint(), req.theoryVariables());
            if (c == null) continue;
            options.add(c);
        }
        this._smt.require(SmtFactory.createDisjunction(options));
    }

    private Constraint createSelectConstraint(Term left, FunctionSymbol f, int index, Term right, int n, int m, Term constr, TreeSet<Variable> tvar) {
        Term arg = left.queryArgument(index);
        int p = arg.queryType().queryArity();
        if (p < m - n) {
            return null;
        }
        if (p > m) {
            return null;
        }
        ArrayList<Constraint> allof = new ArrayList<Constraint>(2 + p - n + m);
        allof.add(this._filter.regards(f, index));
        Term head = right.queryImmediateHeadSubterm(m - p);
        allof.add(this._hcl.store(arg, HorpoConstraintList.HRelation.GEQ, head, constr, tvar));
        for (int j = m - p + 1; j <= n; ++j) {
            allof.add(this._hcl.store(left, HorpoConstraintList.HRelation.RPO, right.queryArgument(j), constr, tvar));
        }
        return SmtFactory.createConjunction(allof);
    }

    private void requireLeftGreaterRightArguments(HorpoConstraintList.HorpoRequirement req) {
        Term l = req.left();
        Term r = req.right();
        FunctionSymbol g = r.queryRoot();
        for (int i = 1; i <= r.numberArguments(); ++i) {
            BVar subreq = this._hcl.store(l, HorpoConstraintList.HRelation.RPO, r.queryArgument(i), req.constraint(), req.theoryVariables());
            BVar regards = this._filter.regards(g, i);
            this.requireOr(req.variable().negate(), this._filter.regards(g, i).negate(), subreq);
        }
    }

    private void handleCopy(HorpoConstraintList.HorpoRequirement req) {
        Term l = req.left();
        Term r = req.right();
        FunctionSymbol f = l.queryRoot();
        if (!r.isFunctionalTerm() || r.queryRoot().equals(f) || this.isTheory(r, req.theoryVariables())) {
            this._smt.require(req.variable().negate());
        } else {
            FunctionSymbol g = r.queryRoot();
            IVar predf = this._parameters.getPrecedence(f);
            IVar predg = this._parameters.getPrecedence(g);
            this._smt.requireImplication(req.variable(), SmtFactory.createGreater(predf, predg));
            this.requireLeftGreaterRightArguments(req);
        }
    }

    private void handleRpoTh(HorpoConstraintList.HorpoRequirement req) {
        Term r = req.right();
        boolean isgood = r.isTheoryTerm();
        if (isgood) {
            for (Variable x : r.vars()) {
                if (req.theoryVariables().contains(x)) continue;
                isgood = false;
                break;
            }
        }
        if (isgood) {
            this._smt.require(req.variable());
        } else {
            this._smt.require(req.variable().negate());
        }
    }

    private void handleExt(HorpoConstraintList.HorpoRequirement req) {
        Term l = req.left();
        Term r = req.right();
        int k = l.numberArguments();
        if (!r.isFunctionalTerm() || this.isTheory(r, req.theoryVariables()) || k == 0) {
            this._smt.require(req.variable().negate());
            return;
        }
        FunctionSymbol f = l.queryRoot();
        FunctionSymbol g = r.queryRoot();
        int n = r.numberArguments();
        int m = g.queryArity();
        ++this._counter;
        IVar a = SmtFactory.createIntegerVariable(this._smt, "decr" + this._counter, 1, f.queryArity());
        ArrayList<IVar> chi = this.createChiForFun(f, k, g, n, req.variable(), a);
        ArrayList<BVar> strict = this.createStrict(f, k, a, req.variable());
        this._smt.requireImplication(req.variable(), SmtFactory.createEqual(this._parameters.getPrecedence(f), this._parameters.getPrecedence(g)));
        this.requireSamePermutation(f, k, g, n, req.variable(), chi);
        for (int i = n + 1; i <= m; ++i) {
            IVar pgi = this._parameters.getPermutation(g, i);
            this.requireOr(req.variable().negate(), SmtFactory.createEqual(pgi, SmtFactory.createValue(0)), SmtFactory.createGreater(pgi, a));
        }
        this.requireLeftGreaterRightArguments(req);
        this.requireChiGeq(k, n, req, chi, HorpoConstraintList.HRelation.GEQ, null);
        this.requireChiGeq(k, n, req, chi, HorpoConstraintList.HRelation.GREATER, strict);
        this.requireNonStrictInjective(k, n, chi, strict, req.variable());
    }

    private ArrayList<BVar> createStrict(FunctionSymbol f, int k, IVar a, BVar reqvar) {
        ArrayList<BVar> ret = new ArrayList<BVar>(k);
        ArrayList<Constraint> parts = new ArrayList<Constraint>(k + 1);
        parts.add(reqvar.negate());
        for (int j = 1; j <= k; ++j) {
            BVar strict_j = this._smt.createBooleanVariable("strict" + this._counter + "_" + j);
            this.requireOr(reqvar.negate(), strict_j.negate(), SmtFactory.createEqual(this._parameters.getPermutation(f, j), a));
            ret.add(strict_j);
            parts.add(strict_j);
        }
        this._smt.require(SmtFactory.createDisjunction(parts));
        return ret;
    }

    private void requireNonStrictInjective(int k, int n, ArrayList<IVar> chi, ArrayList<BVar> strict, BVar reqvar) {
        for (int i1 = 1; i1 < n; ++i1) {
            IVar chi_i1 = chi.get(i1 - 1);
            for (int i2 = i1 + 1; i2 <= n; ++i2) {
                IVar chi_i2 = chi.get(i2 - 1);
                for (int j = 1; j <= k; ++j) {
                    BVar jstrict = strict.get(j - 1);
                    IntegerExpression jj = SmtFactory.createValue(j);
                    this.requireOr(reqvar.negate(), SmtFactory.createUnequal(chi_i1, jj), SmtFactory.createUnequal(chi_i2, jj), jstrict);
                }
            }
        }
    }
}

