/*
 * Decompiled with CFR 0.152.
 */
package cora.termination.transformation;

import charlie.terms.Environment;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsFactory;
import charlie.trs.TrsProperties;
import charlie.types.Type;
import java.util.ArrayList;
import java.util.TreeSet;

public class CallByValueModifier {
    private TRS _trs;
    private TreeSet<String> _badTheorySorts;

    public static boolean isApplicable(TRS trs) {
        if (!trs.verifyProperties(TrsProperties.Level.META, TrsProperties.Constrained.YES, TrsProperties.TypeLevel.SIMPLE, TrsProperties.Lhs.NONPATTERN, TrsProperties.Root.ANY, TrsProperties.FreshRight.ANY, new TRS.RuleScheme[0])) {
            return false;
        }
        for (FunctionSymbol f : trs.queryAlphabet().getSymbols()) {
            Type type;
            if (f.isTheorySymbol() || trs.isDefined(f) || !(type = f.queryType().queryOutputType()).isTheoryType() || !type.isBaseType()) continue;
            return false;
        }
        return true;
    }

    public static TRS modify(TRS trs) {
        ArrayList<Rule> newrules = new ArrayList<Rule>();
        for (int i = 0; i < trs.queryRuleCount(); ++i) {
            Rule rho = trs.queryRule(i);
            Term left = rho.queryLeftSide();
            Term right = rho.queryRightSide();
            Term constraint = rho.queryConstraint();
            Environment<Variable> cvars = constraint.vars();
            Term newconstraint = constraint;
            for (Variable x : left.vars()) {
                if (!x.queryType().isBaseType() || !x.queryType().isTheoryType() || cvars.contains(x)) continue;
                Term eq = TheoryFactory.createEquality(x, x);
                newconstraint = TheoryFactory.createConjunction(newconstraint, eq);
            }
            newrules.add(TrsFactory.createRule(left, right, newconstraint));
        }
        return trs.createDerivative(newrules);
    }
}

