/**************************************************************************************************
 Copyright 2023--2025 Cynthia Kop

 Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software distributed under the
 License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 express or implied.
 See the License for the specific language governing permissions and limitations under the License.
 *************************************************************************************************/

package charlie.terms.position;

public record FinalPos(int chopcount) implements Position {
  public FinalPos(int chopcount) {
    if (chopcount < 0) {
      throw new IllegalArgumentException("FinalPos::constructor -- chop count < 0");
    }
    this.chopcount = chopcount;
  }

  public String toString() { return toStringDefault(); }

  public boolean equals(Position other) {
    switch (other) {
      case FinalPos(int k): return chopcount == k;
      default: return false;
    }
  }

  public boolean equals(Object other) {
    if (other instanceof Position p) return equals(p);
    return false;
  }

  public int hashCode() {
    return chopcount + 1;
  }

  public Position append(Position p) {
    return p;
  }
  
  public boolean isEmpty() {
    return chopcount == 0;
  }

  public boolean isFinal() {
    return true;
  }

  public int queryChopCount() {
    return chopcount;
  }

  public int compareTo(Position other) {
    return switch(other) {
      case FinalPos(int c) -> this.chopcount - c;
      default -> -1;
    };
  }

  public int queryHead() {
    throw new IndexOutOfBoundsException("Calling queryHead() on FinalPos!");
  }

  public Position queryTail() {
    throw new IndexOutOfBoundsException("Calling queryTail() on FinalPos!");
  }
}
