/**************************************************************************************************
 Copyright 2024-2025 Cynthia Kop

 Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 in compliance with the License.
 You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software distributed under the
 License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 express or implied.
 See the License for the specific language governing permissions and limitations under the License.
 *************************************************************************************************/

package cora.rwinduction.command;

import charlie.util.FixedList;
import cora.io.OutputModule;
import cora.rwinduction.parser.CommandParsingStatus;

/** The environment command :quit, which allows the user to end the interactive process. */
public class CommandQuit extends SingularCommandInherit {
  @Override
  public String queryName() {
    return ":quit";
  }
  
  @Override
  public void printHelp(OutputModule module) {
    module.println("Use this to abort the interactive prover process.");
    module.println("WARNING: note that your result will not be saved!");
  }

  @Override
  protected boolean run() {
    _proof.abort();
    return true;
  }
}

