(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6395,        186]*)
(*NotebookOutlinePosition[      8736,        253]*)
(*  CellTagsIndexPosition[      8406,        241]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Load ",
  StyleBox["Theorema",
    FontSlant->"Italic"],
  " and Set Preferences"
}], "Subsection",
  CellFrameLabels->{{None, Inherited}, {Inherited, Inherited}}],

Cell[BoxData[
    \(Needs["\<Theorema`\>"]\)], "Input"],

Cell[BoxData[
    \(\(SetOptions[Prove, transformBy \[Rule] ProofSimplifier, 
        TransformerOptions \[Rule] {branches \[Rule] Proved, 
            steps \[Rule] Essential}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Proof of the Main Theorem", "Subsection",
  CellFrameLabels->{{None, Inherited}, {Inherited, Inherited}}],

Cell[BoxData[
    RowBox[{
      StyleBox["Theorem",
        FontWeight->"Bold"], 
      "[", \("\<sqrt[2] irrational\>", \[Not] rat[\@2]\), "]"}]], "Input",
  CellTags->"Theorem (sqrt[2] irrational)"],

Cell[BoxData[
    RowBox[{
      StyleBox["Definition",
        FontWeight->"Bold"], "[", \("\<rational\>", 
      any[r], \[IndentingNewLine]rat[
          r] : \[NegativeThickSpace]\[NegativeThinSpace]\(\(\
\[DoubleLeftRightArrow]\)\(\[Exists] \+\(a, b\)\((nat[a] \[And] 
                nat[b] \[And] \((r = a\/b)\) \[And] coprime[a, b])\)\)\)\), 
      "]"}]], "Input",
  CellTags->"Definition (rational)"],

Cell[BoxData[
    RowBox[{
      StyleBox["Definition",
        FontWeight->"Bold"], "[", \("\<sqrt\>", 
      any[x], \[IndentingNewLine]\@x := \(\(\(\[SuchThat]\)\(!\)\)\+y\) \
\((y\^2 = x)\)\), "]"}]], "Input",
  CellTags->"Definition (sqrt)"],

Cell[BoxData[
    RowBox[{
      StyleBox["Lemma",
        FontWeight->"Bold"], "[", \("\<coprime\>", any[a, b], 
      with[nat[a] \[And] 
          nat[b]], \[IndentingNewLine]\((2  b\^2 = 
            a\^2)\) \[Implies] \[Not] coprime[a, b]\), "]"}]], "Input",
  CellTags->"Lemma (coprime)"],

Cell[BoxData[
    \(\(Prove[Theorem["\<sqrt[2] irrational\>"], 
        using \[Rule] \[LeftAngleBracket]Lemma["\<coprime\>"], 
            Definition["\<rational\>"], 
            Definition["\<sqrt\>"]\[RightAngleBracket], 
        built\[Dash]in \[Rule] \[LeftAngleBracket]Built\[Dash]in["\<Rational \
Numbers\>"]\[RightAngleBracket], by \[Rule] ElementaryReasoner, 
        ProverOptions \[Rule] {SimplifyFormula \[Rule] True, 
            RWCombine \[Rule] True}];\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Proof of the Auxiliary Lemma", "Subsection",
  CellFrameLabels->{{None, Inherited}, {Inherited, Inherited}}],

Cell["\<\
The auxiliary Lemma \"coprime\" is a statement essentially about \
natural numbers. In the spirit of theory exploration we assume this lemma to \
be proven during an (earlier) exploration of the notion \"coprime\" within \
the universe of natural numbers. In this section, we show this phase of \
exploration of the natural numbers.\
\>", "Text"],

Cell[BoxData[
    RowBox[{
      StyleBox["Lemma",
        FontWeight->"Bold"], "[", \("\<coprime\>", 
      any[a, b], \[IndentingNewLine]\((2  b\^2 = 
            a\^2)\) \[Implies] \[Not] coprime[a, b]\), "]"}]], "Input",
  CellTags->"Lemma (coprime)"],

Cell[BoxData[
    RowBox[{
      StyleBox["Definition",
        FontWeight->"Bold"], "[", \("\<even\>", 
      any[a], \[IndentingNewLine]is\[Dash]even[
          a] : \[NegativeThickSpace]\[NegativeThinSpace]\(\(\
\[DoubleLeftRightArrow]\)\(\[Exists] \+m\((a = 2  m)\)\)\)\), "]"}]], "Input",\

  CellTags->"Definition (even)"],

Cell[BoxData[
    RowBox[{
      StyleBox["Proposition",
        FontWeight->"Bold"], "[", 
      RowBox[{
      "\"\<even numbers\>\"", ",", \(any[a, b]\), ",", "\[IndentingNewLine]", 
        GridBox[{
            {\(\((2  b = a)\) \[Implies] is\[Dash]even[a]\), 
              "\"\<characteristic\>\""},
            {\(is\[Dash]even[a\^2] \[Implies] is\[Dash]even[a]\), 
              "\"\<even square\>\""}
            },
          ColumnAlignments->{Left}]}], "]"}]], "Input",
  CellTags->"Proposition (even numbers)"],

Cell[BoxData[
    RowBox[{
      StyleBox["Proposition",
        FontWeight->"Bold"], "[", \("\<common factor\>", 
      any[a, b], \[IndentingNewLine]\[Not] coprime[2  a, 2  b]\), 
      "]"}]], "Input",
  CellTags->"Proposition (common factor)"],

Cell[BoxData[
    \(\(Prove[Lemma["\<coprime\>"], 
        using \[Rule] \[LeftAngleBracket]Proposition["\<even numbers\>"], 
            Proposition["\<common factor\>"], 
            Definition["\<even\>"]\[RightAngleBracket], 
        built\[Dash]in \[Rule] \[LeftAngleBracket]Built\[Dash]in["\<Natural \
Numbers\>"]\[RightAngleBracket], by \[Rule] ElementaryReasoner, 
        ProverOptions \[Rule] {SimplifyFormula \[Rule] True}, 
        SearchDepth \[Rule] 40];\)\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
ScreenStyleEnvironment->"Working",
WindowSize->{684, 722},
WindowMargins->{{172, Automatic}, {Automatic, 77}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PrintingMargins"->{{121.938, 121.938}, {72, 72}},
"PaperSize"->{597.562, 842.375},
"PaperOrientation"->"Portrait",
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->True,
"PrintMultipleHorizontalPages"->False,
"PostScriptOutputFile":>FrontEnd`FileName[{$RootDirectory, "home", \
"wwindste", "Publications", "Papers", "Sqrt2"}, "Sqrt2-Session.nb.ps", \
CharacterEncoding -> "iso8859-1"],
"Magnification"->1},
StyleDefinitions -> "LectureNotes.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Theorem (sqrt[2] irrational)"->{
    Cell[2367, 75, 201, 5, 51, "Input",
      CellTags->"Theorem (sqrt[2] irrational)"]},
  "Definition (rational)"->{
    Cell[2571, 82, 410, 9, 85, "Input",
      CellTags->"Definition (rational)"]},
  "Definition (sqrt)"->{
    Cell[2984, 93, 246, 6, 86, "Input",
      CellTags->"Definition (sqrt)"]},
  "Lemma (coprime)"->{
    Cell[3233, 101, 294, 7, 59, "Input",
      CellTags->"Lemma (coprime)"],
    Cell[4531, 134, 255, 6, 59, "Input",
      CellTags->"Lemma (coprime)"]},
  "Definition (even)"->{
    Cell[4789, 142, 328, 8, 80, "Input",
      CellTags->"Definition (even)"]},
  "Proposition (even numbers)"->{
    Cell[5120, 152, 523, 13, 92, "Input",
      CellTags->"Proposition (even numbers)"]},
  "Proposition (common factor)"->{
    Cell[5646, 167, 247, 6, 58, "Input",
      CellTags->"Proposition (common factor)"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Theorem (sqrt[2] irrational)", 7543, 214},
  {"Definition (rational)", 7662, 217},
  {"Definition (sqrt)", 7770, 220},
  {"Lemma (coprime)", 7872, 223},
  {"Definition (even)", 8052, 228},
  {"Proposition (even numbers)", 8166, 231},
  {"Proposition (common factor)", 8291, 234}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 182, 6, 56, "Subsection"],
Cell[1961, 61, 55, 1, 39, "Input"],
Cell[2019, 64, 193, 3, 58, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2249, 72, 115, 1, 53, "Subsection"],
Cell[2367, 75, 201, 5, 51, "Input",
  CellTags->"Theorem (sqrt[2] irrational)"],
Cell[2571, 82, 410, 9, 85, "Input",
  CellTags->"Definition (rational)"],
Cell[2984, 93, 246, 6, 86, "Input",
  CellTags->"Definition (sqrt)"],
Cell[3233, 101, 294, 7, 59, "Input",
  CellTags->"Lemma (coprime)"],
Cell[3530, 110, 484, 8, 96, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4051, 123, 118, 1, 53, "Subsection"],
Cell[4172, 126, 356, 6, 92, "Text"],
Cell[4531, 134, 255, 6, 59, "Input",
  CellTags->"Lemma (coprime)"],
Cell[4789, 142, 328, 8, 80, "Input",
  CellTags->"Definition (even)"],
Cell[5120, 152, 523, 13, 92, "Input",
  CellTags->"Proposition (even numbers)"],
Cell[5646, 167, 247, 6, 58, "Input",
  CellTags->"Proposition (common factor)"],
Cell[5896, 175, 483, 8, 115, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

