(* $Id: CC_Props.v,v 1.3 2000/11/10 11:27:26 freek Exp $ *)

Require Export Triangle.

(*
Ax_iom abs_re_less: (x:CC;e:IR)((AbsCC x)[:<]e)
	-> (AbsSmall e (Re x)).

Ax_iom abs_im_less: (x,y:CC;e:IR)((AbsCC x)[:<]e)
	-> (AbsSmall e (Im x)).

Ax_iom abs_less: (x,y:CC;d1,d2:IR)
	(Hpos : (Zero[:<=](d1[^](2) [+] d2[^](2))))
	((AbsIR((Re x)[-](Re y)))[:<]d1)
	-> ((AbsIR((Im x)[-](Im y)))[:<]d2)
	-> ((AbsCC(x[-]y))[:<](sqrt (d1[^](2) [+] d2[^](2)) Hpos)).
*)

Hints Resolve AbsIR_sqrt_sqr : algebra.

Lemma absCC_absIR_re: (x:CC)(AbsIR (Re x)) [:<=](AbsCC x).
Intros.
Step_leEq_lft (sqrt (Re x)[^](2) (sqr_nonneg ? (Re x))).
Unfold AbsCC.
Apply power_cancel_leEq with (2). Auto. Apply sqrt_nonneg.
Step_leEq_lft (Re x)[^](2).
Step_leEq_rht (Re x)[^](2)[+](Im x)[^](2).
Step_leEq_lft (Re x)[^](2)[+]Zero.
Apply plus_resp_leEq_lft.
Apply sqr_nonneg.
Qed.

Lemma absCC_absIR_im: (x:CC)(AbsIR (Im x)) [:<=](AbsCC x).
Intros.
Step_leEq_lft (sqrt (Im x)[^](2) (sqr_nonneg ? (Im x))).
Unfold AbsCC.
Apply power_cancel_leEq with (2). Auto. Apply sqrt_nonneg.
Step_leEq_lft (Im x)[^](2).
Step_leEq_rht (Re x)[^](2)[+](Im x)[^](2).
Step_leEq_lft Zero[+](Im x)[^](2).
Apply plus_resp_leEq.
Apply sqr_nonneg.
Qed.

Definition seq_re := [s:nat->CC][n:nat](Re (s n)).
Definition seq_im := [s:nat->CC][n:nat](Im (s n)).

Definition CC_Cauchy_prop [s:nat -> CC]: Prop :=
   (Cauchy_prop (seq_re s))/\(Cauchy_prop (seq_im s)).

Record CC_CauchySeq : Set :=
  {CC_seq  :> nat -> CC;
   CC_proof: (CC_Cauchy_prop CC_seq)
  }.

Lemma re_is_Cauchy :
	(s : CC_CauchySeq) (Cauchy_prop (seq_re s)).
Proof.
Intro s; Elim (CC_proof s);Auto.
Qed.

Lemma im_is_Cauchy :
	(s : CC_CauchySeq) (Cauchy_prop (seq_im s)).
Proof.
Intro s; Elim (CC_proof s);Auto.
Qed.

Definition CC_Cauchy2re := [s : CC_CauchySeq]
	(Build_CauchySeq IR (seq_re s)(re_is_Cauchy s)).

Definition CC_Cauchy2im := [s : CC_CauchySeq]
	(Build_CauchySeq IR (seq_im s)(im_is_Cauchy s)).

Definition LimCC :CC_CauchySeq -> CC := [s:CC_CauchySeq]
	(Build_CC_set (Lim (CC_Cauchy2re s))(Lim (CC_Cauchy2im s))).

Definition CC_seqLimit [seq:nat->CC; lim:CC]: Prop :=
   (e:IR)(Zero [:<] e) -> (Ex [N:nat](m:nat)(le N m)
				-> (AbsCC((seq m)[-]lim))[:<]e ).

Lemma AbsSmall_sqr : (x,e:IR)(AbsSmall e x) -> x[^](2) [:<] e[^](2).
Unfold absSmall. Intros. Elim H. Clear H. Intros.
Step_less_lft Zero[+]x[^](2).
Apply shift_plus_less.
Step_less_rht (e[-]x)[*](e[+]x).
Apply mult_resp_pos.
Apply shift_zero_less_minus. Auto.
Step_Rat_less_rht x[-][--]e.
Apply shift_zero_less_minus. Auto.
Qed.

Lemma AbsSmall_AbsCC : (z:CC; e:IR)(Zero [:<] e) ->
  (AbsSmall e[/]TwoNZ (Re z)) -> (AbsSmall e[/]TwoNZ (Im z)) ->
    (AbsCC z) [:<] e.
Intros. Unfold AbsCC.
Apply power_cancel_less with (2). Apply less_leEq. Auto.
Step_less_lft (Re z)[^](2)[+](Im z)[^](2).
Step_Rat_less_rht (e[/]TwoNZ)[^](2)[+](e[/]TwoNZ)[^](2)[+]
  e[^](2)[/]TwoNZ.
Step_less_lft (Re z)[^](2)[+](Im z)[^](2)[+]Zero.
Apply plus_resp_less_both.
Apply plus_resp_less_both.
Apply AbsSmall_sqr. Auto.
Apply AbsSmall_sqr. Auto.
Apply div_resp_pos. Apply pos_two.
Apply nexp_resp_pos. Auto.
Qed.

Lemma LimCC_is_lim : (s:CC_CauchySeq)(CC_seqLimit s (LimCC s)).
Unfold CC_seqLimit. Unfold LimCC. Intros.
Cut (SeqLimit (seq_re s) (Lim (CC_Cauchy2re s))).
Unfold seqLimit. Intro.
Cut (SeqLimit (seq_im s) (Lim (CC_Cauchy2im s))).
Unfold seqLimit. Intro.
Cut Zero [:<] e[/]TwoNZ. Intro.
Elim (H0 e[/]TwoNZ H2). Unfold seq_re. Intro N. Intros.
Elim (H1 e[/]TwoNZ H2). Unfold seq_im. Intro N'. Intros.
Cut (EX M | (le N M) /\ (le N' M)). Intros.
Elim H5. Clear H5. Intro M. Intros. Elim H5. Clear H5. Intros.
Exists M. Intros.
Apply AbsSmall_AbsCC. Auto.
Step_AbsSmall_rht (Re (CC_seq s m))[-](Lim (CC_Cauchy2re s)).
Apply H3. Omega.
Step_AbsSmall_rht (Im (CC_seq s m))[-](Lim (CC_Cauchy2im s)).
Apply H4. Omega.
Elim (le_lt_dec N N'); Intros.
Exists N'. Split; Auto.
Exists N. Split; Auto with arith.
Apply div_resp_pos. Apply pos_two. Auto.
Apply Lim_Cauchy with s :=
  (Build_CauchySeq (IR) [n:nat](Im (CC_seq s n)) (im_is_Cauchy s)).
Apply Lim_Cauchy with s :=
  (Build_CauchySeq (IR) [n:nat](Re (CC_seq s n)) (re_is_Cauchy s)).
Qed.

Lemma CC_seqLimit_uniq : (s: nat -> CC; l,l':CC)(CC_seqLimit s l)
	->(CC_seqLimit s l')->(l[=]l').
Unfold CC_seqLimit. Intros.
Apply cg_inv_unique_2.
Apply AbsCC_small_imp_eq. Intros.
Cut Zero [:<] e[/]TwoNZ. Intro.
Elim (H e[/]TwoNZ). Intro N. Intros.
Elim (H0 e[/]TwoNZ). Intro N'. Intros.
Cut (EX M | (le N M) /\ (le N' M)). Intros.
Elim H5. Clear H5. Intro M. Intros. Elim H5. Clear H5. Intros.
Apply leEq_less_trans with (AbsCC (s M)[-]l)[+](AbsCC (s M)[-]l').
Apply leEq_wdl with (AbsCC ([--]((s M)[-]l))[+]((s M)[-]l')).
Step_leEq_rht (AbsCC [--]((s M)[-]l))[+](AbsCC (s M)[-]l').
Apply triangle.
Apply AbsCC_wd. Rational.
Step_Rat_less_rht e[/]TwoNZ[+]e[/]TwoNZ.
Apply plus_resp_less_both.
Apply H3. Auto.
Apply H4. Auto.
Elim (le_lt_dec N N'); Intros.
Exists N'. Split; Auto.
Exists N. Split; Auto with arith.
Auto. Auto.
Apply div_resp_pos. Apply pos_two. Auto.
Qed.

Lemma CC_seqLimit_unq : (s:CC_CauchySeq; l:CC)(CC_seqLimit s l)
	->(l[=](LimCC s)).
Intros.
Apply CC_seqLimit_uniq with (CC_seq s). Auto.
Apply LimCC_is_lim.
Qed.

Section Continuity_for_CC.
Variable  f: CC -> CC. (* (CSetoid_un_op CC). *)

Definition CCfunLim [p,l:CC] : Prop :=
  (e:IR)(Zero [:<] e)->
    (EX d:IR | (Zero [:<] d) /\
               (x:CC)((AbsCC(p[-]x)) [:<] d) -> ((AbsCC(l[-](f x))) [:<]e)).

Definition CCcontinAt [p:CC]: Prop := (CCfunLim p (f p)).

Definition CCcontin :Prop :=
  (x:CC)(CCcontinAt x).

(*
Ax_iom CCcontin_is_strext : CCcontin -> (un_op_strong_ext CC f).
*)

Section CCSequence_and_function_limits.

Lemma CCfunLim_SeqLimit:
  (p,l:CC)(fl:(CCfunLim p l))
    (pn:nat->CC)(sl:(CC_seqLimit pn p)) (CC_seqLimit ([n:nat](f (pn n))) l).
Proof.
Intros; Unfold CC_seqLimit.
Intros eps epos.
Elim (fl ? epos); Intros del dh; Decompose [and] dh.
Elim (sl ? H0); Intros N Nh.
Exists N. Intros m leNm.
Apply less_wdl with (AbsCC (l[-](f (pn m)))).
Apply H1.
Apply less_wdl with (AbsCC ((pn m)[-]p)).
Apply (Nh ? leNm).
Apply cc_min_abs.
Apply cc_min_abs.
Qed.

End CCSequence_and_function_limits.


Definition f_seq : (nat->CC)->(nat->CC) :=
	[s:nat->CC; n:nat](f(s n)).

(*
Ax_iom AbsCC_eps_div_two : (e:IR;x1,x2:CC)
                             ((AbsCC x1)[:<](e[/]TwoNZ)) ->
                             ((AbsCC x2)[:<](e[/]TwoNZ)) ->
                             ((AbsCC (x1[+]x2))[:<]e).
Ax_iom eps_div2_pos : (e:IR)(Zero[:<]e)->(Zero[:<]e[/]TwoNZ).
*)

Lemma poly_pres_lim :CCcontin -> (s: CC_CauchySeq)
	(CC_seqLimit [n:nat](f(s n)) (f(LimCC s))).
Proof.
Intros cp s.
Apply (CCfunLim_SeqLimit (LimCC s) (f(LimCC s))).
Unfold CCfunLim.
Intros e zlte.
Elim (cp (LimCC s) e zlte).
Intros d Hd.
Exists d.
Exact Hd.
Exact (LimCC_is_lim s).
Qed.


End Continuity_for_CC.


Lemma power_big' : (R:COrdField)(x:R; n:nat)(Zero [:<] x) ->
  One[+](Nring n)[*]x [:<=] (One[+]x)[^]n.
Intros.
Induction n; Intros.
Step_Rat_leEq_lft One::R.
Step_leEq_rht One::R.
Apply leEq_reflexive.
Simpl.
Apply leEq_transitive with (One[+](Nring n)[*]x)[*](One[+]x).
Step_Rat_leEq_rht One[+]((Nring n)[+]One)[*]x[+](Nring n)[*]x[^](2).
Step_leEq_lft One[+]((Nring n)[+]One)[*]x[+]Zero.
Apply plus_resp_leEq_lft.
Apply mult_resp_nonneg.
Step_leEq_lft (Nring (0))::R. Apply nring_leEq. Auto with arith.
Apply sqr_nonneg.
Apply mult_resp_leEq_rht.
Auto.
Apply less_leEq. Apply plus_resp_pos. Apply pos_one. Auto.
Qed.

Lemma power_big : (x,y:IR)(Zero [:<] x) -> (One [:<] y) ->
  (EX N | x [:<] y[^]N).
Intros.
Cut Zero [:<] y[-]One. Intro.
Cut y[-]One [#] Zero. Intro.
Elim (Archimedes (x[-]One)[/](y[-]One)[//]H2). Intro N. Intros. Exists N.
Apply less_leEq_trans with One[+](Nring N)[*](y[-]One).
Apply shift_less_plus'.
Step_less_rht (y[-]One)[*](Nring N).
Apply shift_less_mult' with H2. Auto.
Auto.
Apply leEq_wdr with (One[+](y[-]One))[^]N.
Apply power_big'. Auto.
Apply un_op_wd_unfolded. Rational.
Apply Greater_imp_ap. Auto.
Apply shift_less_minus. Step_less_lft One::IR. Auto.
Qed.

Lemma qi_yields_zero : (q:IR)(Zero [:<] q) -> (q [:<] One)
	-> (e:IR)(Zero[:<]e) -> (EX N:nat | q[^]N [:<] e).
Intros.
Cut q [#] Zero. Intro.
Cut e [#] Zero. Intro.
Elim (power_big One[/]e[//]H3 One[/]q[//]H2). Intro N. Intros. Exists N.
Cut Zero [:<] q[^]N. Intro.
Cut q[^]N [#] Zero. Intro.
Step_less_lft One[*]q[^]N.
Apply shift_mult_less with H6. Auto.
Step_Rat_less_rht e[*](One[/]q[^]N[//]H6).
Apply shift_less_mult' with H3. Auto.
Step_less_rht One[^]N[/]q[^]N[//]H6.
Step_less_rht (One[/]q[//]H2)[^]N.
Auto.
Apply Greater_imp_ap. Auto.
Apply nexp_resp_pos. Auto.
Apply div_resp_pos. Auto. Apply pos_one.
Apply shift_less_div. Auto.
Step_less_lft q.
Auto.
Apply Greater_imp_ap. Auto.
Apply Greater_imp_ap. Auto.
Qed.


Lemma qi_lim_zero : (q:IR)(Zero [:<] q) -> (q [:<] One)
	-> (SeqLimit [i:nat](q[^]i) Zero).
Intros.
Unfold seqLimit. Unfold absSmall. Intros.
Elim (qi_yields_zero q H H0 e); Auto.
Intro N. Intros. Exists (S N). Intros. Split.
Apply less_transitive_unfolded with Zero::IR.
Step_less_rht [--]Zero::IR. Apply min_resp_less. Auto.
Step_less_rht q[^]m.
Apply nexp_resp_pos. Auto.
Step_less_lft q[^]m.
Replace m with (plus N (minus m N)).
Step_less_lft q[^]N[*]q[^](minus m N). Step_less_rht e[*]One.
Apply mult_resp_less_both.
Apply less_leEq. Apply nexp_resp_pos. Auto. Auto.
Apply less_leEq. Apply nexp_resp_pos. Auto.
Step_less_rht (One::IR)[^](minus m N).
Apply nexp_resp_less. Omega. Apply less_leEq. Auto. Auto.
Omega.
Qed.


Lemma seq_yields_zero:
  (q:IR)(Zero [:<] q) -> (q [:<] One) ->
      (c:IR)(Zero [:<] c) ->
	(s : nat -> CC)
	((i:nat)((AbsCC (s i)) [:<] (q[^]i [*]c))) ->	
	(CC_seqLimit s Zero).
Proof.
Intros q zltq qlt1 c zltc s H.
Unfold CC_seqLimit.
Intros e zlte.
Generalize (qi_lim_zero q zltq qlt1).
Intro Hqi.
Unfold seqLimit in Hqi.
Elim (Hqi e[/]c[//](pos_ap_zero ? c zltc)).
Intros N HN.
Exists N.
Intros m leNm.
Apply less_transitive_unfolded with q[^]m[*]c.
Apply less_wdl with (AbsCC (s m)).
Apply  H.
Apply eq_symmetric_unfolded;Apply AbsCC_minzero.
Generalize (HN m leNm).
Intro H0.
Unfold absSmall in H0.
Decompose [and] H0.
Step_Rat_less_rht (e[/]c[//](pos_ap_zero (IR) c zltc)[*]c).
Apply mult_resp_less.
Step_Rat_less_lft q[^]m[-]Zero.
Assumption.
Assumption.
Apply shift_less_div.
Assumption.
Step_Rat_less_lft Zero::IR;Assumption.
Qed.

(*
Definition makeCC_Cauchy := [s_r : (CauchySeq IR); s_i : (CauchySeq IR)]
	[n:nat](Build_CC_set (s_r n)(s_i n)).

Ax_iom is_CC_Cauchy :
	(s_r : (CauchySeq IR); s_i : (CauchySeq IR))
	 (CC_Cauchy_prop (makeCC_Cauchy s_r s_i)).

Definition Cauchy2CC_Cauchy := [s_r : (CauchySeq IR); s_i : (CauchySeq IR)]
	(Build_CC_CauchySeq (makeCC_Cauchy s_r s_i)
		(is_CC_Cauchy s_r s_i)).
*)


