(* $Id: CComplex.v,v 1.84 2000/11/10 14:09:48 freek Exp $ *)

Require Export NRootIR.

(* Tex_Prose
\section{Complex Numbers}
*)

Section Complex_Numbers.
(* Begin_Tex_Verb *)
Record CC_set : Set :=
      {Re : IR;
       Im : IR}.

Definition cc_ap [x,y:CC_set]: Prop :=
  ((Re x) [#] (Re y)) \/ ((Im x) [#] (Im y)).
Definition cc_eq [x,y:CC_set]: Prop :=
  ((Re x) [=] (Re y)) /\ ((Im x) [=] (Im y)).

Lemma cc_is_CSetoid : (is_CSetoid ? cc_eq cc_ap).
(* End_Tex_Verb *)
Apply Build_is_CSetoid.
Unfold irreflexive.
Intros. Elim x. Intros x1 x2. Unfold cc_ap. Simpl.
Intro. Elim H; Clear H; Intros.
Cut ~(x1 [#] x1). Intros. Elim (H0 H). Apply ap_irreflexive_unfolded.
Cut ~(x2 [#] x2). Intros. Elim (H0 H). Apply ap_irreflexive_unfolded.
Unfold symmetric.
Intros x y. Elim x. Intros x1 x2. Elim y. Intros y1 y2. Unfold cc_ap.
Simpl. Intros. Elim H; Clear H; Intros.
Left. Apply ap_symmetric_unfolded. Auto.
Right. Apply ap_symmetric_unfolded. Auto.
Unfold cotransitive.
Intros x y. Elim x. Intros x1 x2. Elim y. Intros y1 y2. Unfold cc_ap.
Simpl. Intro. Intro. Elim z. Intros z1 z2. Simpl. Intros.
Elim H; Clear H; Intros.
Cut (x1 [#] z1) \/ (z1 [#] y1). Intro.
Elim H0; Clear H0; Intros. Left. Left. Auto. Right. Left. Auto.
Apply ap_cotransitive_unfolded. Auto.
Cut (x2 [#] z2) \/ (z2 [#] y2). Intro.
Elim H0; Clear H0; Intros. Left. Right. Auto. Right. Right. Auto.
Apply ap_cotransitive_unfolded. Auto.
Unfold tight_apart.
Intros x y. Elim x. Intros x1 x2. Elim y. Intros y1 y2.
Unfold cc_ap. Unfold cc_eq. Simpl. Split.
Intros. Split.
Apply not_ap_imp_eq. Intro. Apply H. Left. Auto.
Apply not_ap_imp_eq. Intro. Apply H. Right. Auto.
Intros. Elim H. Clear H. Intros. Intro. Elim H1; Clear H1; Intros.
Cut ~(x1 [#] y1). Intro. Elim (H2 H1). Apply eq_imp_not_ap. Auto.
Cut ~(x2 [#] y2). Intro. Elim (H2 H1). Apply eq_imp_not_ap. Auto.
Qed.

(* Begin_Tex_Verb *)
Definition cc_csetoid := (Build_CSetoid CC_set cc_eq cc_ap cc_is_CSetoid).

Definition cc_plus : CC_set -> CC_set -> CC_set :=
  [x,y:CC_set](Build_CC_set ((Re x)[+](Re y)) ((Im x)[+](Im y))).

Definition cc_mult : CC_set -> CC_set -> CC_set :=
  [x,y:CC_set]
  (Build_CC_set ((Re x)[*](Re y)) [-] ((Im x)[*](Im y))
	  ((Re x)[*](Im y)) [+] ((Im x)[*](Re y))).

Definition cc_zero := (Build_CC_set Zero::IR Zero::IR).
Definition cc_one := (Build_CC_set One::IR Zero::IR).
Definition cc_i := (Build_CC_set Zero::IR One::IR).
Definition cc_min [x:CC_set]: CC_set := (Build_CC_set ([--](Re x)) ([--](Im x))).

Lemma cc_plus_op_proof : (bin_op_well_def cc_csetoid cc_plus).
(* End_Tex_Verb *)
Unfold bin_op_well_def. Unfold bin_fun_well_def.
Intros x1 x2 y1 y2. Elim x1. Elim x2. Elim y1. Elim y2.
Simpl. Unfold cc_eq. Simpl. Intros.
Elim H. Clear H. Intros. Elim H0. Clear H0. Intros.
Split; Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_mult_op_proof : (bin_op_well_def cc_csetoid cc_mult).
(* End_Tex_Verb *)
Unfold bin_op_well_def. Unfold bin_fun_well_def.
Intros x1 x2 y1 y2. Elim x1. Elim x2. Elim y1. Elim y2.
Simpl. Unfold cc_eq. Simpl. Intros.
Elim H. Clear H. Intros. Elim H0. Clear H0. Intros.
Split; Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_min_op_proof : (un_op_well_def cc_csetoid cc_min).
(* End_Tex_Verb *)
Unfold un_op_well_def. Unfold fun_well_def.
Intros x y. Elim x. Elim y.
Simpl. Unfold cc_eq. Simpl. Intros.
Elim H. Clear H. Intros.
Split; Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_min_strext : (un_op_strong_ext cc_csetoid cc_min).
(* End_Tex_Verb *)
Unfold un_op_strong_ext. Unfold fun_strong_ext.
Intros x y. Elim x. Elim y.
Simpl. Unfold cc_ap. Simpl. Intros.
Elim H; Clear H; Intros.
Left. Apply un_op_strext_unfolded with (cg_inv IR). Auto.
Right. Apply un_op_strext_unfolded with (cg_inv IR). Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_plus_strext : (bin_op_strong_ext cc_csetoid cc_plus).
(* End_Tex_Verb *)
Unfold bin_op_strong_ext. Unfold bin_fun_strong_ext.
Intros x1 x2 y1 y2. Elim x1. Elim x2. Elim y1. Elim y2.
Simpl. Unfold cc_ap. Simpl. Intros.
Elim H; Clear H; Intros.
Elim (bin_op_strext_unfolded ?????? H); Intros.
Left. Left. Auto. Right. Left. Auto.
Elim (bin_op_strext_unfolded ?????? H); Intros.
Left. Right. Auto. Right. Right. Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_mult_strext : (bin_op_strong_ext cc_csetoid cc_mult).
(* End_Tex_Verb *)
Unfold bin_op_strong_ext. Unfold bin_fun_strong_ext.
Intros x1 x2 y1 y2. Elim x1. Elim x2. Elim y1. Elim y2.
Simpl. Unfold cc_ap. Simpl. Intros.
Elim H; Clear H; Intros.
Elim (bin_op_strext_unfolded ?????? H); Intros.
Elim (bin_op_strext_unfolded ?????? H0); Intros.
Left. Left. Auto. Right. Left. Auto.
Cut Im3[*]Im1 [#] Im2[*]Im0. Intro.
Elim (bin_op_strext_unfolded ?????? H1); Intros.
Left. Right. Auto. Right. Right. Auto.
Apply un_op_strext_unfolded with (cg_inv IR). Auto.
Elim (bin_op_strext_unfolded ?????? H); Intros.
Elim (bin_op_strext_unfolded ?????? H0); Intros.
Left. Left. Auto. Right. Right. Auto.
Elim (bin_op_strext_unfolded ?????? H0); Intros.
Left. Right. Auto. Right. Left. Auto.
Qed.

(* Begin_Tex_Verb *)
Definition cc_min_op :=
(Build_CSetoid_un_op cc_csetoid cc_min cc_min_op_proof cc_min_strext).
Definition cc_plus_op :=
(Build_CSetoid_bin_op cc_csetoid cc_plus cc_plus_op_proof cc_plus_strext).
Definition cc_mult_op :=
(Build_CSetoid_bin_op cc_csetoid cc_mult cc_mult_op_proof cc_mult_strext).

Lemma cc_csg_associative : (Associative cc_plus_op).
(* End_Tex_Verb *)
Unfold associative. Intros. Elim x. Elim y. Elim z. Intros.
Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_cr_mult_associative : (Associative cc_mult_op).
(* End_Tex_Verb *)
Unfold associative. Intros. Elim x. Elim y. Elim z. Intros.
Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

(* Begin_Tex_Verb *)
Definition cc_csemi_grp :=
(Build_CSemi_grp cc_csetoid cc_zero cc_plus_op cc_csg_associative).

Lemma cc_cm_proof : (is_CMonoid cc_csemi_grp).
(* End_Tex_Verb *)
Apply Build_is_CMonoid.
Unfold is_rht_unit. Intros. Elim x. Intros.
Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Unfold commutes. Intros. Elim x. Elim y. Intros.
Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

(* Begin_Tex_Verb *)
Definition cc_cmonoid :=
(Build_CMonoid ? cc_cm_proof).

Lemma cc_cg_proof : (is_CGroup cc_cmonoid cc_min_op).
(* End_Tex_Verb *)
Unfold is_CGroup. Intros. Elim x. Intros.
Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_cr_dist : (Distributive cc_mult_op cc_plus_op).
(* End_Tex_Verb *)
Unfold distributive. Intros. Elim x. Elim y. Elim z. Intros.
Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_cr_non_triv : (cc_ap cc_one cc_zero).
(* End_Tex_Verb *)
Unfold cc_ap. Simpl. Left. Apply Greater_imp_ap. Apply pos_one.
Qed.

(* Begin_Tex_Verb *)
Definition cc_cgroup :=
(Build_CGroup cc_cmonoid cc_min_op cc_cg_proof).

Lemma cc_cr_mult_mon :
(is_CMonoid (Build_CSemi_grp
       (csg_crr cc_cgroup) cc_one cc_mult_op cc_cr_mult_associative)).
(* End_Tex_Verb *)
Apply Build_is_CMonoid.
Unfold is_rht_unit.
Intros. Elim x. Intros. Simpl. Unfold cc_eq. Simpl.
Split; Rational.
Unfold commutes.
Intros. Elim x. Elim y. Intros. Simpl. Unfold cc_eq. Simpl.
Split; Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_mult_commutes: (Commutes cc_mult_op).
(* End_Tex_Verb *)
Unfold commutes.
Intros. Elim x. Intros. Simpl. Unfold cc_eq. Simpl.
Split; Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_isCRing : (is_CRing  cc_cgroup cc_one cc_mult_op).
(* End_Tex_Verb *)
Apply Build_is_CRing with cc_cr_mult_associative.
Exact cc_cr_mult_mon.
Exact cc_cr_dist.
Exact cc_cr_non_triv.
Qed.

(* Begin_Tex_Verb *)
Definition cc_cring :=
(Build_CRing cc_cgroup cc_one cc_mult_op cc_isCRing) : CRing.
(* End_Tex_Verb *)

(* Tex_Prose
If $x\noto 0$ or $y\noto 0$, then  $x^2 + y^2 \noto 0$.
*)
(* Begin_Tex_Verb *)
Lemma cc_inv_aid:
(x,y:IR)((x [#] Zero) \/ (y [#] Zero)) ->
	(((x[^](2)) [+] (y[^] (2))) [#] Zero).
(* End_Tex_Verb *)
Intros. Apply Greater_imp_ap.
Elim H; Clear H; Intros.
Apply plus_resp_pos_nonneg. Apply pos_square. Auto. Apply sqr_nonneg.
Apply plus_resp_nonneg_pos. Apply sqr_nonneg. Apply pos_square. Auto.
Qed.

(* Tex_Prose
If $x\noto 0$ or $y\noto 0$, then  $\frac{x}{x^2 + y^2} \noto 0$ or
$\frac{-y}{x^2 + y^2} \noto 0$.
*)
(* Begin_Tex_Verb *)
Lemma cc_inv_aid2:
(x,y:IR)(h:(x [#] Zero) \/ (y [#] Zero))
  ((x [/] (NZpro (cc_inv_aid ?? h))) [#] Zero) \/
  (([--]y [/] (NZpro (cc_inv_aid ?? h))) [#] Zero).
(* End_Tex_Verb *)
Intros.
Cut (x [#] Zero) \/ (y [#] Zero). Intro. 2: Auto.
Elim H; Clear H; Intros.
Left. Apply div_resp_ap_zero_rev. Auto.
Right. Apply div_resp_ap_zero_rev. Apply min_resp_ap_zero. Auto.
Qed.

(****
* This definition seems clever.  Even though we *cannot* construct an
* element of (NonZeros cc_cring) (a Set) by deciding which part of the
* input (re or im) is NonZero (a Prop), we manage to construct the
* actual function.
****)
(* Begin_Tex_Verb *)
Definition cc_inv : (NonZeros cc_cring) -> (NonZeros cc_cring).
(* End_Tex_Verb *)
Intro cc_elt.
Elim cc_elt.
Intro nonz_elt.
Elim nonz_elt.
Intros rp ip nz.
Apply (nzpro cc_cring
	   (Build_CC_set (rp [/] (NZpro (cc_inv_aid ?? nz)))
		   ([--]ip [/] (NZpro (cc_inv_aid ?? nz))))
	   (cc_inv_aid2 ?? nz)).
Qed.

Transparent cc_inv.

(* Begin_Tex_Verb *)
Lemma cc_Inv : (CSetoid_un_op (NonZeros cc_cring)).
(* End_Tex_Verb *)
Unfold CSetoid_un_op. Apply Build_CSetoid_un_op with cc_inv.
Unfold fun_well_def.
Intro. Elim x. Intro x'. Elim x'. Intros x1 x2 Hx.
Intro. Elim y. Intro y'. Elim y'. Intros y1 y2 Hy.
Simpl. Unfold cc_eq. Simpl. Intros. Elim H. Clear H. Intros.
Cut x1[^](2)[+]x2[^](2) [=] y1[^](2)[+]y2[^](2). Intro.
Split.
Apply div_wd. Auto. Auto.
Apply div_wd. Algebra. Auto.
Algebra.
Unfold fun_strong_ext.
Intro. Elim x. Intro x'. Elim x'. Intros x1 x2 Hx.
Intro. Elim y. Intro y'. Elim y'. Intros y1 y2 Hy.
Simpl. Unfold cc_ap. Simpl. Intros.
Elim H; Clear H; Intros.
Cut (x1 [#] y1) \/ (x1[^](2)[+]x2[^](2) [#] y1[^](2)[+]y2[^](2)). Intro.
Elim H0; Clear H0; Intros.
Left. Auto.
Cut (x1[^](2) [#] y1[^](2)) \/ (x2[^](2) [#] y2[^](2)). Intro.
Elim H1; Clear H1; Intros.
Left. Apply un_op_strext_unfolded with (nexp_op IR (2)). Auto.
Right. Apply un_op_strext_unfolded with (nexp_op IR (2)). Auto.
Apply bin_op_strext_unfolded with (csg_op IR). Auto.
Apply div_strong_ext with (cc_inv_aid x1 x2 Hx) (cc_inv_aid y1 y2 Hy). Auto.
Cut ([--]x2 [#] [--]y2) \/
  (x1[^](2)[+]x2[^](2) [#] y1[^](2)[+]y2[^](2)). Intro.
Elim H0; Clear H0; Intros.
Right. Apply un_op_strext_unfolded with (cg_inv IR). Auto.
Cut (x1[^](2) [#] y1[^](2)) \/ (x2[^](2) [#] y2[^](2)). Intro.
Elim H1; Clear H1; Intros.
Left. Apply un_op_strext_unfolded with (nexp_op IR (2)). Auto.
Right. Apply un_op_strext_unfolded with (nexp_op IR (2)). Auto.
Apply bin_op_strext_unfolded with (csg_op IR). Auto.
Apply div_strong_ext with (cc_inv_aid x1 x2 Hx) (cc_inv_aid y1 y2 Hy). Auto.
Qed.

Transparent cc_Inv.

(* Begin_Tex_Verb *)
Lemma cc_cfield_proof : (is_CField cc_cring cc_Inv).
(* End_Tex_Verb *)
Unfold is_CField. Unfold is_inverse.
Intro. Elim x. Intro x'. Elim x'. Intros x1 x2 Hx.
Simpl. Unfold cc_eq. Simpl.
Split; Rational.
Qed.

Opaque cc_Inv.
Opaque cc_inv.

(* Begin_Tex_Verb *)
Definition cc_cfield := (Build_CField cc_cring cc_Inv cc_cfield_proof).
Definition CC := cc_cfield.

Definition cc_set_CC : IR -> IR -> CC := Build_CC_set.
Definition cc_IR [x:IR]: CC := (cc_set_CC x Zero).

Definition conj : CC -> CC  :=
[z:CC_set](CC_set_rec [_:CC_set]CC_set
	[Re0,Im0:IR](Build_CC_set Re0 [--]Im0) z).

Definition AbsCC [z:CC]: IR :=
(sqrt (((Re z)[^](2)) [+] ((Im z)[^](2)))
	     (cc_abs_aid ? (Re z) (Im z))).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma TwoCC_ap_zero : (Two::CC [#] Zero).
(* End_Tex_Verb *)
Simpl. Unfold cc_ap.
Simpl. Left.
Step_ap_lft Two::IR.
Apply Greater_imp_ap. Apply pos_two.
Qed.

End Complex_Numbers.

Definition I : CC := cc_i.

Infix 5 "[+I*]" cc_set_CC.
Syntax constr level 5:
  cc_set_CC'_infix [<<(cc_set_CC $e1 $e2)>>] ->
    [[<hov 1> $e1:L [0 1] "[+I*]" $e2:L]].


Section I_properties.

(* Begin_Tex_Verb *)
Lemma I_square : I[*]I [=] [--]One.
(* End_Tex_Verb *)
Simpl. Unfold cc_mult. Simpl. Unfold cc_min. Simpl.
Split. Simpl. Rational. Simpl. Rational.
Qed.

Hints Resolve I_square : algebra.

(* Begin_Tex_Verb *)
Lemma I_square' : I[^](2) [=] [--]One.
(* End_Tex_Verb *)
Step_final I[*]I.
Qed.

(* Begin_Tex_Verb *)
Lemma I_inv_lft : ([--]I)[*]I [=] One.
(* End_Tex_Verb *)
Step [--](I[*]I).
Step_final [--][--]One::CC.
Qed.

(* Begin_Tex_Verb *)
Lemma I_inv_rht : I[*]([--]I) [=] One.
(* End_Tex_Verb *)
Step [--](I[*]I).
Step_final [--][--]One::CC.
Qed.

(* Begin_Tex_Verb *)
Lemma mult_I : (x,y:IR)((x[+I*]y)[*]I [=] ([--]y)[+I*]x).
(* End_Tex_Verb *)
Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma I_wd : (x,x',y,y':IR)
  (x [=] x')->(y [=] y')->(x[+I*]y [=] x'[+I*]y').
(* End_Tex_Verb *)
Simpl. Unfold cc_eq. Simpl. Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma calculate_norm : (x,y:IR)
  ((x[+I*]y)[*](conj x[+I*]y) [=] (cc_IR x[^](2)[+]y[^](2))).
(* End_Tex_Verb *)
Intros. Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma calculate_Re: (c:CC)((cc_IR (Re c))[*]Two [=] c[+](conj c)).
(* End_Tex_Verb *)
Intros. Elim c. Intros x y. Intros.
Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma calculate_Im: (c:CC)((cc_IR (Im c))[*](Two[*]I) [=] c[-](conj c)).
(* End_Tex_Verb *)
Intros. Elim c. Intros x y. Intros.
Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma Re_wd : (c,c':CC)(c [=] c')->((Re c) [=] (Re c')).
(* End_Tex_Verb *)
Intros c c'. Elim c. Intros x y. Elim c'. Intros x' y'.
Simpl. Unfold cc_eq. Simpl. Intros. Elim H. Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma Im_wd : (c,c':CC)(c [=] c')->((Im c) [=] (Im c')).
(* End_Tex_Verb *)
Intros c c'. Elim c. Intros x y. Elim c'. Intros x' y'.
Simpl. Unfold cc_eq. Simpl. Intros. Elim H. Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma Re_resp_plus :(x,y:CC)(Re (x[+]y)) [=] (Re x)[+](Re y).
(* End_Tex_Verb *)
Intros. Elim x. Intros x1 x2. Elim y. Intros y1 y2.
Simpl. Unfold cc_eq. Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma Re_resp_min :(x,y:CC)(Re (x[-]y)) [=] (Re x)[-](Re y).
(* End_Tex_Verb *)
Intros. Elim x. Intros x1 x2. Elim y. Intros y1 y2.
Simpl. Unfold cc_eq. Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma Im_resp_plus :(x,y:CC)(Im (x[+]y)) [=] (Im x)[+](Im y).
(* End_Tex_Verb *)
Intros. Elim x. Intros x1 x2. Elim y. Intros y1 y2.
Simpl. Unfold cc_eq. Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma Im_resp_min :(x,y:CC)(Im (x[-]y)) [=] (Im x)[-](Im y).
(* End_Tex_Verb *)
Intros. Elim x. Intros x1 x2. Elim y. Intros y1 y2.
Simpl. Unfold cc_eq. Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_calculate_square : (x,y:IR)
  ((x[+I*]y)[^](2) [=] (x[^](2)[-]y[^](2))[+I*]((x[*]y)[*]Two)).
(* End_Tex_Verb *)
Intros. Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

End I_properties.

Hints Resolve I_square I_square' I_inv_lft I_inv_rht mult_I
  calculate_norm cc_calculate_square : algebra.
Hints Resolve I_wd Re_wd Im_wd : algebra_c.


Section Conj_properties.

(* Begin_Tex_Verb *)
Lemma conj_1 : (c,c':CC)((conj c[+]c') [=] (conj c)[+](conj c')).
(* End_Tex_Verb *)
Intros c c'. Elim c. Intros x y. Elim c'. Intros x' y'.
Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma conj_2 : (c,c':CC)((conj c[*]c') [=] (conj c)[*](conj c')).
(* End_Tex_Verb *)
Intros c c'. Elim c. Intros x y. Elim c'. Intros x' y'.
Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

Hints Resolve conj_2 : algebra.

(* Begin_Tex_Verb *)
Lemma conj_4 : (c,c':CC)((conj c) [#] (conj c'))->(c [#] c').
(* End_Tex_Verb *)
Intros c c'. Elim c. Intros x y. Elim c'. Intros x' y'.
Simpl. Unfold cc_ap. Simpl. Intros.
Elim H; Clear H; Intros.
Left. Auto.
Right. Apply un_op_strext_unfolded with (cg_inv IR). Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma conj_5 : (c:CC)((conj (conj c)) [=] c).
(* End_Tex_Verb *)
Intros. Elim c. Intros x y. Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma conj_6 : (conj Zero) [=] Zero.
(* End_Tex_Verb *)
Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma conj_7 : (conj One) [=] One.
(* End_Tex_Verb *)
Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

Hints Resolve conj_7 : algebra.

(* Begin_Tex_Verb *)
Lemma conj_3 : (c:CC)(n:nat)((conj c[^]n) [=] (conj c)[^]n).
(* End_Tex_Verb *)
Intros. Induction n; Intros.
Step (conj One).
Step_final One::CC.
Step (conj c[^]n[*]c).
Step (conj c[^]n)[*](conj c).
Step_final (conj c)[^]n[*](conj c).
Qed.

End Conj_properties.

Hints Resolve conj_1 conj_2 conj_3 conj_5 conj_6 : algebra.


Section cc_IR_properties.

(* Begin_Tex_Verb *)
Lemma cc_IR_1 : (x,y:IR) (x [=] y) -> (cc_IR x) [=] (cc_IR y).
(* End_Tex_Verb *)
Intros. Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

Hints Resolve cc_IR_1 : algebra_c.

(* Begin_Tex_Verb *)
Lemma cc_IR_1a : (x,y:IR) (x [#] y) -> (cc_IR x) [#] (cc_IR y).
(* End_Tex_Verb *)
Intros. Simpl. Unfold cc_ap. Simpl. Left. Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_IR_2 : (x,y:IR) (cc_IR x)[*](cc_IR y) [=] (cc_IR x[*]y).
(* End_Tex_Verb *)
Intros. Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

Hints Resolve cc_IR_2 : algebra.

(* Begin_Tex_Verb *)
Lemma cc_IR_4a : (x,y,z:IR) x[+I*]y[*](cc_IR z) [=] (x[*]z)[+I*](y[*]z).
(* End_Tex_Verb *)
Intros. Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_IR_4b : (x,y,z:IR) (cc_IR z)[*]x[+I*]y [=] (z[*]x)[+I*](z[*]y).
(* End_Tex_Verb *)
Intros. Simpl. Unfold cc_eq. Simpl. Split; Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_IR_5a : (x,y:IR) (cc_IR x)[+](cc_IR y) [=] (cc_IR x[+]y).
(* End_Tex_Verb *)
Intros. Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

Hints Resolve cc_IR_5a : algebra.

(* Begin_Tex_Verb *)
Lemma cc_IR_5b : (x,y:IR) (cc_IR x)[-](cc_IR y) [=] (cc_IR x[-]y).
(* End_Tex_Verb *)
Intros. Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_IR_zero : (cc_IR Zero) [=] Zero.
(* End_Tex_Verb *)
Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

Hints Resolve cc_IR_zero : algebra.

(* Begin_Tex_Verb *)
Lemma cc_IR_one : (cc_IR One) [=] One.
(* End_Tex_Verb *)
Simpl. Unfold cc_eq. Simpl. Split; Algebra.
Qed.

Hints Resolve cc_IR_one : algebra.

(* Begin_Tex_Verb *)
Lemma cc_IR_Nring : (n:nat)((cc_IR (Nring n)) [=] (Nring n)).
(* End_Tex_Verb *)
Intros. Induction n; Intros.
Step (cc_IR Zero).
Step_final Zero::CC.
Step (cc_IR (Nring n)[+]One).
Step (cc_IR (Nring n))[+](cc_IR One).
Step_final (Nring n)[+]One::CC.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_IR_3 : (x:IR)(n:nat) (cc_IR x)[^]n [=] (cc_IR x[^]n).
(* End_Tex_Verb *)
Intros. Induction n; Intros.
Step One::CC.
Step_final (cc_IR One).
Step (cc_IR x)[^]n[*](cc_IR x).
Step (cc_IR x[^]n)[*](cc_IR x).
Step_final (cc_IR x[^]n[*]x).
Qed.

End cc_IR_properties.

Hints Resolve cc_IR_1 : algebra_c.
Hints Resolve cc_IR_2 cc_IR_3 cc_IR_4a cc_IR_4b cc_IR_5a cc_IR_5b : algebra.
Hints Resolve cc_IR_Nring cc_IR_zero : algebra.


Section AbsCC_properties.

(* Begin_Tex_Verb *)
Lemma AbsCC_wd : (x,y:CC)(x [=] y) -> ((AbsCC x) [=] (AbsCC y)).
(* End_Tex_Verb *)
Intros x y. Elim x. Intros x1 x2. Elim y. Intros y1 y2.
Simpl. Unfold cc_eq. Unfold AbsCC. Simpl. Intros.
Change (sqrt x1[^](2)[+]x2[^](2) (cc_abs_aid ? x1 x2)) [=]
  (sqrt y1[^](2)[+]y2[^](2) (cc_abs_aid ? y1 y2)).
Elim H. Clear H. Intros.
Apply sqrt_wd. Algebra.
Qed.

Hints Resolve AbsCC_wd : algebra_c.

(* Begin_Tex_Verb *)
Lemma cc_minus_abs :
(x:CC)(AbsCC ([--]x)) [=] (AbsCC x).
(* End_Tex_Verb *)
Intros.
Unfold AbsCC.
Apply sqrt_wd.
Apply bin_op_wd_unfolded.
Step_final ([--](Re x))[^](2).
Step_final ([--](Im x))[^](2).
Qed.

Hints Resolve cc_minus_abs : algebra.

(* Begin_Tex_Verb *)
Lemma cc_min_abs :
(x,y:CC)(AbsCC (x[-]y)) [=] (AbsCC(y[-]x)).
(* End_Tex_Verb *)
Intros.
Apply eq_transitive_unfolded with (AbsCC [--](y[-]x)).
Apply AbsCC_wd. Rational.
Apply cc_minus_abs.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_mult_abs :
(x,y:CC)(AbsCC (x[*]y)) [=] ((AbsCC x)[*](AbsCC y)).
(* End_Tex_Verb *)
Intros x y. Elim x. Intros x1 x2. Elim y. Intros y1 y2. Intros.
Unfold AbsCC.
Apply sqrt_mult_wd.
Simpl.
Rational.
Qed.

Hints Resolve cc_mult_abs : algebra.

(* Begin_Tex_Verb *)
Lemma AbsCC_minzero : (x:CC)(AbsCC(x[-]Zero))[=] (AbsCC x).
(* End_Tex_Verb *)
Intros.
Apply AbsCC_wd.
Algebra.
Qed.

(* Begin_Tex_Verb *)
Lemma AbsCC_IR : (x:IR)(Zero [:<=] x) -> (AbsCC (cc_IR x)) [=] x.
(* End_Tex_Verb *)
Intros. Unfold AbsCC.
Change (sqrt x[^](2)[+]Zero[^](2) (cc_abs_aid ? x Zero)) [=] x.
Apply eq_transitive_unfolded with (sqrt x[^](2) (sqr_nonneg ? x)).
Apply sqrt_wd. Rational.
Apply sqrt_to_nonneg. Auto.
Qed.

Hints Resolve AbsCC_IR : algebra.

(* Begin_Tex_Verb *)
Lemma cc_div_abs :
(x,y:CC)(nz:y[#]Zero)(anz:(AbsCC y)[#]Zero)
  (AbsCC (x[/]y[//]nz)) [=] (AbsCC x)[/](AbsCC y)[//]anz.
(* End_Tex_Verb *)
Intros.
Step_Rat_lft ((AbsCC y)[*](AbsCC (x[/]y[//]nz)))[/](AbsCC y)[//]anz.
Apply div_wd. 2: Algebra.
Step (AbsCC y[*](x[/]y[//]nz)).
Apply AbsCC_wd. Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_div_abs' :
(x:CC)(y:IR)(nz:y[#]Zero)(cnz:(cc_IR y)[#]Zero)(Zero [:<=] y) ->
  (AbsCC (x[/](cc_IR y)[//]cnz)) [=] (AbsCC x)[/]y[//]nz.
(* End_Tex_Verb *)
Intros.
Step_Rat_lft (y[*](AbsCC x[/](cc_IR y)[//]cnz))[/]y[//]nz.
Apply div_wd. 2: Algebra.
Step (AbsCC (cc_IR y))[*](AbsCC x[/](cc_IR y)[//]cnz).
Step (AbsCC (cc_IR y)[*](x[/](cc_IR y)[//]cnz)).
Apply AbsCC_wd.
Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma AbsCC_zero : (AbsCC Zero) [=] Zero.
(* End_Tex_Verb *)
Step (AbsCC (cc_IR Zero)).
Apply AbsCC_IR.
Apply leEq_reflexive.
Qed.

Hints Resolve AbsCC_zero : algebra.

(* Begin_Tex_Verb *)
Lemma AbsCC_one : (AbsCC One) [=] One.
(* End_Tex_Verb *)
Step (AbsCC (cc_IR One)).
Apply AbsCC_IR.
Apply less_leEq. Apply pos_one.
Qed.

(* Begin_Tex_Verb *)
Lemma cc_pow_abs :
(x:CC; n:nat)(AbsCC (x[^]n)) [=] ((AbsCC x)[^]n).
(* End_Tex_Verb *)
Intros. Induction n; Intros.
Simpl. Apply AbsCC_one.
Simpl. Step_final (AbsCC x[^]n)[*](AbsCC x).
Qed.

(* Begin_Tex_Verb *)
Lemma AbsCC_pos : (x:CC)(x [#] Zero) -> (Zero [:<] (AbsCC x)).
(* End_Tex_Verb *)
Intro. Elim x. Intros x1 x2.
Unfold AbsCC. Simpl. Unfold cc_ap. Simpl. Intros.
Change Zero [:<] (sqrt x1[^](2)[+]x2[^](2) (cc_abs_aid ? x1 x2)).
Apply power_cancel_less with (2). Apply sqrt_nonneg.
Step_less_lft Zero::IR.
Step_less_rht x1[^](2)[+]x2[^](2).
Elim H; Clear H; Intros.
Apply plus_resp_pos_nonneg.
Apply pos_square. Auto. Apply sqr_nonneg.
Apply plus_resp_nonneg_pos.
Apply sqr_nonneg. Apply pos_square. Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma AbsCC_ap_zero : (x:CC)(Zero [#] (AbsCC x)) -> (x [#] Zero).
(* End_Tex_Verb *)
Intro. Elim x. Intros x1 x2. Simpl. Unfold AbsCC. Unfold cc_ap.
Change (Zero [#] (sqrt x1[^](2)[+]x2[^](2) (cc_abs_aid ? x1 x2))) ->
  (x1 [#] Zero) \/ (x2 [#] Zero).
Intros.
Cut (x1[^](2) [#] Zero) \/ (x2[^](2) [#] Zero). Intro.
Elim H0; Clear H0; Intros.
Left.
Apply cring_mult_ap_zero with x1.
Step_ap_lft x1[^](2).
Right.
Apply cring_mult_ap_zero with x2.
Step_ap_lft x2[^](2).
Apply cg_add_ap_zero.
Step_ap_lft (sqrt x1[^](2)[+]x2[^](2) (cc_abs_aid ? x1 x2))[^](2).
Apply nexp_resp_ap_zero.
Apply ap_symmetric_unfolded. Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma AbsCC_nonneg : (x:CC)(Zero [:<=] (AbsCC x)).
(* End_Tex_Verb *)
Unfold AbsCC. Intros.
Apply sqrt_nonneg.
Qed.

(* Begin_Tex_Verb *)
Lemma AbsCC_small_imp_eq :
  (x:CC)((e:IR)(Zero [:<] e) -> (AbsCC x) [:<] e) -> x [=] Zero.
(* End_Tex_Verb *)
Intros.
Apply not_ap_imp_eq. Intro.
Apply (less_irreflexive_unfolded ? (AbsCC x)).
Apply H.
Apply AbsCC_pos. Auto.
Qed.

Definition AbsSmallCC :=
[e:IR;x:CC]((AbsCC x) [:<] e).

Lemma exis_AFS_CC : (x,y:CC;eps:IR)(Zero [:<] eps) ->
                 (Ex [y':CC]((AbsSmallCC eps (y' [-] y)) /\ (y' [#] x))).
Unfold AbsSmallCC. Intros.
Cut eps[/]TwoNZ [:<] eps. Intro.
Cut Zero [:<=] eps[/]TwoNZ. Intro.
Cut (y[-](cc_IR eps[/]TwoNZ) [#] x) \/ (x [#] y[+](cc_IR eps[/]TwoNZ)).
Intro. Elim H2; Clear H2; Intros.
Exists y[-](cc_IR eps[/]TwoNZ).
Split.
Apply less_wdl with (AbsCC [--](cc_IR eps[/]TwoNZ)).
Step_less_lft (AbsCC (cc_IR eps[/]TwoNZ)).
Apply less_wdl with eps[/]TwoNZ. Auto. Algebra.
Apply AbsCC_wd. Rational.
Auto.
Exists y[+](cc_IR eps[/]TwoNZ).
Split.
Apply less_wdl with (AbsCC (cc_IR eps[/]TwoNZ)).
Apply less_wdl with eps[/]TwoNZ. Auto. Algebra.
Apply AbsCC_wd. Rational.
Apply ap_symmetric_unfolded. Auto.
Apply ap_cotransitive_unfolded.
Step_ap_lft y[+][--](cc_IR eps[/]TwoNZ).
Apply op_lft_resp_ap.
Apply ap_symmetric_unfolded.
Apply zero_minus_apart.
Step_Rat_ap_lft (cc_IR eps[/]TwoNZ)[+](cc_IR eps[/]TwoNZ).
Step_ap_lft (cc_IR eps[/]TwoNZ[+]eps[/]TwoNZ).
Step_ap_rht (cc_IR Zero).
Apply cc_IR_1a.
Step_Rat_ap_lft eps.
Apply Greater_imp_ap. Auto.
Apply less_leEq.
Apply div_resp_pos. Apply pos_two. Auto.
Apply shift_div_less. Apply pos_two.
Step_less_lft eps[*]One.
Apply mult_resp_less_lft.
Step_less_lft One[+]Zero::IR. Step_Rat_less_rht One[+]One::IR.
Apply plus_resp_less_lft. Apply pos_one.
Auto.
Qed.

End AbsCC_properties.

Hints Resolve AbsCC_wd : algebra_c.
Hints Resolve cc_minus_abs cc_mult_abs cc_div_abs cc_div_abs' cc_pow_abs
  AbsCC_zero AbsCC_one AbsCC_IR : algebra.


