(* $Id: CPoly_Contin1.v,v 1.6 2000/11/10 11:27:28 freek Exp $ *)

Require Export CC_Props.

Section Mult_CC_Continuous.

Lemma mult_absCC :
  (x,y:CC; X,Y:IR)
    ((AbsCC x) [:<] X) -> ((AbsCC y) [:<] Y) -> ((AbsCC x[*]y) [:<] X[*]Y).
Intros.
Step_less_lft (AbsCC x)[*](AbsCC y).
Apply mult_resp_less_both.
Apply AbsCC_nonneg. Auto. Apply AbsCC_nonneg. Auto.
Qed.

Lemma estimate_absCC : (x:CC)(EX X | (Zero [:<] X) /\ ((AbsCC x) [:<] X)).
Intros.
Exists (AbsCC x)[+]One. Split.
Step_less_lft Zero[+]Zero::IR.
Apply plus_resp_leEq_less. Apply AbsCC_nonneg. Apply pos_one.
Step_less_lft (AbsCC x)[+]Zero.
Apply plus_resp_less_lft. Apply pos_one.
Qed.

Lemma mult_CC_contin :
  (x,y:CC;e:IR)(Zero [:<] e) ->
    (EX c | (Zero [:<] c) /\ (EX d | (Zero [:<] d) /\
      (x',y':CC)((AbsCC x[-]x') [:<] c) -> ((AbsCC y[-]y') [:<] d) ->
        ((AbsCC x[*]y[-]x'[*]y') [:<] e))).
Intros.
Cut Zero [:<] e[/]TwoNZ. Intro.
Elim (estimate_absCC x). Intro X. Intros.
Elim H1. Clear H1. Intros.
Elim (estimate_absCC y). Intro Y. Intros.
Elim H3. Clear H3. Intros.
Cut Y [#] Zero. Intro.
Exists (e[/]TwoNZ)[/]Y[//]H5.
Split.
Apply div_resp_pos. Auto. Auto.
Cut Zero [:<] X[+](e[/]TwoNZ)[/]Y[//]H5. Intro.
Cut X[+](e[/]TwoNZ)[/]Y[//]H5 [#] Zero. Intro.
Exists (e[/]TwoNZ)[/](X[+](e[/]TwoNZ)[/]Y[//]H5)[//]H7.
Split.
Apply div_resp_pos. Auto. Auto.
Intros.
Apply less_wdl with (AbsCC (x[-]x')[*]y[+]x'[*](y[-]y')).
Apply leEq_less_trans with
  (AbsCC (x[-]x')[*]y)[+](AbsCC x'[*](y[-]y')).
Apply triangle.
Step_Rat_less_rht e[/]TwoNZ[+]e[/]TwoNZ.
Apply plus_resp_less_both.
Apply less_wdr with ((e[/]TwoNZ)[/]Y[//]H5)[*]Y.
Apply mult_absCC; Auto.
Rational.
Apply less_wdr with
  (X[+](e[/]TwoNZ)[/]Y[//]H5)[*]
    ((e[/]TwoNZ)[/](X[+](e[/]TwoNZ)[/]Y[//]H5)[//]H7).
Apply mult_absCC; Auto.
Apply less_wdl with (AbsCC x[+](x'[-]x)).
Apply leEq_less_trans with (AbsCC x)[+](AbsCC x'[-]x).
Apply triangle.
Apply plus_resp_less_both. Auto.
Step_less_lft (AbsCC [--](x'[-]x)).
Apply less_wdl with (AbsCC x[-]x'). Auto.
Apply AbsCC_wd. Rational.
Apply AbsCC_wd. Rational.
Rational.
Apply AbsCC_wd. Rational.
Apply Greater_imp_ap. Auto.
Apply plus_resp_pos; Auto.
Apply div_resp_pos; Auto.
Apply Greater_imp_ap. Auto.
Apply div_resp_pos. Apply pos_two. Auto.
Qed.

End Mult_CC_Continuous.


Section CPoly_CC_Continuous.

Variable g : (cpoly_cring CC).

Lemma cpoly_CC_contin :
  (x:CC;e:IR)(Zero [:<] e) ->
    (EX d | (Zero [:<] d) /\
      (x':CC)((AbsCC x[-]x') [:<] d) -> ((AbsCC g!x[-]g!x') [:<] e)).
Elim g.
Intros.
Exists One::IR. Intros. Split. Apply pos_one. Intros.
Apply less_wdl with Zero::IR. Auto.
Cut Zero [=] (AbsCC Zero[-]Zero). Auto.
Step_final (AbsCC Zero).
Intros a f. Intros.
Elim (mult_CC_contin x f!x e H0). Intro d1. Intros.
Elim H1. Clear H1. Intros.
Elim H2. Clear H2. Intro c. Intros.
Elim H2. Clear H2. Intros.
Elim (H x c H2). Clear H. Intro d2. Intros.
Elim H. Clear H. Intros.
Elim (smaller ? d1 d2 H1 H). Intro d. Intros.
Elim H5. Clear H5. Intros. Elim H6. Clear H6. Intros.
Exists d. Split. Auto. Intros.
Simpl.
Cut (AbsCC (a[+](x[*]f!x))[-](a[+](x'[*]f!x'))) [:<] e. Auto.
Apply less_wdl with (AbsCC x[*]f!x[-]x'[*]f!x').
Apply H3. Clear H3.
Apply less_transitive_unfolded with d; Auto.
Apply H4. Clear H4.
Apply less_transitive_unfolded with d; Auto.
Apply AbsCC_wd.
Rational.
Qed.

Lemma contin_polyCC : (CCcontin [x:CC](g!x)).
Unfold CCcontin. Unfold CCcontinAt. Unfold CCfunLim.
Intros.
Elim (cpoly_CC_contin x e); Auto.
Intro d. Intros. Elim H0. Clear H0. Intros.
Exists d. Split. Auto. Intros.
Apply H1; Auto.
Qed.

End CPoly_CC_Continuous.


