(* $Id: CSumsReals.v,v 1.14 2000/11/10 11:27:31 freek Exp $ *)

Require Export CReals1.

(* Tex_Prose
\section{Sums over Reals}

\begin{convention}
Let \verb!c! be a real.
\end{convention}

Here we prove that
\[\Sigma_{m\leq i \leq n}~c^k = \frac{c^{n+1}-c^m}{c-1}.\]
*)

Section Sums_over_Reals.

Variable c: IR.

(* Begin_Tex_Verb *)
Lemma sum0_c_exp : (H:c[-]One[#]Zero)(m:nat)
        ((sum0 IR m [i:nat](c[^]i)) [=] ((c[^]m [-] One)[/](c [-] One)[//]H)).
(* End_Tex_Verb *)
Intros.
Elim m.
Simpl.
Rational.
Simpl.
Intros.
Step_lft ((nexp IR c n)[-]One)[/](c[-]One)[//]H [+](nexp IR c n).
Rational.
Qed.

Hints Resolve sum0_c_exp.

(* Begin_Tex_Verb *)
Lemma sum_c_exp : (H:c[-]One[#]Zero)
                      (m,n:nat)((Sum m n [i:nat](c[^]i))
                      [=]((c[^](S n) [-] c[^]m)[/](c [-] One)[//]H)).
(* End_Tex_Verb *)
Intros.
Unfold sum.
Unfold sum1.
Step_lft ((c[^](S n) [-] One)[/](c [-] One)[//]H) [-]
         ((c[^]m [-] One)[/](c [-] One)[//]H).
Rational.
Qed.
Hints Resolve sum_c_exp.

(* Tex_Prose
The following formulation is often more useful if $c<1$.
*)
(* Begin_Tex_Verb *)
Lemma sum_c_exp' : (H:One[-]c[#]Zero)
                       (m,n:nat)((Sum m n [i:nat](c[^]i))
		        [=]((c[^]m [-] c[^](S n))[/](One [-] c)[//]H)).
(* End_Tex_Verb *)
Intros.
Cut c[-]One [#]Zero.
Intro.
Step_lft ((c[^](S n) [-] c[^]m)[/](c [-] One)[//]H0).
Rational.
Step_Rat_ap_lft [--](One[-]c).
Apply min_resp_ap_zero.
Assumption.
Qed.

Hints Resolve sum_c_exp'.

End Sums_over_Reals.

Hints Resolve sum0_c_exp sum_c_exp sum_c_exp' : algebra.

Lemma diff_is_sum0 : (s:nat->IR)(n:nat)
	((s n) [-] (s O))  [=]  (Sum0 n [i:nat](s (S i))[-](s i)).
Proof.
Intros s.
Induction n.
Simpl. Algebra.
Intros.
Simpl.
Apply eq_transitive_unfolded with
	(((s (S n0))[-] (s(n0))) [+] ((s(n0))[-](s (0)))).
Rational.
Apply eq_transitive_unfolded with
	((s (S n0))[-](s n0)
            [+](sum0 (IR) n0 [i:nat](s (S i))[-](s i)) ).
Exact (plus_resp_eq ???? H).
Rational.
Qed.


Lemma diff_is_sum : (s:nat->IR)(N,m:nat)
	(lt N m) ->
	((s m) [-] (s N))  [=]  (Sum N (pred m) [i:nat](s (S i))[-](s i)).
Proof.
Intros s N m ltNm.
Unfold sum.Unfold sum1.
Generalize (S_pred m N ltNm).
Intro H.
Rewrite <- H.
Generalize (diff_is_sum0 s N).
Intro HsN.
Generalize (diff_is_sum0 s m).
Intro Hsm.
Apply eq_transitive_unfolded with (((s m) [-] (s O)) [-] ((s N) [-] (s O))).
Rational.
Apply (cg_minus_wd IR).
Assumption.
Assumption.
Qed.

Lemma  sum0_pres_less : (s,t:nat->IR)
	((i:nat)((s i)[:<](t i)))
	-> (n:nat) (Sum0 n s)  [:<=]  (Sum0 n t).
Proof.
Intros s t H.
Induction n.
Simpl.
Exact (leEq_reflexive ??).
Intros.
Simpl.
Apply leEq_transitive with ((sum0 (IR) n0 t)[+](s n0)).
Apply plus_resp_leEq.
Assumption.
Apply plus_resp_leEq_lft.
Apply less_leEq;Exact (H ?).
Qed.

Lemma sum_pres_less : (s,t:nat->IR)
	((i:nat)((s i)[:<](t i))) -> (N,m:nat)
	 (le N m) ->
	((Sum N m s)  [:<=]  (Sum N m t)).
Intros.
Apply less_leEq.
Apply sum_resp_less; Auto.
Qed.

Lemma sum0_comm_scal : (s:nat->IR;a:IR)
	 (m:nat)
	(Sum0 m [i:nat]((s i)[*]a))  [=]  (Sum0 m [i:nat](s i))[*]a.
Intros. Induction m; Intros.
Simpl. Algebra.
Simpl. Step_final (Sum0 m [i:nat](s i))[*]a[+](s m)[*]a.
Qed.

Hints Resolve sum0_comm_scal : algebra.

Lemma sum_comm_scal : (s:nat->IR;a:IR)
	 (N,m:nat)
	(Sum N m [i:nat]((s i)[*]a))  [=]  (Sum N m [i:nat](s i))[*]a.
Unfold sum. Unfold sum1. Intros.
Step_final (Sum0 (S m) [i:nat](s i))[*]a[-](Sum0 N [i:nat](s i))[*]a.
Qed.


