(* $Id: Expon.v,v 1.16 2000/11/03 13:09:30 freek Exp $ *)

Require Export Arith.
Require Export COrdFields.

Load Transparent_algebra.

(* Tex_Prose
\section{Exponentiation}
\subsection{More properties about {\tt nexp}}
\begin{convention}
Let \verb!R! be an ordered field.
\end{convention}
*)
Section More_Nexp.

Variable R:COrdField.

(* Begin_Tex_Verb *)
Lemma nexp_resp_ap_zero : (x:R)(n:nat)(x[#]Zero)->(x[^]n [#] Zero).
(* End_Tex_Verb *)
Intros.
Elim n.
Simpl.
Algebra.
Intros.
Simpl.
Apply mult_resp_ap_zero.
Assumption.
Assumption.
Qed.

Hints Resolve nexp_resp_ap_zero : algebra.

(* Begin_Tex_Verb *)
Lemma nexp_distr_div : (x,y:R)(n:nat)(H:y[#]Zero)(H1:y[^]n[#]Zero)
                       (x[/]y[//]H) [^] n [=] (x[^]n) [/] (y[^]n) [//] H1.
(* End_Tex_Verb *)
Induction n.
Intros.
Simpl.
Algebra.
Intros.
Simpl.
Generalize (H H0 (nexp_resp_ap_zero y n0 H0)); Intro.
Step_lft  (x[^]n0[/]y[^]n0[//](nexp_resp_ap_zero y n0 H0)) [*] (x[/]y[//]H0).
Simpl.
Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma nexp_distr_div' : (x,y:R)(n:nat)(H:y[#]Zero)
        (x[/]y[//]H) [^] n [=] (x[^]n) [/] (y[^]n) [//] (nexp_resp_ap_zero y n H).
(* End_Tex_Verb *)
Intros.
Apply nexp_distr_div.
Qed.

(* Begin_Tex_Verb *)
Lemma small_nexp_resp_lt : (x:R)(m,n:nat)
            (Zero [:<] x) -> (x [:<] One) -> (lt m n) -> x[^]n [:<] x[^]m.
(* End_Tex_Verb *)
Intros.
Cut (k:nat)(lt O k)-> x[^]k [:<] One.
Intro.
Replace n with (plus m (minus n m)).
Step_less_lft x[^]m [*] x[^](minus n m).
Step_less_rht x[^]m [*] One.
Apply mult_resp_less_lft.
Apply H2.
Omega.
Apply nexp_resp_pos.
Assumption.
Omega.
Induction k.
Intro.
ElimType False.
Omega.
Intros.
Elim n0.
Step_less_lft x.
Assumption.
Intros.
Step_less_lft x[*](x[^](S n1)).
Step_less_rht One[*]One::R.
Apply mult_resp_less_both.
Apply less_leEq.
Assumption.
Assumption.
Apply less_leEq.
Apply nexp_resp_pos.
Assumption.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma great_nexp_resp_lt : (x:R)(m,n:nat)
            (One [:<] x) -> (lt m n) -> x[^]m [:<] x[^]n.
(* End_Tex_Verb *)
Intros. Induction n; Intros.
Inversion H0.
Cut (le m n). Intro.
Cut x[^]n [:<] x[^](S n). Intro.
Elim (le_lt_eq_dec ?? H1); Intros.
Apply less_transitive_unfolded with x[^]n; Auto.
Rewrite y. Auto.
Step_less_lft x[^]n[*]One.
Step_less_rht x[^]n[*]x.
Apply mult_resp_less_lft. Auto.
Apply nexp_resp_pos.
Apply less_transitive_unfolded with One::R. Apply pos_one. Auto.
Auto with arith.
Qed.

(* Begin_Tex_Verb *)
Lemma small_nexp_resp_le : (x:R)(m,n:nat)
            (Zero [:<] x) -> (x [:<] One) -> (le m n) -> x[^]n [:<=] x[^]m.
(* End_Tex_Verb *)
Intros.
Elim (le_lt_or_eq ?? H1); Intro.
Apply less_leEq.
Apply small_nexp_resp_lt; Assumption.
Rewrite H2.
Apply leEq_reflexive.
Qed.

(* Begin_Tex_Verb *)
Lemma great_nexp_resp_le : (x:R)(m,n:nat)
            (One [:<] x) -> (le m n) -> x[^]m [:<=] x[^]n.
(* End_Tex_Verb *)
Intros.
Elim (le_lt_eq_dec ?? H0); Intros.
Apply less_leEq. Apply great_nexp_resp_lt; Auto.
Rewrite y. Apply leEq_reflexive.
Qed.

(* Begin_Tex_Verb *)
Lemma nexp_resp_leEq :
                (x,y:R)(k:nat)(Zero [:<=] x)->(x [:<=] y)->(x[^]k [:<=] y[^]k).
(* End_Tex_Verb *)
Unfold leEq. Intros. Intro. Apply H0.
Apply power_cancel_less with k; Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma nexp_distr_recip : (x:R)(n:nat)(H:x[#]Zero)(H1:x[^]n[#]Zero)
                         (One[/]x[//]H)[^]n [=] One[/](x[^]n)[//]H1.
(* End_Tex_Verb *)
Intros. Induction n; Intros.
Simpl. Algebra.
Step (One[/]x[//]H)[^]n[*](One[/]x[//]H).
Cut x[^]n [#] Zero. Intro.
Step (One[/]x[^]n[//]H0)[*](One[/]x[//]H).
Cut x[^]n[*]x [#] Zero. Intro.
Step_Rat_lft One[/](x[^]n[*]x)[//]H2.
Apply div_wd; Algebra.
Apply mult_resp_ap_zero; Auto.
Apply nexp_resp_ap_zero. Auto.
Qed.

Hints Resolve nexp_distr_recip : algebra.

End More_Nexp.

Hints Resolve nexp_distr_div nexp_distr_recip : algebra.

Syntactic Definition Nexp_resp_ap_zero := (nexp_resp_ap_zero ?).

(* Tex_Prose
\subsection{Definition of {\tt zexp} : integer exponentiation}
\begin{convention}
Let \verb!R! be an ordered field.
\end{convention}
*)

Section Zexp_def.

Variable R : CField.

(* Tex_Prose
It would be nicer to define \verb!zexp! using \verb!caseZdiff!, but we already
have most properties now.
*)

(* Begin_Tex_Verb *)
Definition zexp[n:Z; x:(NonZeros R)] : R :=
         Cases n of
           ZERO => (One::R)
         | (POS p) => (NZinj x) [^] (convert p)
         | (NEG p) => (One[/]x) [^] (convert p)
         end.
(* End_Tex_Verb *)

End Zexp_def.

(* Tex_Prose
\begin{notation}
\verb!a [^^] b! stands for \verb!zexp ? a b!.
\end{notation}
*)

Syntactic Definition Zexp := (zexp ?).
Grammar command command2 :=
  Zexp_nifix [ command2($c2) "[^^]" command1($c1) ] ->
    [<<((Zexp $c1) $c2)>>].
Syntax constr level 2:
  zexp_nifix [<<(zexp $_ $e1 $e2)>>] ->
    [[<hov 1> $e2:E [0 1] "[^^]" $e1:L]].

(* Tex_Prose
\subsection{Properties of {\tt zexp}}
\begin{convention}
Let \verb!R! be an ordered field.
\end{convention}
*)

Section Zexp_properties.

Variable R:COrdField.

(* Begin_Tex_Verb *)
Lemma zexp_zero : (x:R)(H:x[#]Zero) ((x[//]H) [^^] `0`) [=] One.
(* End_Tex_Verb *)
Intros.
Unfold zexp.
Algebra.
Qed.

Hints Resolve zexp_zero : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_nexp : (x:R)(H:x[#]Zero)(n:nat)
                  ((x[//]H) [^^] n) [=] (x [^] n).
(* End_Tex_Verb *)
Intros.
Unfold zexp.
Simpl.
Elim n.
Simpl.
Algebra.
Intros.
Simpl.
Rewrite bij1.
Simpl.
Algebra.
Qed.

Hints Resolve zexp_nexp : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_min_nexp : (x:R)(H:x[#]Zero)(n:nat)
                      ((x[//]H) [^^] `-n`) [=] ((One[/]x[//]H) [^] n).
(* End_Tex_Verb *)
Intros.
Unfold zexp.
Simpl.
Elim n.
Simpl.
Algebra.
Intros.
Simpl.
Rewrite bij1.
Simpl.
Algebra.
Qed.

Hints Resolve zexp_min_nexp : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_min_nexp' : (x:R)(n:nat)(H:x[#]Zero)(H1:x[^]n[#]Zero)
                       ((x[//]H) [^^] `-n`) [=] (One[/](x [^] n)[//]H1).
(* End_Tex_Verb *)
Intros.
Step_lft (One [/] x [//] H) [^] `n`.
Step_rht (One[^]n [/]x[^]n[//]H1).
Apply nexp_distr_div.
Qed.

Hints Resolve zexp_min_nexp' : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_strong_ext : (x,y:R)(m:Z)(Hx:x[#]Zero)(Hy:y[#]Zero)
                       ((x[//]Hx)[^^]m [#] (y[//]Hy)[^^] m) ->
                       x [#] y.
(* End_Tex_Verb *)
Intros x y m Hx Hy.
Pattern m.
Apply nats_Z_ind.
Intros.
Apply (nexp_strong_ext R n).
Change (x[^]n) [#] (y[^]n).
Step_ap_lft (x[//]Hx)[^^](n).
Step_ap_rht (y[//]Hy)[^^](n).
Intros.
Apply (nexp_strong_ext R n).
Change (x[^]n) [#] (y[^]n).
Cut One[/](x[^]n) [//] (Nexp_resp_ap_zero x n Hx) [#]
    One[/](y[^]n) [//] (Nexp_resp_ap_zero y n Hy).
Intro.
Generalize (div_strong_ext ??????? H0); Intro.
Elim H1; Intros.
Elim (ap_irreflexive_unfolded ?? H2).
Assumption.
Step_ap_lft (x[//]Hx)[^^]`-n`.
Step_ap_rht (y[//]Hy)[^^]`-n`.
Qed.

(* Begin_Tex_Verb *)
Lemma zexp_well_def : (x,y:R)(m:Z)(Hx:x[#]Zero)(Hy:y[#]Zero)(x [=] y) ->
                       ((x[//]Hx)[^^]m [=] (y[//]Hy)[^^] m).
(* End_Tex_Verb *)
Intros.
Apply not_ap_imp_eq.
Intro.
Generalize (zexp_strong_ext ????? H0); Intro.
Apply (eq_imp_not_ap ??? H).
Assumption.
Qed.

Hints Resolve zexp_well_def : algebra_c.

(* Begin_Tex_Verb *)
Lemma zexp_plus1 : (x:R)(H:x[#]Zero)(m:Z)
                   ((x[//]H) [^^] `m+1`) [=] ((x[//]H) [^^] m) [*] x.
(* End_Tex_Verb *)
Intros.
Pattern m.
Apply nats_Z_ind.
Intro.
Replace `(inject_nat n)+1` with ((S n)::Z).
Step_lft x[^](S n).
Step_rht x[^]n [*] x.
Algebra.
Rewrite inj_S.
Reflexivity.
Intros.
Induction n.
Simpl.
Algebra.
Replace `(-(inject_nat (S n)))+1` with `-n`.
Step_lft  (One [/] x[//]H) [^] n.
Step_rht  (One [/] x[//]H) [^] (S n) [*] x.
Simpl.
Rational.
Rewrite inj_S.
Replace `(Zs (inject_nat n))` with `1+(inject_nat n)`.
Rewrite Zopp_Zplus.
Rewrite Zplus_sym.
Unfold 2 Zopp.
Rewrite Zplus_assoc.
Reflexivity.
Unfold Zs.
Apply Zplus_sym.
Qed.

Hints Resolve zexp_plus1: algebra.

(* Begin_Tex_Verb *)
Lemma zexp_resp_ap_zero : (x:R)(m:Z)(H:x[#]Zero)((x[//]H) [^^] m) [#] Zero.
(* End_Tex_Verb *)
Intros.
Pattern m.
Apply nats_Z_ind.
Intros.
Step_ap_lft x[^]n.
Apply nexp_resp_ap_zero.
Assumption.
Intro.
Step_ap_lft (One[/]x[//]H)[^]n.
Apply nexp_resp_ap_zero.
Apply div_resp_ap_zero_rev.
Algebra.
Qed.

Hints Resolve zexp_resp_ap_zero : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_min : (x:R)(H:x[#]Zero)(m:Z)(Hexp: (x[//]H) [^^] m [#] Zero)
   ((x[//]H) [^^] `-m`) [=] One[/] ((x[//]H) [^^] m) [//] Hexp.
(* End_Tex_Verb *)
Intros x H m.
Pattern m.
Apply nats_Z_ind.
Intros.
(* Here I would like to use Rewrite zexp_min_nexp', i.e. Rewriting with our
   own equality. *)
Apply eq_transitive_unfolded with (One[/](x [^] n)[//](Nexp_resp_ap_zero x n H)).
Apply zexp_min_nexp'.
Apply div_wd.
Algebra.
Algebra.

Intros.
Rewrite Zopp_Zopp.
Step_lft x[^]n.
Step_lft x[^]n [/] OneNZ.
Apply eq_div.
Step_lft x[^]n[*] ((One[/]x[//]H)[^]n).
Step_lft  (x[*](One[/]x[//]H))[^]n.
Step2 (One::R)[^]n [=] One.
Apply one_nexp.
Qed.

Hints Resolve zexp_min : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_min1 : (x:R)(H:x[#]Zero)(m:Z)
                   ((x[//]H) [^^] `m-1`) [=] ((x[//]H) [^^] m) [/] x [//] H.
(* End_Tex_Verb *)
Intros.
Replace `m-1` with `-((-m)+1)`.
(* Here I would like to use Rewriting with our own equality. *)
Step_lft One[/] ((x[//]H) [^^] `(-m)+1`) [//] (zexp_resp_ap_zero x `(-m)+1` H).
Apply eq_div.
Step_rht (x[//]H)[^^]m[*]((x[//]H)[^^](`-m`)[*]x).
Step_rht (x[//]H)[^^]m[*]((One[/] ((x[//]H)[^^]m) [//] (zexp_resp_ap_zero x m H))[*]x).
Rational.
Rewrite Zopp_Zplus.
Rewrite Zopp_Zopp.
Reflexivity.
Qed.

Hints Resolve zexp_min1 : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_plus : (x:R)(H:x[#]Zero)(m,n:Z)
              ((x[//]H) [^^] `m+n`) [=] ((x[//]H) [^^] m [*] (x[//]H) [^^]n).
(* End_Tex_Verb *)
Intros.
Pattern n.
Apply pred_succ_Z_ind.
Simpl.
Replace `m+0` with m.
Algebra.
Auto with zarith.
Intros.
Replace `m+(n0+1)` with `(m+n0)+1`.
Step_lft  (x[//]H)[^^](`m+n0`) [*] x.
Step_rht  (x[//]H)[^^]m[*]((x[//]H)[^^]n0 [*] x).
Step_rht  (x[//]H)[^^]m[*](x[//]H)[^^]n0 [*] x.
Algebra.
Auto with zarith.
Intros.
Replace `m+(n0-1)` with `(m+n0)-1`.
Step_lft  (x[//]H)[^^](`m+n0`) [/] x [//] H.
Step_rht  (x[//]H)[^^]m[*]((x[//]H)[^^]n0 [/] x[//]H).
Step_rht  ((x[//]H)[^^]m[*](x[//]H)[^^]n0) [/] x[//]H.
Algebra.
Unfold Zminus.
Auto with zarith.
Qed.

Hints Resolve zexp_plus : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_minus : (x:R)(H:x[#]Zero)(m,n:Z)(Hexp : (x[//]H) [^^] n [#] Zero)
   ((x[//]H) [^^] `m-n`) [=]
   (((x[//]H) [^^] m) [/] ((x[//]H) [^^] n) [//] Hexp).
(* End_Tex_Verb *)
Intros.
Replace `m-n` with `m+(-n)`.
Step_lft ((x[//]H) [^^] m [*] (x[//]H) [^^]`-n`).
Step_lft ((x[//]H) [^^] m [*] (One [/] ((x[//]H) [^^]`n`) [//] Hexp)).
Step_lft (((x[//]H) [^^] m [*] One) [/] ((x[//]H) [^^]`n`) [//] Hexp).
Algebra.
Reflexivity.
Qed.

Hints Resolve zexp_minus : algebra.

(* Begin_Tex_Verb *)
Lemma one_zexp : (z:Z)(OneNZ [^^] z [=] (One::R)).
(* End_Tex_Verb *)
Intro.
Pattern z.
Apply nats_Z_ind.
Intro.
(* Rewrite would be nice *)
Step_lft (One::R)[^]n.
Apply one_nexp.
Intros.
Step_lft One[/](OneNZ[^^]n)[//](zexp_resp_ap_zero One n (ring_non_triv ?)).
Step_rht (One::R)[/]OneNZ.
Apply eq_div.
Step_rht (One::R)[*]One[^]n.
Step_rht (One::R)[*]One.
Algebra.
Qed.

Hints Resolve one_zexp : algebra.

(* Begin_Tex_Verb *)
Lemma mult_zexp : (x,y:R)(z:Z)(Hx:x[#]Zero)(Hy:y[#]Zero)(Hp:x[*]y[#]Zero)
                  ((x[*]y) [//] Hp) [^^] z [=]
                  (x [//] Hx) [^^] z [*] (y [//] Hy) [^^] z.
(* End_Tex_Verb *)
Intros.
Pattern z.
Apply nats_Z_ind.
Intros.
Step_lft (x[*]y)[^]n.
Step_rht x[^]n [*] y[^]n.
Apply mult_nexp.
Intros.
Step_lft One[/] ((x[*]y)[//]Hp)[^^]n [//] (zexp_resp_ap_zero (x[*]y) n Hp).
Step_rht One[/] ((x[//]Hx)[^^]n) [//] (zexp_resp_ap_zero x n Hx) [*]
         (One[/] ((y[//]Hy)[^^]n) [//] (zexp_resp_ap_zero y n Hy)).
Step_lft One[/] ((x[*]y))[^]n [//] (Nexp_resp_ap_zero (x[*]y) n Hp).
Step_rht One[/] x[^]n [//] (Nexp_resp_ap_zero x n Hx) [*]
         (One[/] (y[^]n) [//] (Nexp_resp_ap_zero y n Hy)).
Step_Rat_rht One[/] ((x[^]n) [*] (y[^]n)) [//]
     (mult_resp_ap_zero ??? (Nexp_resp_ap_zero x n Hx) (Nexp_resp_ap_zero y n Hy)).
Apply eq_div.
Algebra.
Qed.

Hints Resolve mult_zexp : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_mult :  (x:R)(m,n:Z)(Hx:x[#]Zero)(He:(x[//]Hx)[^^]m [#] Zero)
                  (x [//] Hx) [^^] `m*n` [=]
                  ((x [//] Hx) [^^] m [//] He) [^^] n.
(* End_Tex_Verb *)
Intros.
Pattern n.
Apply pred_succ_Z_ind.
Rewrite <- Zmult_n_O.
Algebra.
Intros.
Rewrite Zmult_plus_distr_r.
Step_rht ((x[//]Hx)[^^]m[//]He)[^^]`n0` [*] (x[//]Hx)[^^]m.
Rewrite Zmult_n_1.
Step_lft (x[//]Hx)[^^]`m*n0` [*] (x[//]Hx) [^^]m.
Algebra.

Intros.
Rewrite Zmult_minus_distr_r.
Step_rht ((x[//]Hx)[^^]m[//]He)[^^]`n0` [/] (x[//]Hx)[^^]m[//]He.
Rewrite Zmult_n_1.
Step_lft (x[//]Hx)[^^]`m*n0` [/] (x[//]Hx) [^^]m[//]He.
Algebra.
Qed.

Hints Resolve zexp_mult : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_two : (x:R)(Hx:x[#]Zero)(x[//]Hx) [^^] `2` [=] x[*]x.
(* End_Tex_Verb *)
Intros.
Simpl.
Algebra.
Qed.

Hints Resolve zexp_two : algebra.

(* Begin_Tex_Verb *)
Lemma min_zexp_even : (x:R)(m:Z)(Zeven m)->(Hx:x[#]Zero)(Hneg:[--]x[#]Zero)
                  ([--]x[//]Hneg) [^^] m [=] (x[//]Hx) [^^] m.
(* End_Tex_Verb *)
Intros.
Pattern m.
Rewrite Zeven_div2.
Step_lft  (([--]x[//]Hneg)[^^]`2` [//] (zexp_resp_ap_zero ([--]x) `2` Hneg)) [^^] (Zdiv2 m).
Step_lft ((([--]x)[*]([--]x)) [//] (mult_resp_ap_zero ??? Hneg Hneg))
         [^^](Zdiv2 m).
Step_lft ((x[*]x) [//] (mult_resp_ap_zero ??? Hx Hx))
         [^^](Zdiv2 m).
Step_lft ((x[//]Hx)[^^]`2` [//] (zexp_resp_ap_zero x `2` Hx)) [^^] (Zdiv2 m).
Algebra.
Assumption.
Qed.

Hints Resolve min_zexp_even : algebra.

(* Begin_Tex_Verb *)
Lemma min_zexp_two : (x:R)(Hx:x[#]Zero)(Hneg:[--]x[#]Zero)
                     ([--]x[//]Hneg) [^^] `2` [=] (x[//]Hx) [^^] `2`.
(* End_Tex_Verb *)
Intros.
Apply min_zexp_even.
Simpl.
Auto.
Qed.

Hints Resolve min_zexp_two : algebra.

(* Begin_Tex_Verb *)
Lemma min_zexp_odd : (x:R)(m:Z)(Zodd m)->(Hx:x[#]Zero)(Hneg:[--]x[#]Zero)
                  ([--]x[//]Hneg) [^^] m [=] [--]((x[//]Hx) [^^] m).
(* End_Tex_Verb *)
Intros.
Replace m with `(m-1)+1`.
Step_lft  (([--]x[//]Hneg)[^^]`m-1`) [*] [--]x.
Step_rht [--]((x[//]Hx)[^^]`m-1`[*]x).
Step_Rat_rht ((x[//]Hx)[^^]`m-1`[*][--]x).
Apply mult_wd.
Apply min_zexp_even.
Apply Zodd_Zeven_min1.
Assumption.
Simpl.
Auto.
Algebra.
Change `m+(-1)+1=m`.
Rewrite <- Zplus_assoc.
Simpl.
Rewrite <- Zplus_n_O.
Reflexivity.
Qed.

(* Begin_Tex_Verb *)
Lemma zexp_one : (x:R)(H:x[#]Zero)(x[//]H)[^^]`1` [=] x.
(* End_Tex_Verb *)
Intros.
Simpl.
Algebra.
Qed.

Hints Resolve zexp_one : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_funny : (x,y:R)(Hx:x[#]Zero)(Hy:y[#]Zero)
                   (x[+]y) [*] (x[-]y) [=]
                   (x[//]Hx)[^^]`2` [-] (y[//]Hy)[^^]`2`.
(* End_Tex_Verb *)
Intros.
Step_rht x[*]x [-] y[*]y.
Rational.
Qed.

Hints Resolve zexp_funny : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_funny' : (x,y:R)(Hx:x[#]Zero)(Hy:y[#]Zero)
                    (x[-]y) [*] (x[+]y) [=]
                    (x[//]Hx)[^^]`2` [-] (y[//]Hy)[^^]`2`.
(* End_Tex_Verb *)
Intros.
Step_lft (x[+]y) [*] (x[-]y).
Apply zexp_funny.
Qed.

Hints Resolve zexp_funny' : algebra.

(* Begin_Tex_Verb *)
Lemma zexp_pos : (x:R)(H:x[#]Zero)(z:Z)(Zero [:<] x) ->
                 (Zero [:<] (x[//]H) [^^] z).
(* End_Tex_Verb *)
Intros.
Pattern z.
Apply nats_Z_ind.
Intros.
Step_less_rht x[^]n.
Apply nexp_resp_pos.
Assumption.
Intros.
Step_less_rht One[/] (x[^]n) [//] (Nexp_resp_ap_zero x n H).
Apply div_resp_pos.
Apply nexp_resp_pos.
Assumption.
Apply pos_one.
Qed.

End Zexp_properties.

Hints Resolve nexp_resp_ap_zero zexp_zero zexp_nexp zexp_min_nexp zexp_min_nexp'
              zexp_plus1 zexp_resp_ap_zero zexp_min zexp_min1 zexp_plus zexp_minus
              one_zexp mult_zexp zexp_mult zexp_two min_zexp_even min_zexp_two
              zexp_one zexp_funny zexp_funny' : algebra.

Hints Resolve zexp_well_def : algebra_c.

Section Root_Unique.

Variable R:COrdField.

(* Begin_Tex_Verb *)
Lemma root_unique :
  (x,y:R)(Zero [:<=] x) -> (Zero [:<=] y) -> (n:nat)(lt (0) n) ->
    (x[^]n [=] y[^]n) -> (x [=] y).
(* End_Tex_Verb *)
Intros.
Apply leEq_imp_eq.
Apply power_cancel_leEq with n; Auto.
Step_leEq_rht x[^]n.
Apply leEq_reflexive.
Apply power_cancel_leEq with n; Auto.
Step_leEq_lft x[^]n.
Apply leEq_reflexive.
Qed.

(* Begin_Tex_Verb *)
Lemma root_one :
  (x:R)(Zero [:<=] x) -> (n:nat)(lt (0) n) -> (x[^]n [=] One) -> (x [=] One).
(* End_Tex_Verb *)
Intros.
Apply root_unique with n; Auto.
Apply less_leEq. Apply pos_one.
Step_final One::R.
Qed.

End Root_Unique.


