(* $Id: matrix.v,v 1.11 2000/11/10 11:27:36 freek Exp $ *)

(* Obsolete but maintained *)

Require Export listn.

(* matrices as listn of listn *)

Transparent sym_eq.
Transparent f_equal.

Implicit Arguments On.

Section Matrices.
Variable  A: Set.
Variable  zro: A.
Variables pls,mlt: A->A->A.


(* vector inner product *)
Section InnerProduct.
Variables n: nat; v,u: (vec A n).

Definition innerprod : A := (foldrf pls zro (map2f mlt v u)).
End InnerProduct.


(* matrices as vectors of vectors *)
Section mat1.
Variables m,n : nat.

Definition mat : Set := (vec (vec A n) m).  (* converts (fin m)->(fin n)->A *)
Definition row [M:mat; i:(fin m)]: (vec A n) := (M i).
Definition col [M:mat; j:(fin n)]: (vec A m) := [i:(fin m)](M i j).

(* matrices to (listn of listn) and back again *)
Local As := [A:Set; n:nat](listn A n).
Definition Mat : Set := (As (As A n) m).
Definition Row [M:mat; i:(fin m)]: (As A n) := (nhtn (M i)).
Definition Col [M:mat; j:(fin n)]: (As A m) := (nhtn [i:(fin m)](M i j)).
Definition mat_Mat [M:mat]: Mat := (nhtn (Row M)).
Definition Mat_mat [MM:Mat]: mat := [i:(fin m)](nthn (nthn MM i)).

End mat1.

(* transpose a matrix *)
Definition transpose [m,n:nat; M:(mat m n)] : (mat n m) :=
    [j:(fin n); i:(fin m)](M i j).

Lemma transpose_spec: (m,n:nat; M:(mat m n); i:(fin m); j:(fin n))
    (M i j) = ((transpose M) j i).
Trivial.
Qed.

Lemma transpose_involut: (m,n:nat; M:(mat m n); i:(fin m); j:(fin n))
    (M i j) = (transpose (transpose M) i j).
Trivial.
Qed.

(* matrix multiplication *)
Definition mmult [m,n,p:nat; M:(mat m p); N:(mat p n)] : (mat m n) :=
    [i:(fin m); j:(fin n)](innerprod (row M i) (col N j)).

End Matrices.

(*********  Concrete examples  ***
Definition A: (Mat nat (2) (2)) :=
  (consn (consn (1) (consn (0) (niln ?)))
  (consn (consn (0) (consn (3) (niln ?))) (niln ?))).
Definition AA: (mat nat (2) (2)) := (Mat_mat A).
Definition B: (Mat nat (2) (2)) :=
  (consn (consn (3) (consn (0) (niln ?)))
  (consn (consn (2) (consn (1) (niln ?))) (niln ?))).
Definition BB: (mat nat (2) (2)) := (Mat_mat B).

Definition AABB: (mat nat (2) (2)) := (mmult (0) plus mult AA BB).
Definition BBAA: (mat nat (2) (2)) := (mmult (0) plus mult BB AA).

Definition AB: (Mat nat (2) (2)) := (mat_Mat AABB).
Eval Compute in AB.
Definition BA: (Mat nat (2) (2)) := (mat_Mat BBAA).
Eval Compute in BA.

Definition C: (Mat nat (2) (3)) :=
  (consn (consn (1) (consn (2) (consn (3) (niln ?))))
  (consn (consn (4) (consn (5) (consn (6) (niln ?)))) (niln ?))).
Definition CC: (mat nat (2) (3)) := (Mat_mat C).
Definition D: (Mat nat (3) (4)) :=
  (consn (consn (1) (consn (2) (consn (3) (consn (4) (niln ?)))))
  (consn (consn (1) (consn (2) (consn (3) (consn (4) (niln ?)))))
  (consn (consn (1) (consn (2) (consn (3) (consn (4) (niln ?))))) (niln ?)))).
Definition DD: (mat nat (3) (4)) := (Mat_mat D).

Definition CD: (Mat nat (2) (4)) := (mat_Mat (mmult (0) plus mult CC DD)).
Eval Compute in CD.
************)


