(* $Id: CMonoids.v,v 1.9 2000/10/13 12:32:09 freek Exp $ *)

Require Export CSemiGroups.

(* Begin_SpecReals *)

(* Tex_Prose
\section{Monoids}\label{section:monoids}
We deal only with commutative algebraic structures.
*)

(* Tex_Prose
\subsection{Definition of monoids}
*)

(* Begin_Tex_Verb *)
Definition is_rht_unit
 [S: CSetoid; op: (CSetoid_bin_op S); one: S] : Prop :=
    (x: S)((op x one) [=] x).
(* End_Tex_Verb *)

(* End_SpecReals *)

Syntactic Definition Is_rht_unit := (is_rht_unit ?).

(* Begin_Tex_Verb *)
Definition is_lft_unit
 [S: CSetoid; op: (CSetoid_bin_op S); one: S] : Prop :=
    (x: S)((op one x) [=] x).
(* End_Tex_Verb *)
Syntactic Definition Is_lft_unit := (is_lft_unit ?).

(* Begin_SpecReals *)

(* Begin_Tex_Verb *)
Record is_CMonoid [G: CSemi_grp]: Prop :=
  { runit : (is_rht_unit G Csg_op Zero);
    commut: (commutes G Csg_op)
  }.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Record CMonoid : Type :=
  { cm_crr   :> CSemi_grp;
    cm_proof :  (is_CMonoid cm_crr)
  }.
(* End_Tex_Verb *)
(* End_SpecReals *)

(* Tex_Prose
\subsection{Monoid axioms}
\begin{convention}
Let \verb!M! be a monoid.
\end{convention}
*)
Section CMonoid_axioms.
Variable M : CMonoid.

(* Begin_Tex_Verb *)
Lemma CMonoid_is_CMonoid : (is_CMonoid M).
(* End_Tex_Verb *)
Elim M.
Intros.
Exact cm_proof0.
Qed.

(* Begin_Tex_Verb *)
Lemma cm_rht_unit: (Is_rht_unit Csg_op Zero::M).
(* End_Tex_Verb *)
Elim CMonoid_is_CMonoid.
Intros.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma cm_commutes: (Commutes (csg_op M)).
(* End_Tex_Verb *)
Elim CMonoid_is_CMonoid.
Intros.
Assumption.
Qed.

End CMonoid_axioms.

(* Tex_Prose
\subsection{Monoid basics}
\begin{convention}
Let \verb!G! be a monoid.
\end{convention}
*)
Section CMonoid_basics.
Variable M : CMonoid.

(* Begin_Tex_Verb *)
Lemma cm_commutes_unfolded: (x, y: M)((x [+] y) [=] (y [+] x)).
(* End_Tex_Verb *)
Proof (cm_commutes M).
Hints Resolve cm_commutes_unfolded : algebra.

(* Begin_Tex_Verb *)
Lemma cm_rht_unit_unfolded : (x:M)((x [+] Zero) [=] x).
(* End_Tex_Verb *)
Intro.
Apply (cm_rht_unit M).
Qed.

(* Begin_Tex_Verb *)
Lemma lftUnit_iff_rhtUnit:
  (x:M)(Is_lft_unit Csg_op x) <-> (Is_rht_unit Csg_op x).
(* End_Tex_Verb *)
Proof.
Intros; Split; Red; Intros.
Step_final (x [+] x0).
Step_final (x0 [+] x).
Qed.

(* Begin_Tex_Verb *)
Lemma cm_lft_unit: (Is_lft_unit Csg_op Zero::M).
(* End_Tex_Verb *)
Generalize (lftUnit_iff_rhtUnit Zero); Intro.
Elim H; Intros.
Apply H1.
Apply cm_rht_unit.
Qed.

(* Begin_Tex_Verb *)
Lemma cm_lft_unit_unfolded: (x:M)((Zero [+] x) [=] x).
(* End_Tex_Verb *)
  Proof cm_lft_unit.

Hints Resolve cm_rht_unit_unfolded cm_lft_unit_unfolded : algebra.

(* Begin_Tex_Verb *)
Lemma cm_unit_unique_lft:
    (x:M)(Is_lft_unit Csg_op x)->(x [=] Zero).
(* End_Tex_Verb *)
Intros x h. Red in h.
Step_final (x [+] Zero).
Qed.

(* Begin_Tex_Verb *)
Lemma cm_unit_unique_rht:
    (x:M)(Is_rht_unit Csg_op x)->(x [=] Zero).
(* End_Tex_Verb *)
Intros x h. Red in h.
Step_final (Zero [+] x).
Qed.

(* Begin_SpecReals *)

(* Tex_Prose
TO DO: Say something about the reason for the following lemma.
*)
(* Begin_Tex_Verb *)
Lemma is_CMonoid_proof_irr :
  (S:CSetoid)(one:S)(mult:(CSetoid_bin_op S))(p,q:(Associative mult))
                 (is_CMonoid (Build_CSemi_grp S one mult p)) ->
                 (is_CMonoid (Build_CSemi_grp S one mult q)).
(* End_Tex_Verb *)
Intros.
Elim H; Intros.
Simpl in runit0.
Simpl in commut0.
Apply Build_is_CMonoid; Simpl; Assumption.
Qed.

(* End_SpecReals *)

(* Tex_Prose
\subsection{Submonoids}
\begin{convention}
Let \verb!P! a predicate on \verb!M! with
\verb!P Zero! and which is preserved by \verb![+]!.
\end{convention}
*)

Section SubCMonoids.
Variable P         : M -> Prop.
Variable Punit     : (P Zero).
Variable op_pres_P : (bin_op_pres_pred ? P Csg_op).

(* Begin_Tex_Verb *)
Local subcrr : CSemi_grp := (Build_SubCSemi_grp ?? Punit op_pres_P).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma ismon_scrr: (is_CMonoid subcrr).
(* End_Tex_Verb *)
Split; Red.
(* unit *)
Intro x. Case x. Intros.
Apply (cm_rht_unit_unfolded scs_elem).
(* commutes *)
Intros x y. Case y. Case x. Intros.
Exact (cm_commutes_unfolded scs_elem scs_elem0).
Qed.

(* Begin_Tex_Verb *)
Definition Build_SubCMonoid : CMonoid := (Build_CMonoid subcrr ismon_scrr).
(* End_Tex_Verb *)

End SubCMonoids.


End CMonoid_basics.

Hints Resolve cm_rht_unit_unfolded cm_lft_unit_unfolded : algebra.
Hints Resolve cm_commutes_unfolded : algebra.


