(* $Id: CPoly_Contin.v,v 1.4 2000/11/06 09:52:56 freek Exp $ *)

Require Export RealFuncts.
Require Export CPolynomials.

Section Mult_Op_Continuous.

Variable f,g,h : (CSetoid_un_op IR).
Hypothesis f_contin : (contin f).
Hypothesis g_contin : (contin g).
Hypothesis f_g_h : (x:IR)((f x)[*](g x) [=] (h x)).

Lemma mult_op_contin : (contin h).
Unfold contin in f_contin.
Unfold continAt in f_contin.
Unfold funLim in f_contin.
Unfold contin in g_contin.
Unfold continAt in g_contin.
Unfold funLim in g_contin.
Unfold contin. Unfold continAt. Unfold funLim.
Intros.
Elim (mult_contin ? (f x) (g x) e H). Intro b. Intros.
Elim H0. Clear H0. Intros.
Elim H1. Clear H1. Intro c. Intros.
Elim H1. Clear H1. Intros.
Elim (f_contin x b H0). Clear f_contin. Intro d'. Intros.
Elim H3. Clear H3. Intros.
Elim (g_contin x c H1). Clear g_contin. Intro d''. Intros.
Elim H5. Clear H5. Intros.
Elim (smaller ? d' d'' H3 H5). Intro d. Intros. Exists d.
Elim H7. Clear H7. Intros. Elim H8. Clear H8. Intros.
Split. Auto. Intro x'. Intros.
Apply AbsSmall_wd_rht_unfolded with (f x)[*](g x)[-](f x')[*](g x').
Apply H2.
Apply H4. Apply AbsSmall_trans with d; Auto.
Apply H6. Apply AbsSmall_trans with d; Auto.
Algebra.
Qed.

End Mult_Op_Continuous.


Section Plus_Op_Continuous.

Lemma plus_contin :
  (R:COrdField)(x,y,e:R)(Zero [:<] e) ->
    (EX c | (Zero [:<] c) /\ (EX d | (Zero [:<] d) /\
      (x',y':R)(AbsSmall c x[-]x') -> (AbsSmall d y[-]y') ->
        (AbsSmall e (x[+]y)[-](x'[+]y')))).
Intros.
Cut Zero [:<] e[/]TwoNZ. Intro.
Exists e[/]TwoNZ. Split. Auto.
Exists e[/]TwoNZ. Split. Auto.
Intros.
Apply AbsSmall_wd_rht_unfolded with (x[-]x')[+](y[-]y').
Apply AbsSmall_eps_div_two; Auto.
Rational.
Apply div_resp_pos. Apply pos_two. Auto.
Qed.

Variable f,g,h : (CSetoid_un_op IR).
Hypothesis f_contin : (contin f).
Hypothesis g_contin : (contin g).
Hypothesis f_g_h : (x:IR)((f x)[+](g x) [=] (h x)).

Lemma plus_op_contin : (contin h).
Unfold contin in f_contin.
Unfold continAt in f_contin.
Unfold funLim in f_contin.
Unfold contin in g_contin.
Unfold continAt in g_contin.
Unfold funLim in g_contin.
Unfold contin. Unfold continAt. Unfold funLim.
Intros.
Elim (plus_contin ? (f x) (g x) e H). Intro b. Intros.
Elim H0. Clear H0. Intros.
Elim H1. Clear H1. Intro c. Intros.
Elim H1. Clear H1. Intros.
Elim (f_contin x b H0). Clear f_contin. Intro d'. Intros.
Elim H3. Clear H3. Intros.
Elim (g_contin x c H1). Clear g_contin. Intro d''. Intros.
Elim H5. Clear H5. Intros.
Elim (smaller ? d' d'' H3 H5). Intro d. Intros. Exists d.
Elim H7. Clear H7. Intros. Elim H8. Clear H8. Intros.
Split. Auto. Intro x'. Intros.
Apply AbsSmall_wd_rht_unfolded with ((f x)[+](g x))[-]((f x')[+](g x')).
Apply H2.
Apply H4. Apply AbsSmall_trans with d; Auto.
Apply H6. Apply AbsSmall_trans with d; Auto.
Algebra.
Qed.

End Plus_Op_Continuous.


Section Linear_Op_Continuous.

Variable f,g : (CSetoid_un_op IR).
Variable a : IR.
Hypothesis f_contin : (contin f).
Hypothesis f_g_c : (x:IR)(x[*](f x)[+]a [=] (g x)).

Lemma linear_op_contin : (contin g).
Unfold contin in f_contin.
Unfold continAt in f_contin.
Unfold funLim in f_contin.
Unfold contin. Unfold continAt. Unfold funLim.
Intros.
Elim (mult_contin ? x (f x) e). Intro d'. Intros.
Elim H0. Clear H0. Intros.
Elim H1. Clear H1. Intro c. Intros.
Elim H1. Clear H1. Intros.
Elim (f_contin x c). Clear f_contin. Intro d''. Intros.
Elim H3. Clear H3. Intros.
Elim (smaller ? d' d'').
Intro d.
Intros.
Elim H5. Clear H5. Intros.
Elim H6. Clear H6. Intros.
Exists d. Split. Auto. Intro x'. Intros.
Apply AbsSmall_wd_rht_unfolded with (x[*](f x)[+]a)[-](x'[*](f x')[+]a).
Apply AbsSmall_wd_rht_unfolded with x[*](f x)[-]x'[*](f x').
Apply H2. Clear H2.
Apply AbsSmall_trans with d; Auto.
Apply H4. Clear H4.
Apply AbsSmall_trans with d; Auto.
Rational.
Algebra.
Auto. Auto. Auto. Auto.
Qed.

End Linear_Op_Continuous.


Section CPoly_Op_Continuous.

Variable g : (cpoly IR).

Lemma cpoly_op_contin : (contin (cpoly_csetoid_op ? g)).
Elim g.
Unfold contin. Unfold continAt. Unfold funLim.
Intros.
Exists One::IR. Split. Apply pos_one.
Intros.
Simpl.
Unfold absSmall.
Split.
Step_Rat_less_rht [--]Zero::IR. Apply min_resp_less. Auto.
Step_less_lft Zero::IR. Auto.
Intros a f. Intros.
Apply linear_op_contin with (cpoly_csetoid_op ? f) a. Auto.
Intros. Simpl. Rational.
Qed.

End CPoly_Op_Continuous.


