(* $Id: Convert_CReals.v,v 1.12 2000/11/10 11:27:31 freek Exp $ *)

Require Export Spec_CReals45.
Require Export CReals1.

Section Convert_CReals.

Variable R45 : CReals45.

Definition R_              := (_R R45).
Definition is_             := (_is R45).
Definition ap_             := (_ap R45).
Definition ap_irr_         := (_ap_irr R45).
Definition ap_sym_         := (_ap_sym R45).
Definition ap_cot_         := (_ap_cot R45).
Definition ap_tight_       := (_ap_tight R45).
Definition zero_           := (_zero R45).
Definition add_            := (_add R45).
Definition add_wd_         := (_add_wd R45).
Definition add_strext_     := (_add_strext R45).
Definition add_assoc_      := (_add_assoc R45).
Definition add_runit_      := (_add_runit R45).
Definition add_commut_     := (_add_commut R45).
Definition minus_          := (_minus R45).
Definition minus_wd_       := (_minus_wd R45).
Definition minus_strext_   := (_minus_strext R45).
Definition minus_proof_    := (_minus_proof R45).
Definition one_            := (_one R45).
Definition times_          := (_times R45).
Definition times_wd_       := (_times_wd R45).
Definition times_strext_   := (_times_strext R45).
Definition times_assoc_    := (_times_assoc R45).
Definition times_runit_    := (_times_runit R45).
Definition times_commut_   := (_times_commut R45).
Definition dist_           := (_dist R45).
Definition non_triv_       := (_non_triv R45).
Definition rcpcl_          := (_rcpcl R45).
Definition rcpcl_ap_zero_  := (_rcpcl_ap_zero R45).
Definition rcpcl_wd_       := (_rcpcl_wd R45).
Definition rcpcl_strext_   := (_rcpcl_strext R45).
Definition rcpcl_proof_    := (_rcpcl_proof R45).
Definition less_           := (_less R45).
Definition less_wdr_       := (_less_wdr R45).
Definition less_wdl_       := (_less_wdl R45).
Definition less_strext_    := (_less_strext R45).
Definition less_trans_     := (_less_trans R45).
Definition less_irr_       := (_less_irr R45).
Definition less_asym_      := (_less_asym R45).
Definition add_resp_less_  := (_add_resp_less R45).
Definition times_resp_pos_ := (_times_resp_pos R45).
Definition less_conf_ap_   := (_less_conf_ap R45).
Definition lim_            := (_lim R45).
Definition lim_proof_      := (_lim_proof R45).
Definition arch_proof_     := (_arch_proof R45).

Definition is_CSetoid_R45 :=
  (Build_is_CSetoid R_ is_ ap_  ap_irr_ ap_sym_ ap_cot_ ap_tight_).
Definition CSetoid_R45 :=
  (!Build_CSetoid R_ is_ ap_ is_CSetoid_R45).
Definition CSetoid_bin_fun_R45 :=
  (Build_CSetoid_bin_fun CSetoid_R45 CSetoid_R45 CSetoid_R45
    add_ add_wd_ add_strext_).
Definition CSemi_grp_R45 :=
  (Build_CSemi_grp CSetoid_R45 zero_ CSetoid_bin_fun_R45 add_assoc_).
Definition is_CMonoid_R45 :=
  (Build_is_CMonoid CSemi_grp_R45  add_runit_ add_commut_).
Definition CMonoid_R45 :=
  (Build_CMonoid CSemi_grp_R45 is_CMonoid_R45).
Definition CSetoid_un_fun_R45 :=
  (Build_CSetoid_fun CSetoid_R45 CSetoid_R45  minus_ minus_wd_ minus_strext_).
Definition CGroup_R45 :=
  (Build_CGroup CMonoid_R45 CSetoid_un_fun_R45 minus_proof_).
Definition CSetoid_bin_fun_2_R45 :=
  (Build_CSetoid_bin_fun CSetoid_R45 CSetoid_R45 CSetoid_R45
    times_ times_wd_ times_strext_).
Definition CSemi_grp_2_R45 :=
  (Build_CSemi_grp CSetoid_R45 one_ CSetoid_bin_fun_2_R45 times_assoc_).
Definition is_CMonoid_2_R45 :=
  (Build_is_CMonoid CSemi_grp_2_R45 times_runit_ times_commut_).
Lemma is_CRing_R45 : (is_CRing CGroup_R45 one_ CSetoid_bin_fun_2_R45).
Apply Build_is_CRing with times_assoc_.
Exact is_CMonoid_2_R45.
Exact dist_.
Exact non_triv_.
Qed.
Definition CRing_R45 :=
  (Build_CRing CGroup_R45 one_ CSetoid_bin_fun_2_R45 is_CRing_R45).
Definition nonZeroP_ :=
  (nonZeroP CRing_R45).
Definition R' :=
  (subcsetoid_crr CSetoid_R45 nonZeroP_).
Definition is' :=
  (subcsetoid_eq CSetoid_R45 nonZeroP_).
Definition ap' :=
  (subcsetoid_ap CSetoid_R45 nonZeroP_).

Lemma is'_ : (x,y:R')(is' x y)->(is_ (scs_elem ?? x) (scs_elem ?? y)).
Intros x y.
Elim x. Elim y.
Unfold is'. Unfold subcsetoid_eq. Unfold restrict_relation.
Auto.
Qed.

Lemma ap_' : (x,y:R')(ap_ (scs_elem ?? x) (scs_elem ?? y))->(ap' x y).
Intros x y.
Elim x. Elim y.
Unfold ap'. Unfold subcsetoid_ap. Unfold restrict_relation.
Auto.
Qed.

Definition CSetoid_2_R45 :=
  (NonZeros CRing_R45).
Definition rcpcl' : R'->R' :=
  [x:R'](Build_subcsetoid_crr CSetoid_R45 nonZeroP_
    (rcpcl_ (scs_elem ?? x) (scs_prf ?? x))
    (rcpcl_ap_zero_ (scs_elem ?? x) (scs_prf ?? x))).
Definition rcpcl_wd' : (x,y:R')(is' x y)->(is' (rcpcl' x) (rcpcl' y)) :=
  [x,y:R'][z:(is' x y)](rcpcl_wd_ (scs_elem ?? x) (scs_prf ?? x)
    (scs_elem ?? y) (scs_prf ?? y) (is'_ x y z)).
Definition rcpcl_strext' : (x,y:R')(ap' (rcpcl' x) (rcpcl' y))->(ap' x y) :=
  [x,y:R'][z:(ap' (rcpcl' x) (rcpcl' y))]
    (ap_' x y (rcpcl_strext_ (scs_elem ?? x) (scs_prf ?? x)
      (scs_elem ?? y) (scs_prf ?? y) z)).

Lemma rcpcl_proof' :
    (x:R')(is_ (times_ (scs_elem ?? x) (scs_elem ?? (rcpcl' x))) one_).
Intros.
Elim x. Intros.
Unfold rcpcl'.
Cut (is_ (times_ scs_elem (rcpcl_ scs_elem scs_prf)) one_). Intro. Auto.
Apply rcpcl_proof_.
Qed.

Definition CSetoid_un_fun_2_R45 :=
  (Build_CSetoid_fun CSetoid_2_R45 CSetoid_2_R45
    rcpcl' rcpcl_wd' rcpcl_strext').
Definition CField_R45 :=
  (Build_CField CRing_R45 CSetoid_un_fun_2_R45 rcpcl_proof').
Definition CSetoid_relation_R45 :=
  (Build_CSetoid_relation CSetoid_R45  less_ less_wdr_ less_wdl_ less_strext_).
Definition strictorder_R45 :=
  (Build_strictorder less_trans_ less_asym_).
Definition is_COrdField_R45 :=
  (Build_is_COrdField CField_R45 CSetoid_relation_R45
    strictorder_R45 add_resp_less_ times_resp_pos_ less_conf_ap_).
Definition COrdField_R45 :=
  (Build_COrdField CField_R45 CSetoid_relation_R45 is_COrdField_R45).
Definition CauchySeq_ :=
  (CauchySeq COrdField_R45).

Lemma is_refl_ : (x:R_)(is_ x x).
Proof [x:?]
  (and_ind ??? [H1:~(ap_ x x)->(is_ x x)][_:?]
    (H1 (ap_irr_ x))
  (ap_tight_ x x)).

Lemma is_sym_ : (x,y:R_)(is_ x y)->(is_ y x).
Proof [x,y:?][H:?]
  (and_ind ??? [H0:~(ap_ y x)->(is_ y x)][_:?]
    (and_ind ??? [_:?][H1:(is_ x y)->~(ap_ x y)]
      (H0 [H2:?](H1 H (ap_sym_ y x H2)))
    (ap_tight_ x y)) (ap_tight_ y x)).

Lemma is_trans_ : (x,y,z:R_)(is_ x y)->(is_ y z)->(is_ x z).
Proof [x,y,z:?][H:?][H0:?]
  (and_ind ??? [H1:~(ap_ x z)->(is_ x z)][_:?]
    (and_ind ??? [_:?][H2:(is_ y z)->~(ap_ y z)]
      (and_ind ??? [_:?][H3:(is_ x y)->~(ap_ x y)]
        (H1 [H4:?](or_ind ??? [H5:?](H3 H H5) [H5:?](H2 H0 H5)
          (ap_cot_ ?? H4 y)))
        (ap_tight_ x y)) (ap_tight_ y z)) (ap_tight_ x z)).

Lemma CauchySeq_aux_0 : (x,y,e:R_)
  (less_ (minus_ e) (add_ y (minus_ x)))->(less_ x (add_ y e)).
Intros.
Apply less_wdl_ with (add_ (add_ (minus_ e) x) e).
Apply add_resp_less_.
Apply less_wdr_ with (add_ (add_ y (minus_ x)) x).
Apply add_resp_less_.
Assumption.
Apply is_trans_ with (add_ y (add_ (minus_ x) x)).
Apply is_sym_.
Apply add_assoc_.
Apply is_trans_ with (add_ y zero_).
Apply add_wd_.
Apply is_refl_.
Apply is_trans_ with (add_ x (minus_ x)).
Apply add_commut_.
Apply minus_proof_.
Apply add_runit_.
Apply is_trans_ with (add_ (minus_ e) (add_ x e)).
Apply is_sym_.
Apply add_assoc_.
Apply is_trans_ with (add_ (add_ x e) (minus_ e)).
Apply add_commut_.
Apply is_trans_ with (add_ x (add_ e (minus_ e))).
Apply is_sym_.
Apply add_assoc_.
Apply is_trans_ with (add_ x zero_).
Apply add_wd_.
Apply is_refl_.
Apply minus_proof_.
Apply add_runit_.
Qed.

Lemma CauchySeq_aux_1 : (x,y,e:R_)
  (less_ (add_ x (minus_ y)) e)->(less_ x (add_ y e)).
Intros.
Apply less_wdl_ with (add_ (add_ x (minus_ y)) y).
Apply less_wdr_ with (add_ e y).
Apply add_resp_less_.
Assumption.
Apply add_commut_.
Apply is_trans_ with (add_ y (add_ x (minus_ y))).
Apply add_commut_.
Apply is_trans_ with (add_ y (add_ (minus_ y) x)).
Apply add_wd_.
Apply is_refl_.
Apply add_commut_.
Apply is_trans_ with (add_ (add_ y (minus_ y)) x).
Apply add_assoc_.
Apply is_trans_ with (add_ zero_ x).
Apply add_wd_.
Apply minus_proof_.
Apply is_refl_.
Apply is_trans_ with (add_ x zero_).
Apply add_commut_.
Apply add_runit_.
Qed.

Lemma CauchySeq_aux_2 : (x,y,e:R_)
  (less_ x (add_ y e))->(less_ (minus_ e) (add_ y (minus_ x))).
Intros.
Apply less_wdl_ with (add_ (add_ (minus_ e) x) (minus_ x)).
Apply add_resp_less_.
Apply less_wdl_ with (add_ x (minus_ e)).
Apply less_wdr_ with (add_ (add_ y e) (minus_ e)).
Apply add_resp_less_.
Assumption.
Apply is_trans_ with (add_ y (add_ e (minus_ e))).
Apply is_sym_.
Apply add_assoc_.
Apply is_trans_ with (add_ y zero_).
Apply add_wd_.
Apply is_refl_.
Apply minus_proof_.
Apply add_runit_.
Apply add_commut_.
Apply is_trans_ with (add_ (minus_ e) (add_ x (minus_ x))).
Apply is_sym_.
Apply add_assoc_.
Apply is_trans_ with (add_ (minus_ e) zero_).
Apply add_wd_.
Apply is_refl_.
Apply minus_proof_.
Apply add_runit_.
Qed.

Lemma CauchySeq_aux_3 : (x,y,e:R_)
  (less_ x (add_ y e))->(less_ (add_ x (minus_ y)) e).
Intros.
Apply less_wdr_ with (add_ (add_ y e) (minus_ y)).
Apply add_resp_less_.
Assumption.
Apply is_trans_ with (add_ (add_ e y) (minus_ y)).
Apply add_wd_.
Apply add_commut_.
Apply is_refl_.
Apply is_trans_ with (add_ e (add_ y (minus_ y))).
Apply is_sym_.
Apply add_assoc_.
Apply is_trans_ with (add_ e zero_).
Apply add_wd_.
Apply is_refl_.
Apply minus_proof_.
Apply add_runit_.
Qed.

Lemma CauchySeq_aux_01 : (x,y,e:R_)
  ((less_ (minus_ e) (add_ x (minus_ y)))/\(less_ (add_ x (minus_ y)) e))->
  (less_ x (add_ y e))/\(less_ y (add_ x e)).
Intros.
Elim H. Intros.
Split.
Apply CauchySeq_aux_1. Exact H1.
Apply CauchySeq_aux_0. Exact H0.
Qed.

Lemma CauchySeq_aux_23 : (x,y,e:R_)
  (less_ x (add_ y e))/\(less_ y (add_ x e))->
  ((less_ (minus_ e) (add_ x (minus_ y)))/\(less_ (add_ x (minus_ y)) e)).
Intros.
Elim H. Intros.
Split.
Apply CauchySeq_aux_2. Exact H1.
Apply CauchySeq_aux_3. Exact H0.
Qed.

Lemma CauchySeq_cauchy : (g:nat->R_)
    (!Cauchy_prop COrdField_R45 g)->(cauchy R_ zero_ add_ less_ g).
Unfold Cauchy_prop. Unfold absSmall. Unfold cauchy.
Intros.
Elim (H e H0). Intros.
Exists x. Intros.
Apply CauchySeq_aux_01.
Apply (H1 m H2).
Qed.

Definition lim' : CauchySeq_->R_ :=
  [g:CauchySeq_](lim_ (CS_seq COrdField_R45 g)
                      (CauchySeq_cauchy g (CS_proof COrdField_R45 g))).

Lemma lim_proof' : (g:CauchySeq_)(e:R_)(less_ zero_ e)->
  (Ex [N:nat](m:nat)(le N m)->
     (less_ (minus_ e) (add_ (g m) (minus_ (lim' g))))
       /\(less_ (add_ (g m) (minus_ (lim' g))) e)).
Intros.
Elim g. Intros.
Elim (lim_proof_ CS_seq (CauchySeq_cauchy CS_seq CS_proof) e H). Intros.
Exists x. Intros.
Apply CauchySeq_aux_23.
Apply (H0 m H1).
Qed.

Lemma arch_proof' : (x:R_)(Ex [n:nat](less_ x (nring CRing_R45 n))).
Intros.
Cut (Ex [n:nat](less_ x (nreal R_ zero_ one_ add_ n))). Intros.
Elim H. Intros.
Exists x0.
Replace (nring CRing_R45 x0) with (nreal R_ zero_ one_ add_ x0). Assumption.
Generalize x0.
Induction x1.
Auto.
Intros. Simpl.
Rewrite H1. Auto.
Apply arch_proof_.
Qed.

Lemma is_CReals_R45 : (is_CReals COrdField_R45 lim').
Apply Build_is_CReals.
Exact lim_proof'.
Exact arch_proof'.
Qed.

Definition CReals_R45 :=
  (!Build_CReals COrdField_R45 lim' is_CReals_R45).

End Convert_CReals.


