(* $Id: KneserLemma.v,v 1.17 2000/11/10 11:27:33 freek Exp $ *)

Require Export NRootCC.
Require Export Triangle.
Require Export MainLemma.

(* Tex_Prose
\section{Kneser Lemma}
*)

Section Kneser_Lemma.

(* Tex_Prose
\begin{convention}
Let \verb!b : nat->CC!, \verb!n : nat!, \verb!(lt (0) n)!,
\verb!(b n) [=] One!, \verb!c : IR!, \verb!(AbsCC b_0) [:<] c!.
\end{convention}
*)
Variable b : nat->CC.
Variable n : nat.
Hypothesis gt_n_0 : (lt (0) n).
(* Begin_Tex_Verb *)
Local b_0 := (b O).
Local b_n := (b n).
(* End_Tex_Verb *)
Hypothesis b_n_1 : b_n [=] One.
Variable c : IR.
Hypothesis b_0_lt_c : (AbsCC b_0) [:<] c.

(* Begin_Tex_Verb *)
Local two_n := (mult (2) n).
Local Small := (p3m n).
Local Smaller := (p3m (mult two_n n)).
Local Smallest := Small[*]Smaller.
Local q := One[-]Smallest.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma b_0'_exists :
(eta:IR)(Zero [:<] eta) ->
        (EX b_0' | ((AbsCC (b_0'[-]b_0)) [:<] eta) /\ (b_0' [#] Zero)).
(* End_Tex_Verb *)
Intros.
Elim (exis_AFS_CC Zero b_0 eta H). Intro b_0'.
Unfold AbsSmallCC.
Intros.
Elim H0. Intros.
Exists b_0'.
Split; Auto.
Qed.

(* Begin_Tex_Verb *)
Local eta_0 := (c[-](AbsCC b_0))[/]FourNZ.
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma eta_0_pos : (Zero[:<] eta_0).
(* End_Tex_Verb *)
Proof.
Unfold eta_0.
Apply div_resp_pos.
Exact (pos_four ?).
Apply shift_zero_less_minus.
Assumption.
Qed.

(* Begin_Tex_Verb *)
Lemma eta_exists :
        (EX eta | (Zero [:<] eta) /\
          (EX b_0' |
            ((AbsCC (b_0'[-]b_0)) [:<] eta) /\
            (b_0' [#] Zero) /\
            ((AbsCC b_0')[+]Three[*]eta [:<] c))).
(* End_Tex_Verb *)
Proof.
Exists eta_0.
Split.
Exact eta_0_pos.
Generalize (b_0'_exists eta_0 eta_0_pos).
Intro H.
Elim H.
Intros b_0' Hb.
Exists b_0'.
Elim Hb.
Intros.
Split.
Assumption.
Split.
Assumption.
Apply shift_plus_less.
Apply less_wdl with (AbsCC(b_0' [-] b_0 [+] b_0)).
Apply leEq_less_trans with (AbsCC b_0'[-]b_0)[+](AbsCC b_0).
Apply triangle.
Apply less_leEq_trans with eta_0[+](AbsCC b_0).
Apply plus_resp_less_rht.
Assumption.
Apply (eq_imp_leEq IR).
Unfold eta_0.
Rational.
Apply AbsCC_wd.
Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma eps_exists_1 :
  (eps,x,y:IR)(Zero [:<] eps) -> (Zero [:<] x) -> (Zero [:<] y) ->
    (EX eps' | (Zero [:<] eps') /\ (eps' [:<] eps) /\ (x[*]eps' [:<] y)).
(* End_Tex_Verb *)
Intros.
Cut Zero [:<] Half[*]eps. Intro.
Cut x [#] Zero. Intro.
Cut (Zero [:<] y[/]x[//]H3[-]Half[*]eps) \/
  (y[/]x[//]H3[-]Half[*]eps [:<] Half[*]eps). Intro. Elim H4; Intros.
Exists Half[*]eps.
Split.
Auto.
Split.
Apply half_3. Auto.
Step_less_rht x[*](y[/]x[//]H3).
Apply mult_resp_less_lft.
Step_less_lft Zero[+]Half[*]eps.
Apply shift_plus_less.
Auto.
Auto.
Cut Zero [:<] y[/]x[//]H3. Intro.
Exists Half[*](y[/]x[//]H3).
Split.
Apply mult_resp_pos.
Apply pos_half.
Auto.
Split.
Apply less_transitive_unfolded with y[/]x[//]H3.
Apply half_3.
Auto.
Step_less_rht One[*]eps.
Step_less_rht (Half[+]Half)[*]eps.
Step_less_rht Half[*]eps[+]Half[*]eps.
Apply shift_less_plus'.
Auto.
Step_Rat_less_lft Half[*]y.
Apply half_3.
Auto.
Apply div_resp_pos; Auto.
Apply cotrans_less_unfolded.
Auto.
Apply pos_ap_zero. Auto.
Apply mult_resp_pos.
Apply pos_half.
Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma eps_exists_2 :
  (x1,y1,x2,y2,z:IR)
    (Zero [:<] x1) -> (Zero [:<] y1) ->
    (Zero [:<] x2) -> (Zero [:<] y2) ->
    (Zero [:<] z) ->
      (EX eps | (Zero [:<] eps) /\
        (x1[*]eps [:<] y1) /\ (x2[*]eps [:<] y2) /\ (eps [:<] z)).
(* End_Tex_Verb *)
Intros.
Cut Zero [:<] Half[*]z. Intro.
Elim (eps_exists_1 Half[*]z x1 y1 H4 H H0). Intro eps'. Intros.
Elim H5. Intros. Elim H7. Intros.
Elim (eps_exists_1 eps' x2 y2 H6 H1 H2). Intro eps. Intros.
Elim H10. Intros. Elim H12. Intros.
Exists eps.
Split. Auto.
Split.
Apply less_transitive_unfolded with x1[*]eps'.
Apply mult_resp_less_lft.
Auto.
Auto.
Auto.
Split.
Auto.
Apply less_transitive_unfolded with eps'.
Auto.
Apply less_transitive_unfolded with Half[*]z.
Auto.
Apply half_3.
Auto.
Apply mult_resp_pos.
Apply pos_half.
Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma eps_exists :
(eta,a_0:IR)(Zero [:<] eta) -> (Zero [:<] a_0) ->
        (EX eps | (Zero [:<] eps) /\
          (Two[*](Three[^]n[+]One)[*]eps [:<] eta) /\
          (Two[*]eps [:<] Smaller[*]a_0) /\
          (eps [:<] a_0)).
(* End_Tex_Verb *)
Intros.
Apply eps_exists_2.
Apply mult_resp_pos.
Apply pos_two.
Apply plus_resp_pos.
Apply nexp_resp_pos.
Apply pos_three.
Apply pos_one.
Auto.
Apply pos_two.
Apply mult_resp_pos.
Unfold Smaller.
Apply p3m_pos.
Auto.
Auto.
Qed.

(* Begin_Tex_Verb *)
Local a : nat->IR := [i:nat](AbsCC (b i)).
(* End_Tex_Verb *)

(* Begin_Tex_Verb *)
Lemma z_exists :
(b_0':CC; k:nat; r,eta:IR)
  let a_0 = (AbsCC b_0') in
        (Zero [:<] a_0) -> (Zero [:<] (a k)) ->
        (le (1) k) -> (le k n) ->
        (Zero [:<] r) -> (Zero [:<] eta) ->
        ((AbsCC (b_0'[-]b_0)) [:<] eta) ->
        ((a k)[*]r[^]k [:<] a_0) ->
          (EX z |
            ((AbsCC z) [=] r) /\
            ((AbsCC (b_0[+](b k)[*]z[^]k)) [:<] a_0[-](a k)[*]r[^]k[+]eta)).
(* End_Tex_Verb *)
Intros.
Cut (AbsCC b_0') [#] Zero. Intro.
Cut (cc_IR (AbsCC b_0')) [#] Zero. Intro.
Cut (a k) [#] Zero. Intro.
Cut (b k) [#] Zero. Intro.
Cut (lt (0) k). Intro.
Cut [--](((cc_IR (a k))[/](cc_IR (AbsCC b_0'))[//]H8)[*](b_0'[/](b k)[//]H10))
  [#] Zero. Intro.
Elim (nrootCC
  [--](((cc_IR (a k))[/](cc_IR (AbsCC b_0'))[//]H8)[*](b_0'[/](b k)[//]H10))
  H12 k H11).
Intro w. Intros.
Cut (AbsCC w) [=] One. Intro.
Exists (cc_IR r)[*]w.
Split.
Step (AbsCC (cc_IR r))[*](AbsCC w).
Cut Zero [:<=] r. Intro. 2: Apply less_leEq; Auto.
Step r[*](AbsCC w).
Step_final r[*]One.
Apply leEq_less_trans with
  (AbsCC b_0'[+](b k)[*]((cc_IR r)[*]w)[^]k)[+](AbsCC b_0[-]b_0').
Apply leEq_wdl with
  (AbsCC (b_0'[+](b k)[*]((cc_IR r)[*]w)[^]k)[+](b_0[-]b_0')).
Apply triangle.
Apply AbsCC_wd.
Rational.
Apply less_wdl with
  (AbsCC b_0')[-](a k)[*]r[^]k[+](AbsCC b_0[-]b_0').
Apply plus_resp_less_lft.
Step_less_lft (AbsCC [--](b_0[-]b_0')).
Apply less_wdl with (AbsCC b_0'[-]b_0).
Auto.
Apply AbsCC_wd.
Rational.
Apply bin_op_wd_unfolded.
Apply eq_transitive_unfolded with
  (AbsCC (b_0'[/](cc_IR (AbsCC b_0'))[//]H8)[*]
    ((cc_IR (AbsCC b_0'))[-](cc_IR (a k))[*](cc_IR r)[^]k)).
Step One[*]((AbsCC b_0')[-](a k)[*]r[^]k).
Step_rht (AbsCC (b_0'[/](cc_IR (AbsCC b_0'))[//]H8))[*]
  (AbsCC ((cc_IR (AbsCC b_0'))[-](cc_IR (a k))[*](cc_IR r)[^]k)).
Apply bin_op_wd_unfolded.
Step (AbsCC b_0')[/](AbsCC b_0')[//]H7.
Apply eq_symmetric_unfolded.
Apply cc_div_abs'.
Apply AbsCC_nonneg.
Step_rht (AbsCC (cc_IR (AbsCC b_0'))[-](cc_IR (a k))[*](cc_IR r[^]k)).
Step_rht (AbsCC (cc_IR (AbsCC b_0'))[-](cc_IR (a k)[*]r[^]k)).
Step_rht (AbsCC (cc_IR (AbsCC b_0')[-](a k)[*]r[^]k)).
Cut Zero [:<=] (AbsCC b_0')[-](a k)[*]r[^]k. Intro.
2: Apply shift_leEq_lft; Apply less_leEq; Auto.
Algebra.
Apply AbsCC_wd.
Apply eq_transitive_unfolded with b_0'[+](b k)[*]((cc_IR r)[^]k[*]
  [--](((cc_IR (a k))[/](cc_IR (AbsCC b_0'))[//]H8)[*](b_0'[/](b k)[//]H10))).
Rational.
Apply bin_op_wd_unfolded. Algebra.
Apply bin_op_wd_unfolded. Algebra.
Step_final (cc_IR r)[^]k[*]w[^]k.
Algebra.
Apply root_one with k.
Apply AbsCC_nonneg.
Auto.
Step (AbsCC w[^]k).
Step (AbsCC
  [--](((cc_IR (a k))[/](cc_IR (AbsCC b_0'))[//]H8)[*](b_0'[/](b k)[//]H10))).
Step
  (AbsCC ((cc_IR (a k))[/](cc_IR (AbsCC b_0'))[//]H8)[*](b_0'[/](b k)[//]H10)).
Step (AbsCC ((cc_IR (a k))[/](cc_IR (AbsCC b_0'))[//]H8))[*]
  (AbsCC (b_0'[/](b k)[//]H10)).
Step (AbsCC ((cc_IR (a k))[/](cc_IR (AbsCC b_0'))[//]H8))[*]
  (AbsCC (b_0'[/](b k)[//]H10)).
Cut Zero [:<=] (AbsCC b_0'). Intro. 2: Apply AbsCC_nonneg.
Step ((AbsCC (cc_IR (a k)))[/](AbsCC b_0')[//]H7)[*]
  (AbsCC (b_0'[/](b k)[//]H10)).
Step ((AbsCC (cc_IR (a k)))[/](AbsCC b_0')[//]H7)[*]
  (AbsCC (b_0'[/](b k)[//]H10)).
Cut Zero [:<=] (a k). Intro. 2: Apply less_leEq; Auto.
Step ((a k)[/](AbsCC b_0')[//]H7)[*](AbsCC (b_0'[/](b k)[//]H10)).
Step ((a k)[/](AbsCC b_0')[//]H7)[*]((AbsCC b_0')[/](AbsCC (b k))[//]H9).
Unfold a.
Rational.
Step_ap_rht [--]Zero::CC.
Apply min_resp_ap.
Apply mult_resp_ap_zero.
Apply div_resp_ap_zero_rev.
Step_ap_rht (cc_IR Zero).
Apply cc_IR_1a.
Auto.
Apply div_resp_ap_zero_rev.
Apply AbsCC_ap_zero.
Apply less_imp_ap.
Auto.
Auto with arith.
Apply AbsCC_ap_zero.
Apply ap_symmetric_unfolded.
Auto.
Apply ap_symmetric_unfolded.
Apply less_imp_ap.
Auto.
Step_ap_rht (cc_IR Zero).
Apply cc_IR_1a.
Auto.
Apply ap_symmetric_unfolded.
Apply less_imp_ap.
Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma Kneser_1' : Half [:<] q.
(* End_Tex_Verb *)
Proof.
Unfold q.
Apply shift_less_minus.
Step_less_lft Smallest[+]Half.
Apply shift_plus_less.
Unfold half.
Step_Rat_less_rht (One[/]TwoNZ) ::IR.
Unfold Smallest.
Unfold Small.
Unfold Smaller.
Generalize (p3m_smaller n gt_n_0).
Intro Hn.
Generalize (p3m_smaller (mult two_n n)).
Intro H2nn.
Apply less_transitive_unfolded with Half[*]Half::IR.
Apply mult_resp_less_both.
Apply less_leEq.
Exact (p3m_pos ?).
Exact Hn.
Apply less_leEq.
Exact (p3m_pos ?).
Apply H2nn.
Unfold two_n.
Elim gt_n_0.Auto with arith.
Intros. Simpl.Auto with arith.
Step_Rat_less_rht (One[/]TwoNZ)[*]One::IR.
Apply mult_resp_less_lft.
Exact (half_lt1 ?).
Exact (pos_half ?).
Qed.

(* Begin_Tex_Verb *)
Lemma Kneser_1'' : q [:<] One.
(* End_Tex_Verb *)
Proof.
Unfold q.
Apply shift_minus_less'.
Step_Rat_less_lft Zero[+]One::IR.
Apply shift_plus_less.
Step_Rat_less_rht Smallest.
Unfold Smallest.
Unfold Small.
Unfold Smaller.
Apply mult_resp_pos.
Exact (p3m_pos ?).
Exact (p3m_pos ?).
Qed.

(* Begin_Tex_Verb *)
Lemma Kneser_1 :
(a_0,eta,eps:IR)(Zero [:<] eta) -> (Zero [:<] eps) ->
        (a_0[+]Three[*]eta [:<] c) ->
        (Two[*](Three[^]n[+]One)[*]eps [:<] eta) ->
          (q[*]a_0[+]Three[^]n[*]eps[+]eps[+]eta [:<] q[*]c).
(* End_Tex_Verb *)
Proof.
Intros.
Step_Rat_less_lft (q[*]a_0[+]
	(One[/]TwoNZ)[*](Two[*]Three[^]n[*]eps[+] Two[*]eps[+]Two[*]eta)).
Cut One[/]TwoNZ[*](Two[*]Three[^]n[*]eps[+]Two[*]eps[+]Two[*]eta) [:<]
	q[*](Two[*]Three[^]n[*]eps[+]Two[*]eps[+]Two[*]eta).
Intro Hm.
Apply less_transitive_unfolded with q[*]a_0 [+]
	q[*](Two[*]Three[^]n[*]eps[+]Two[*]eps[+]Two[*]eta).
Apply plus_resp_less_lft.
Assumption.
Step_Rat_less_lft q[*](a_0 [+] Two[*]Three[^]n[*]eps[+]Two[*]eps[+]Two[*]eta).
Apply mult_resp_less_lft.
Apply less_transitive_unfolded with a_0[+]Three[*]eta.
Step_Rat_less_lft a_0[+](Two[*]Three[^]n[*]eps[+]Two[*]eps[+]Two[*]eta).
Apply plus_resp_less_lft.
Step_Rat_less_lft Two[*](Three[^]n[+]One)[*]eps[+]Two[*]eta.
Step_Rat_less_rht eta[+]Two[*]eta.
Apply plus_resp_less_rht.
Assumption.
Assumption.
Apply less_transitive_unfolded with Half::IR.
Apply pos_half. Exact Kneser_1'.
Cut Zero[:<](Two[*]Three[^]n[*]eps[+]Two[*]eps[+]Two[*]eta).
Intro Ha.
Apply mult_resp_less.
Exact Kneser_1'. Assumption.
Apply less_transitive_unfolded with Zero[+]Two[*]eta.
Step_Rat_less_rht Two[*]eta.
Apply mult_resp_pos.
Exact (pos_two ?).
Exact H.
Apply plus_resp_less_rht.
Apply less_transitive_unfolded with Zero[+]Two[*]eps.
Step_Rat_less_rht Two[*]eps.
Apply mult_resp_pos.
Exact (pos_two ?).
Exact H0.
Apply plus_resp_less_rht.
Apply mult_resp_pos.
Apply mult_resp_pos.
Exact (pos_two ?).
Apply nexp_resp_pos.
Exact (pos_three ?).
Exact H0.
Qed.

(* Begin_Tex_Verb *)
Lemma Kneser_2a :
(R:CRing)(m,n,i:nat)(f:nat->R)
  (le (1) i) ->
    (Sum m n f) [=] (f m)[+](f i)[+]((Sum (S m) (pred i) f)[+](Sum (S i) n f)).
(* End_Tex_Verb *)
Intros.
Step (f m)[+](Sum (S m) n0 f).
Step (f m)[+]((Sum (S m) i f)[+](Sum (S i) n0 f)).
Step (f m)[+](((Sum (S m) (pred i) f)[+](f i))[+](Sum (S i) n0 f)).
Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma Kneser_2b :
(k:nat; z:CC)(le (1) k) ->
  let p_ = [i:nat](b i)[*]z[^]i in
        (Sum (0) n [i:nat](b i)[*]z[^]i) [=]
          (b_0[+](b k)[*]z[^]k)[+]
            ((Sum (1) (pred k) p_)[+](Sum (S k) n p_)).
(* End_Tex_Verb *)
Intros.
Unfold b_0.
Apply eq_transitive_unfolded with
  let p_ = [i:nat](b i)[*]z[^]i in
    ((b (0))[*]z[^](0)[+](b k)[*]z[^]k)[+]
      ((Sum (1) (pred k) p_)[+](Sum (S k) n p_)).
Apply Kneser_2a with f := [i:nat](b i)[*]z[^]i.
Auto.
Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma Kneser_2c :
(m,n:nat; z:CC)(le m (S n)) ->
  let r = (AbsCC z) in
        (AbsCC (Sum m n [i:nat](b i)[*]z[^]i)) [:<=]
          (Sum m n [i:nat](a i)[*]r[^]i).
(* End_Tex_Verb *)
Intros.
Apply leEq_wdr with (Sum m n0 [i:nat](AbsCC (b i)[*]z[^]i)).
Apply triangle_sum with z := [i:nat](b i)[*]z[^]i. Auto.
Apply sum_wd.
Intros.
Unfold a.
Step_final (AbsCC (b i))[*](AbsCC z[^]i).
Qed.

(* Begin_Tex_Verb *)
Lemma Kneser_2 :
(k:nat; z:CC)(le (1) k) -> (le k n) ->
  let r = (AbsCC z) in
  let p_ = [i:nat](a i)[*]r[^]i in
        (AbsCC (Sum (0) n [i:nat](b i)[*]z[^]i)) [:<=]
          (AbsCC (b_0[+](b k)[*]z[^]k))[+]
             ((Sum (1) (pred k) p_)[+](Sum (S k) n p_)).
(* End_Tex_Verb *)
Intros.
Apply leEq_wdl with
  let p_ = [i:nat](b i)[*]z[^]i in
    (AbsCC (b_0[+](b k)[*]z[^]k)[+]((Sum (1) (pred k) p_)[+](Sum (S k) n p_))).
Apply leEq_transitive with
  let p_ = [i:nat](b i)[*]z[^]i in
    (AbsCC (b_0[+](b k)[*]z[^]k))[+]
      (AbsCC ((Sum (1) (pred k) p_)[+](Sum (S k) n p_))).
Apply triangle.
Apply plus_resp_leEq_lft.
Apply leEq_transitive with
  let p_ = [i:nat](b i)[*]z[^]i in
    (AbsCC (Sum (1) (pred k) p_))[+](AbsCC (Sum (S k) n p_)).
Apply triangle.
Apply plus_resp_leEq_both.
Apply Kneser_2c. Auto with arith.
Apply Kneser_2c. Auto with arith.
Apply AbsCC_wd.
Apply eq_symmetric_unfolded.
Apply Kneser_2b.
Auto.
Qed.

(* Begin_Tex_Verb *)
Lemma Kneser_3 :
        (EX z |
          ((AbsCC z)[^]n [:<] c) /\
          ((AbsCC (Sum (0) n [i:nat](b i)[*]z[^]i)) [:<] q[*]c)).
(* End_Tex_Verb *)
Proof.
Elim eta_exists. Intro eta. Intros.
Elim H. Intros.
Elim H1. Intro b_0'. Intros.
Elim H2. Intros. Elim H4. Intros.
Cut (Zero [:<] (AbsCC b_0')). Intro.
Elim (eps_exists eta (AbsCC b_0') H0 H7). Intro eps. Intros.
Elim H8. Intros. Elim H10. Intros. Elim H12. Intros.
Cut (k:nat)(Zero [:<=] (a k)). Intro.
Cut (a n) [=] One. Intro.
Elim (Main (a) n gt_n_0 eps H9 H15 H16 (AbsCC b_0') H14). Intro r. Intros.
Elim H17. Intros.
Elim H19. Intro k. Intros.
Elim H20. Intros. Elim H22. Intros. Elim H24. Intros. Elim H26. Intros.
Elim H28. Intros.
Cut Zero [:<] (a k). Intro.
Elim (z_exists b_0' k r eta H7 H31 H21 H23 H18 H0 H3 H30). Intro z. Intros.
Elim H32. Intros.
Exists z.
Split.
Step_less_lft r[^]n.
Apply less_transitive_unfolded with (AbsCC b_0').
Auto.
Apply less_transitive_unfolded with (AbsCC b_0')[+]Three[*]eta.
Step_less_lft (AbsCC b_0')[+]Zero.
Apply plus_resp_less_lft.
Apply mult_resp_pos.
Apply pos_three.
Auto.
Auto.
Apply leEq_less_trans with
  let r = (AbsCC z) in
  let p_ = [i:nat](a i)[*]r[^]i in
    (AbsCC (b_0[+](b k)[*]z[^]k))[+]((Sum (1) (pred k) p_)[+](Sum (S k) n p_)).
Apply Kneser_2.
Auto.
Auto.
Apply less_wdl with
  let p_ = [i:nat](a i)[*]r[^]i in
    (AbsCC (b_0[+](b k)[*]z[^]k))[+]((Sum (1) (pred k) p_)[+](Sum (S k) n p_)).
Apply less_transitive_unfolded with
  (AbsCC b_0[+](b k)[*]z[^]k)[+]
    ((One[-]Small)[*]((a k)[*]r[^]k)[+]Three[^]n[*]eps).
Apply plus_resp_less_lft.
Auto.
Apply less_transitive_unfolded with
  ((AbsCC b_0')[-](AbsCC (b k))[*]r[^]k[+]eta)[+]
    ((One[-]Small)[*]((a k)[*]r[^]k)[+]Three[^]n[*]eps).
Apply plus_resp_less_rht.
Auto.
Unfold a.
Apply less_wdl with
  ((AbsCC b_0')[+]Three[^]n[*]eps[+]eta)[-]Small[*]((AbsCC (b k))[*]r[^]k).
Apply less_transitive_unfolded with
  ((AbsCC b_0')[+]Three[^]n[*]eps[+]eta)[-]
    Small[*](Smaller[*](AbsCC b_0')[-]Two[*]eps).
Apply minus_resp_less_rht.
Apply mult_resp_less_lft.
Auto.
Unfold Small.
Apply p3m_pos.
Apply less_wdl with
  (Small[*]Two)[*]eps[+](q[*](AbsCC b_0')[+]Three[^]n[*]eps[+]eta).
Apply less_transitive_unfolded with
  eps[+](q[*](AbsCC b_0')[+]Three[^]n[*]eps[+]eta).
Apply plus_resp_less_rht.
Step_less_rht One[*]eps.
Apply mult_resp_less.
Step_less_rht Half[*]Two::IR.
Apply mult_resp_less.
Unfold Small.
Apply p3m_smaller.
Auto.
Apply pos_two.
Auto.
Apply less_wdl with q[*](AbsCC b_0')[+]Three[^]n[*]eps[+]eps[+]eta.
Apply Kneser_1.
Auto.
Auto.
Auto.
Auto.
Rational.
Unfold q.
Unfold Smallest.
Rational.
Rational.
Apply bin_op_wd_unfolded.
Algebra.
Apply bin_op_wd_unfolded.
Apply sum_wd.
Intros.
Algebra.
Apply sum_wd.
Intros.
Algebra.
Apply mult_cancel_less with r[^]k.
Apply nexp_resp_pos.
Auto.
Step_less_lft Zero::IR.
Apply less_transitive_unfolded with Smaller[*](AbsCC b_0')[-]Two[*]eps.
Apply shift_zero_less_minus.
Auto.
Auto.
Unfold a.
Step_final (AbsCC One).
Unfold a.
Intros.
Apply AbsCC_nonneg.
Apply AbsCC_pos.
Auto.
Qed.

End Kneser_Lemma.

(* Begin_Tex_Verb *)
Lemma Kneser :
(n:nat)(lt (0) n) ->
  (EX q | (Zero [:<] q) /\ (q [:<] One) /\
    (p:(cpoly CC))(Monic n p) ->
      (c:IR)((AbsCC (p!Zero)) [:<] c) ->
        (EX z |
          ((AbsCC z)[^]n [:<] c) /\
          ((AbsCC (p!z)) [:<] q[*]c))).
(* End_Tex_Verb *)
Intros.
Exists (One[-](p3m n)[*](p3m (mult (mult (2) n) n))).
Split.
Apply less_transitive_unfolded with Half::IR.
Apply pos_half.
Apply Kneser_1'.
Assumption.
Split.
Apply Kneser_1''.
Intros.
Elim H0. Intros.
Cut (Nth_coeff n p) [=] One. Intro.
Elim (Kneser_3 [i:nat](Nth_coeff i p) n H H4 c). Intro z. Intros.
Elim H5. Intros.
Exists z.
Split.
Auto.
Step_less_lft (AbsCC (Sum (0) n [i:nat](Nth_coeff i p)[*]z[^]i)).
Auto.
Step_less_lft (AbsCC p!Zero).
Auto.
Auto.
Qed.


