(* $Id: MainLemma.v,v 1.15 2000/11/10 11:27:33 freek Exp $ *)

Require Export KeyLemma.

(* Tex_Prose
\section{Main Lemma}
*)

(* Tex_Prose
TO DO: Put next lemma in more appropriate place.
*)
(* Begin_Tex_Verb *)
Lemma kseq_prop :
(k:nat->nat; n:nat)
        ((i:nat)(le (1) (k i)) /\ (le (k i) n)) ->
        ((i:nat)(le (k (S i))(k i))) ->
          (EX j | (lt (S j) (mult (2) n)) /\ (k j) = (k (S j)) /\
                                                (k (S j)) = (k (S (S j)))).
(* End_Tex_Verb *)
Intros k n.
Generalize k.
Induction n.
Intros.
Elim (H O); Intros.
Generalize (le_trans ??? H1 H2); Intro.
Cut False.
Intro.
Elim H4.
Omega.
Intros.
Elim (eq_nat_dec (k0 (0)) (k0 (2))).
Intro.
Exists (0).
Cut (k0 (0))=(k0 (1)).
Intro.
Repeat Split.
Omega.
Assumption.
Rewrite <- H1.
Assumption.
Apply le_antisym.
Rewrite y.
Apply H0.
Apply H0.
Intro.
Elim (Hrecn [m:nat](k0 (S (S m)))).
Intros.
Exists (S (S x)).
Omega.
2: Intro; Apply H0.
Intro.
Split.
Elim (H (S (S i))); Auto.
Elim (lt_eq_lt_dec (k0 (0)) (k0 (2))); Intro.
Elim y0; Intro.
Generalize (H0 (0)); Intro.
Generalize (H0 (1)); Intro.
Omega.
Tauto.
Generalize (H (0)); Intro.
Elim H1; Intros.
Generalize (lt_le_trans ??? y0 H3); Intro.
Cut (le (k0 (2)) n); Try Omega.
Intro.
Induction i.
Assumption.
Apply le_trans with (k0 (S (S i))).
Apply H0.
Assumption.
Qed.


Section Main_Lemma.

(* Tex_Prose
\begin{convention}
Let \verb!a : nat->IR!, \verb!n : nat!, \verb!(lt (0) n)!,
\verb!eps : IR!, \verb!(Zero [:<] eps)!, \verb!(k:nat)(Zero [:<=] (a k))!,
\verb!(a n) [=] One!, \verb!a_0 : IR!, \verb!(eps [:<] a_0)!.
\end{convention}
*)
Variable a : nat->IR.
Variable n : nat.
Hypothesis gt_n_0 : (lt (0) n).
Variable eps : IR.
Hypothesis eps_pos : (Zero [:<] eps).
Hypothesis a_nonneg : (k:nat)(Zero [:<=] (a k)).
Hypothesis a_n_1 : (a n) [=] One.
Variable a_0 : IR.
Hypothesis eps_lt_a_0 : (eps [:<] a_0).

(* Begin_Tex_Verb *)
Lemma a_0_pos : Zero [:<] a_0.
(* End_Tex_Verb *)
Apply less_transitive_unfolded with eps; Auto.
Qed.


(* Begin_Tex_Verb *)
Local two_n := (mult (2) n).
Local Small := (p3m n).
Local Smaller := (p3m (mult two_n n)).
(* End_Tex_Verb *)


(* Begin_Tex_Verb *)
Lemma Main_1a' :
(t:IR; j,k:nat)
  let r' = t[*](p3m (S (S j))) in
  let r = t[*](p3m (S j)) in
    ((i:nat)(le (1) i) -> (le i n) ->
      ((a i)[*]r'[^]i[-]eps [:<] (a k)[*]r'[^]k)) ->
    (i:nat)(le (1) i) -> (le i n) ->
      (a i)[*](r[/]ThreeNZ)[^]i[-]eps [:<] (a k)[*](r[/]ThreeNZ)[^]k.
(* End_Tex_Verb *)
Intros.
Cut (t[*](p3m (S j)))[/]ThreeNZ [=] t[*](p3m (S (S j))). Intro.
Step_less_lft (a i)[*](t[*](p3m (S (S j))))[^]i[-]eps.
Step_less_rht (a k)[*](t[*](p3m (S (S j))))[^]k.
Auto.
Step_final t[*]((p3m (S j))[/]ThreeNZ).
Qed.

(* Begin_Tex_Verb *)
Lemma Main_1b' :
(t:IR; j,k:nat)
  let r' = t[*](p3m j) in
  let r = t[*](p3m (S j)) in
    ((i:nat)(le (1) i) -> (le i n) ->
      ((a i)[*]r'[^]i[-]eps [:<] (a k)[*]r'[^]k)) ->
    (i:nat)(le (1) i) -> (le i n) ->
      (a i)[*](r[*]Three)[^]i[-]eps [:<] (a k)[*](r[*]Three)[^]k.
(* End_Tex_Verb *)
Intros.
Cut (t[*](p3m (S j)))[*]Three [=] t[*](p3m j). Intro.
Step_less_lft (a i)[*](t[*](p3m j))[^]i[-]eps.
Step_less_rht (a k)[*](t[*](p3m j))[^]k.
Auto.
Step_final t[*]((p3m (S j))[*]Three).
Qed.

(* Begin_Tex_Verb *)
Lemma Main_1a :
(r:IR; k:nat)
  (Zero [:<] r) -> (le (1) k) -> (le k n) ->
  ((i:nat)(le (1) i) -> (le i n) ->
    ((a i)[*](r[/]ThreeNZ)[^]i[-]eps [:<] (a k)[*](r[/]ThreeNZ)[^]k)) ->
        let p_ = [i:nat](a i)[*]r[^]i in
        let p_k = (a k)[*]r[^]k in
          ((Sum (1) (pred k) p_)
                [:<] Half[*](One[-]Small)[*]p_k[+]Half[*]Three[^]n[*]eps).
(* End_Tex_Verb *)
Intros.
Apply leEq_less_trans with
   (Sum (1) (pred k) [i:nat](Three[^]i[*]((a k)[*](r[/]ThreeNZ)[^]k [+] eps))).
Apply sum_resp_leEq.
Auto with arith.
Intros.
Cut Three[^]i[#]Zero::IR.
Intro.
Apply shift_leEq_mult' with H5.
Apply nexp_resp_pos.
Apply pos_three.
Step_leEq_lft (a i)[*](r[^]i [/] Three[^]i [//] H5).
Step_leEq_lft (a i)[*](r[/]ThreeNZ)[^]i.
Step_leEq_rht eps[+] (a k)[*](r[/]ThreeNZ)[^]k.
Apply shift_leEq_plus'.
Apply less_leEq.
Apply H2.
Assumption.
Omega.
Apply nexp_resp_ap_zero.
Apply three_ap_zero.
Apply less_wdl with (Sum (1) (pred k)
     [i:nat]Three[^]i)[*]((a k)[*](r[/]ThreeNZ)[^]k[+]eps).
Cut Three[-]One [#] Zero::IR.
Intro.
Step_less_lft ((Three[^](S (pred k))[-]Three[^](1)) [/] (Three[-]One)[//]H3)[*]
              ((a k)[*](r[/]ThreeNZ)[^]k[+]eps).
Replace (S (pred k)) with k.
Step_less_lft ((Three[^](k)[-]Three) [/] (Three[-]One) [//] H3) [*]
              ((a k)[*](r[/]ThreeNZ)[^]k[+]eps).
Step_Rat_less_lft (One[/]TwoNZ[*](Three[^](k)[-]Three)) [*]
                                              ((a k)[*](r[/]ThreeNZ)[^]k) [+]
                  (One[/]TwoNZ[*](Three[^](k)[-]Three)) [*] eps.
Apply leEq_less_trans with Half[*](One[-]Small)[*]((a k)[*]r[^]k)
             [+] One[/]TwoNZ[*](Three[^](k)[-]Three)[*]eps.
Apply plus_resp_leEq.
Cut Three[^]k[#]Zero::IR.
Intro.
Step_leEq_lft  One[/]TwoNZ[*](Three[^]k[-]Three)[*]((a k)[*]
               (r[^]k[/]Three[^]k[//]H4)).
Step_Rat_leEq_lft  One[/]TwoNZ[*](a k)[*](r[^]k)[*]
                  (One[-]Three[/]Three[^]k[//]H4).
Step_Rat_leEq_rht
   (Half[*](a k)[*]r[^]k)[*](One[-]Small).
Unfold half.
Apply mult_resp_leEq_lft.
Apply minus_resp_leEq_both.
Apply leEq_reflexive.
Unfold Small.
Unfold p3m.
Cut Three[^](pred k)[#]Zero::IR.
Intro.
Apply leEq_wdr with One[/]Three[^](pred k)[//]H5.
Cut Three[^]n [#] Zero::IR.
Intro.
Step_leEq_lft One[/](Three[^]n)[//]H6.
Apply recip_resp_leEq.
Apply nexp_resp_pos.
Apply pos_three.
Apply great_nexp_resp_le.
Apply one_less_three.
Omega.
Apply nexp_resp_ap_zero.
Apply three_ap_zero.
Apply eq_div.
Pattern 1 k.
Replace k with (S (pred k)).
Step_lft One[*](Three[*]Three[^](pred k))::IR.
Rational.
Omega.
Apply nexp_resp_ap_zero.
Apply three_ap_zero.
Apply mult_resp_nonneg.
Apply mult_resp_nonneg.
Apply less_leEq.
Step_less_rht Half::IR.
Apply pos_half.
Apply a_nonneg.
Apply less_leEq.
Apply nexp_resp_pos.
Assumption.
Apply nexp_resp_ap_zero.
Apply three_ap_zero.
Apply plus_resp_less_lft.
Step_Rat_less_lft One[/]TwoNZ[*]eps[*](Three[^]k[-]Three).
Step_Rat_less_rht Half[*]eps[*]Three[^]n.
Unfold half.
Apply mult_resp_less_lft.
Apply less_leEq_trans with Three[^]k::IR.
Step_less_rht Three[^]k[-]Zero::IR.
Apply minus_resp_less_rht.
Apply pos_three.
Apply great_nexp_resp_le.
Apply one_less_three.
Assumption.
Apply mult_resp_pos.
Step_less_rht Half::IR.
Apply pos_half.
Assumption.
Omega.
Step_Rat_ap_lft Two::IR.
Apply two_ap_zero.
Algebra.
Apply eq_symmetric_unfolded.
Apply mult_distr_sum_rht with f := ([i:nat](Three::IR)[^]i).
Qed.

(* Begin_Tex_Verb *)
Lemma Main_1b :
(r:IR; k:nat)
  (Zero [:<] r) -> (le (1) k) -> (le k n) ->
  ((i:nat)(le (1) i) -> (le i n) ->
    ((a i)[*](r[*]Three)[^]i[-]eps [:<] (a k)[*](r[*]Three)[^]k)) ->
        let p_ = [i:nat](a i)[*]r[^]i in
        let p_k = (a k)[*]r[^]k in
          ((Sum (S k) n p_)
                [:<] Half[*](One[-]Small)[*]p_k[+]Half[*]Three[^]n[*]eps).
(* End_Tex_Verb *)
Intros.
Cut (i:nat)Three[^]i [#] Zero::IR.
Intro.
Apply leEq_less_trans with
    (Sum (S k) n
     [i:nat](((a k)[*](r[*]Three)[^]k [+] eps) [/] Three[^]i [//] (H3 i))).
Apply sum_resp_leEq.
Auto with arith.
Intros.
Apply shift_leEq_div.
Apply nexp_resp_pos.
Apply pos_three.
Step_Rat_leEq_rht eps[+] (a k)[*](r[*]Three)[^]k.
Apply shift_leEq_plus'.
Apply less_leEq.
Step_Rat_less_lft  (a i)[*](r[^]i[*]Three[^]i)[-]eps.
Step_less_lft  (a i)[*](r[*]Three)[^]i[-]eps.
Apply H2.
Omega.
Assumption.
Step_less_lft
 (Sum (S k) n
     [i:nat]( (((a k)[*](r[*]Three)[^]k[+]eps)[*]One)
              [/] (Three[^]i) [//] (H3 i) )).
Step_less_lft
 (Sum (S k) n
     [i:nat]( (((a k)[*](r[*]Three)[^]k[+]eps))[*](One
              [/] (Three[^]i) [//] (H3 i) ))).
Apply less_wdl with
     (((a k)[*](r[*]Three)[^]k[+]eps))[*]
    (Sum (S k) n
     [i:nat]( (One
              [/] (Three[^]i) [//] (H3 i) ))).
2: Apply eq_symmetric_unfolded.
2: Apply mult_distr_sum_lft with f := [i:nat]One[/]Three[^]i[//](H3 i).
Step_less_lft ((a k)[*](r[*]Three)[^]k[+]eps)
              [*](Sum (S k) n [i:nat](One[/]ThreeNZ)[^]i).
Cut (One [-] One [/] ThreeNZ) [#] Zero::IR.
Intro.
2: Step_Rat_ap_lft Two::IR[/]ThreeNZ.
2: Apply div_resp_ap_zero_rev.
2: Apply two_ap_zero.
Step_less_lft ((a k)[*](r[*]Three)[^]k[+]eps)
              [*](((One[/]ThreeNZ)[^](S k) [-] (One[/]ThreeNZ)[^](S n)) [/]
                  (One [-] One [/] ThreeNZ) [//] H4).
Step_less_lft ((a k)[*](r[*]Three)[^]k[+]eps)
              [*](((One[/]ThreeNZ)[*](One[/]ThreeNZ)[^]k [-]
                   (One[/]ThreeNZ)[*](One[/]ThreeNZ)[^]n) [/]
                  (One [-] One [/] ThreeNZ) [//] H4).
Step_Rat_less_lft (One[/]TwoNZ)[*]((a k)[*](r[*]Three)[^]k)
              [*] ((One[/]ThreeNZ)[^]k [-] (One[/]ThreeNZ)[^]n) [+]
                  ((One[/]TwoNZ)[*]eps)
              [*] ((One[/]ThreeNZ)[^]k [-] (One[/]ThreeNZ)[^]n).
Apply leEq_less_trans with
                   Half[*](One[-]Small)[*]((a k)[*]r[^]k) [+]
                  ((One[/]TwoNZ)[*]eps)
              [*] ((One[/]ThreeNZ)[^]k [-] (One[/]ThreeNZ)[^]n).
Apply plus_resp_leEq.
2: Apply plus_resp_less_lft.
Step_leEq_lft (One[/]TwoNZ)[*]((a k)[*]((r[^]k[*]Three[^]k)))
              [*] ((One[/]ThreeNZ)[^]k [-] (One[/]ThreeNZ)[^]n).
Step_Rat_leEq_lft (One[/]TwoNZ)[*](a k)[*](r[^]k)
              [*] (Three[^]k[*](One[/]ThreeNZ)[^]k [-]
                   Three[^]k[*](One[/]ThreeNZ)[^]n).
Unfold half.
Step_Rat_leEq_rht (One[/]TwoNZ)[*](a k)[*](r[^]k)[*](One[-]Small).
Apply mult_resp_leEq_lft.
Step_leEq_lft (Three::IR[*](One[/]ThreeNZ))[^]k [-]
               Three[^]k[*](One[/]ThreeNZ)[^]n.
Step_leEq_lft ((Three::IR[*]One)[/]ThreeNZ)[^]k [-]
               Three[^]k[*](One[/]ThreeNZ)[^]n.
Step_leEq_lft (Three::IR[/]ThreeNZ)[^]k [-]
               Three[^]k[*](One[/]ThreeNZ)[^]n.
Step_leEq_lft (One::IR)[^]k [-]  Three[^]k[*](One[/]ThreeNZ)[^]n.
Step_leEq_lft (One::IR) [-] Three[^]k[*](One[/]ThreeNZ)[^]n.
Apply less_leEq.
Apply minus_resp_less_rht.
Unfold Small.
Unfold p3m.
Step_Rat_less_lft (One::IR) [*] (One[/]ThreeNZ)[^]n.
Apply mult_resp_less.
Step_less_lft (One::IR)[^]k.
Apply nexp_resp_less.
Assumption.
Apply less_leEq.
Apply pos_one.
Apply one_less_three.
Apply nexp_resp_pos.
Apply div_resp_pos.
Apply pos_three.
Apply pos_one.
Apply mult_resp_nonneg.
Apply mult_resp_nonneg.
Apply less_leEq.
Apply div_resp_pos.
Apply pos_two.
Apply pos_one.
Apply a_nonneg.
Apply less_leEq.
Apply nexp_resp_pos.
Assumption.
Step_Rat_less_rht Half[*]eps[*]Three[^]n.
Unfold half.
Apply mult_resp_less_lft.
Apply less_leEq_trans with One::IR.
Apply less_transitive_unfolded with ((One::IR)[/]ThreeNZ)[^]k.
Step_less_rht ((One::IR)[/]ThreeNZ)[^]k [-] Zero.
Apply minus_resp_less_rht.
Apply nexp_resp_pos.
Apply div_resp_pos.
Apply pos_three.
Apply pos_one.
Step_less_rht One[^]k :: IR.
Apply nexp_resp_less.
Assumption.
Apply less_leEq.
Apply div_resp_pos.
Apply pos_three.
Apply pos_one.
Step_less_rht (One::IR)[/]OneNZ.
Apply recip_resp_less.
Apply pos_one.
Apply one_less_three.
Apply less_leEq.
Step_less_lft (One::IR)[^]n.
Apply nexp_resp_less.
Assumption.
Apply less_leEq.
Apply pos_one.
Apply one_less_three.
Apply mult_resp_pos.
Apply div_resp_pos.
Apply pos_two.
Apply pos_one.
Assumption.
Intro.
Apply ap_symmetric_unfolded.
Apply less_imp_ap.
Apply nexp_resp_pos.
Apply pos_three.
Qed.


(* Begin_Tex_Verb *)
Lemma Main_1 :
(r:IR; k:nat)
  (Zero [:<] r) -> (le (1) k) -> (le k n) ->
  ((i:nat)(le (1) i) -> (le i n) ->
    ((a i)[*](r[/]ThreeNZ)[^]i[-]eps [:<] (a k)[*](r[/]ThreeNZ)[^]k)) ->
  ((i:nat)(le (1) i) -> (le i n) ->
    ((a i)[*](r[*]Three)[^]i[-]eps [:<] (a k)[*](r[*]Three)[^]k)) ->
        let p_ = [i:nat](a i)[*]r[^]i in
        let p_k = (a k)[*]r[^]k in
          ((Sum (1) (pred k) p_) [+] (Sum (S k) n p_)
                [:<] (One[-]Small)[*]p_k[+]Three[^]n[*]eps).
(* End_Tex_Verb *)
Intros.
Apply less_wdr with
  let p_k = (a k)[*]r[^]k in
  let h = Half[*](One[-]Small)[*]p_k[+]Half[*]Three[^]n[*]eps in
    h[+]h.
Apply plus_resp_less_both.
Apply Main_1a; Auto.
Apply Main_1b; Auto.
Unfold half.
Rational.
Qed.


(* Begin_Tex_Verb *)
Lemma Main_2' :
(t:IR; i,k:nat)
  ((a i)[*](t[*](p3m (0)))[^]i[-]eps [:<] (a k)[*](t[*](p3m (0)))[^]k) ->
    (a i)[*]t[^]i[-]eps [:<] (a k)[*]t[^]k.
(* End_Tex_Verb *)
Intros.
Cut t[*](p3m (0)) [=] t. Intro.
Step_less_lft (a i)[*](t[*](p3m (0)))[^]i[-]eps.
Step_less_rht (a k)[*](t[*](p3m (0)))[^]k.
Auto.
Step_final t[*]One.
Qed.

(* Begin_Tex_Verb *)
Lemma Main_2 :
(t:IR; j,k:nat)
  let r = t[*](p3m j) in
        (Zero [:<] t) ->
        ((a k)[*]t[^]k [=] a_0[-]eps) ->
        ((i:nat)(le (1) i) -> (le i n) ->
          (a i)[*]t[^]i[-]eps [:<] (a k)[*]t[^]k) ->
        (i:nat)(le (1) i) -> (le i n) -> (a i)[*]r[^]i [:<] a_0.
(* End_Tex_Verb *)
Intros.
Apply leEq_less_trans with (a i)[*]t[^]i.
Step_leEq_lft (a i)[*](t[^]i[*](p3m j)[^]i).
Step_Rat_leEq_lft (p3m j)[^]i[*]((a i)[*]t[^]i).
Step_leEq_rht One[*]((a i)[*]t[^]i).
Apply mult_resp_leEq_rht.
Step_leEq_rht One[^]i::IR.
Apply nexp_resp_leEq.
Apply less_leEq.
Apply p3m_pos.
Apply p3m_small.
Step_leEq_lft Zero[*]t[^]i.
Apply mult_resp_leEq_rht.
Auto.
Step_leEq_lft Zero[^]i::IR.
Apply nexp_resp_leEq.
Apply leEq_reflexive.
Apply less_leEq.
Auto.
Apply less_wdr with eps[+](a k)[*]t[^]k.
Apply shift_less_plus'.
Auto.
Step eps[+](a_0[-]eps).
Rational.
Qed.


(* Begin_Tex_Verb *)
Lemma Main_3a :
(t:IR; j,k,k_0:nat)
  let r = t[*](p3m j) in
        (le k_0 n) ->
        ((a k_0)[*]t[^]k_0 [=] a_0[-]eps) ->
        ((a k_0)[*]r[^]k_0[-]eps [:<] (a k)[*]r[^]k) ->
        (p3m (mult j n))[*]a_0[-]Two[*]eps [:<] (a k)[*]r[^]k.
(* End_Tex_Verb *)
Intros.
Apply less_wdl with ((p3m (mult j n))[*]a_0[-]eps)[-]eps.
Apply leEq_less_trans with (a k_0)[*](t[*](p3m j))[^]k_0[-]eps.
Apply minus_resp_leEq.
Step_leEq_rht (a k_0)[*](t[^]k_0[*](p3m j)[^]k_0).
Step_leEq_rht (a k_0)[*](t[^]k_0[*](p3m (mult j k_0))).
Apply leEq_wdr with (p3m (mult j k_0))[*]((a k_0)[*]t[^]k_0).
Step_leEq_rht (p3m (mult j k_0))[*](a_0[-]eps).
Step_leEq_rht (p3m (mult j k_0))[*]a_0[-](p3m (mult j k_0))[*]eps.
Apply minus_resp_leEq_both.
Apply mult_resp_leEq_rht.
Apply p3m_mon'.
Apply le_mult_left.
Auto.
Apply less_leEq.
Apply a_0_pos.
Step_leEq_rht One[*]eps.
Apply mult_resp_leEq_rht.
Apply p3m_small.
Apply less_leEq.
Apply eps_pos.
Rational.
Auto.
Rational.
Qed.

(* Begin_Tex_Verb *)
Lemma Main_3 :
(t:IR; j,k,k_0:nat)
  let r = t[*](p3m j) in
        (lt j two_n) ->
        (le k_0 n) ->
        ((a k_0)[*]t[^]k_0 [=] a_0[-]eps) ->
        ((a k_0)[*]r[^]k_0[-]eps [:<] (a k)[*]r[^]k) ->
          (Smaller[*]a_0[-]Two[*]eps [:<] (a k)[*]r[^]k).
(* End_Tex_Verb *)
Intros.
Apply less_transitive_unfolded with (p3m (mult j n))[*]a_0[-]Two[*]eps.
Apply minus_resp_less.
Apply mult_resp_less.
Unfold Smaller.
Apply p3m_mon.
Apply lt_mult_right.
Auto.
Auto.
Apply a_0_pos.
Apply Main_3a with k_0; Auto.
Qed.


(* Begin_Tex_Verb *)
Lemma Main :
(EX r | (Zero [:<] r) /\ (EX k | (le (1) k) /\ (le k n) /\
      let p_ = [i:nat](a i)[*]r[^]i in
      let p_k = (a k)[*]r[^]k in
        ((Sum (1) (pred k) p_) [+] (Sum (S k) n p_)
                [:<] (One[-]Small)[*]p_k[+]Three[^]n[*]eps) /\
        (r[^]n [:<] a_0) /\
        (Smaller[*]a_0[-]Two[*]eps [:<] p_k) /\ (p_k [:<] a_0))).
(* End_Tex_Verb *)
Proof.
Elim (Key a n gt_n_0 eps eps_pos a_nonneg a_n_1 a_0 eps_lt_a_0).
Intro t. Intros.
Elim H. Intros.
Elim (H1 two_n). Intro k. Intros.
Elim H2. Intros. Elim H4. Intros. Elim H6. Intros.
Elim (kseq_prop k n H3 H5). Intro j. Intros.
Elim H9. Intros. Elim H11. Intros.
Cut Zero [:<] t[*](p3m (S j)). Intro.
Exists t[*](p3m (S j)).
Split. Auto.
Exists (k (S j)).
Split. Elim (H3 (S j)). Auto.
Split. Elim (H3 (S j)). Auto.
Split.
Apply Main_1.
Auto.
Elim (H3 (S j)). Auto.
Elim (H3 (S j)). Auto.
Intros.
Apply Main_1a'.
Intros.
Rewrite H13.
Apply H8.
Auto with arith.
Auto.
Auto.
Auto.
Auto.
Intros.
Apply Main_1b'.
Intros.
Rewrite <- H12.
Apply H8.
Cut (lt j two_n). Intro.
Auto with arith.
Auto with arith.
Auto.
Auto.
Auto.
Auto.
Split.
Step_less_lft One[*](t[*](p3m (S j)))[^]n.
Step_less_lft (a n)[*](t[*](p3m (S j)))[^]n.
Apply Main_2 with (k (0)).
Auto.
Auto.
Intros.
Apply Main_2'.
Apply H8.
Auto with arith.
Auto.
Auto.
Auto with arith.
Auto.
Split.
Apply Main_3 with (k (0)).
Auto.
Elim (H3 (0)); Auto.
Auto.
Apply H8.
Auto with arith.
Elim (H3 (0)); Auto.
Elim (H3 (0)); Auto.
Apply Main_2 with (k (0)).
Auto.
Auto.
Intros.
Apply Main_2'.
Auto with arith.
Elim (H3 (S j)). Auto.
Elim (H3 (S j)). Auto.
Apply mult_resp_pos.
Auto.
Apply p3m_pos.
Qed.

End Main_Lemma.


