(* $Id: R_COrdField.v,v 1.5 2000/10/11 08:50:12 janz Exp $ *)

Require Export R_CField.

(* Summary:
      1- R is a COrdField.
*)
 
Section R_COrdField.

Variable a_COrdField : COrdField.

Syntactic Definition R_as_CSetoid' := (R_as_CSetoid a_COrdField).
Syntactic Definition R_as_CField' := (R_as_CField a_COrdField).
Syntactic Definition Rlt' := (Rlt a_COrdField).
Syntactic Definition Rlt_is_strictorder' :=  (Rlt_is_strictorder a_COrdField).

(*
Syntactic Definition Rplus_is_bin_fun' := (Rplus_is_bin_fun a_COrdField).
Syntactic Definition Rmult_is_bin_fun' := (Rmult_is_bin_fun a_COrdField).

Syntactic Definition ZEROR' := (ZEROR a_COrdField).
Syntactic Definition ONER' := (ONER a_COrdField).

Syntactic Definition R' := (R a_COrdField).
Syntactic Definition R_mul_as_CSemi_grp' := (R_mul_as_CSemi_grp a_COrdField).
Syntactic Definition Rmult_is_assoc' := (Rmult_is_assoc a_COrdField).
*)


Lemma Rlt_is_extensional:(rel_strong_ext R_as_CSetoid' Rlt').
 Red.
 Intros.
 Case (dec_Rlt ? x1 x2 y1 H).
 Intro.
 Right.
 Left.
 Left.
 Assumption.
 Intro.
 Case (dec_Rlt ? x2 y2 y1 H0).
 Intro.
 Left.
 Assumption.
 Intro.
 Right.
 Right.
 Right.
 Assumption.
Qed.


Lemma Rlt_is_well_defined_right:(rel_well_def_rht R_as_CSetoid' Rlt').
 Red.
 Intros.
 Cut (~(Rlt' y x)).
 Intro.
 
 Cut ((Rlt' x y)->(Rlt' x z)\/(y [#] z)).
 Intros.
 Case (H2 H).
 Intro.
 Assumption.
 Intro.
 Apply False_ind.
 Cut (~(y[#]z)).
 Intro.
 Apply H4.
 Assumption.
 Assumption.
 Cut (rel_strong_ext_rht R_as_CSetoid' Rlt').
 Intro.
 Red in H2.
 Intro.
 Apply H2.
 Assumption.
 Apply rel_strext_imp_rhtarg.
 Exact Rlt_is_extensional.
 Apply (Rlt_is_antisymmetric a_COrdField).
 Assumption.
Qed.
 


Lemma Rlt_is_well_defined_left:(rel_well_def_lft R_as_CSetoid' Rlt').
 Red.
 Intros.
 Cut (~(Rlt' y x)).
 Intro.
 
 Cut ((Rlt' x y)->(Rlt' z y)\/(x [#] z)).
 Intros.
 Case (H2 H).
 Intro.
 Assumption.
 Intro.
 Apply False_ind.
 Cut (~(x[#]z)).
 Intro.
 Apply H4.
 Assumption.
 Assumption.
 Cut (rel_strong_ext_lft R_as_CSetoid' Rlt').
 Intro.
 Red in H2.
 Intro.
 Apply H2.
 Assumption.
 Apply rel_strext_imp_lftarg.
 Exact Rlt_is_extensional. 
 Apply (Rlt_is_antisymmetric a_COrdField).
 Assumption.
Qed.

Definition Rlt_is_CSetoid_relation :=(!Build_CSetoid_relation R_as_CSetoid' 
 Rlt' Rlt_is_well_defined_right Rlt_is_well_defined_left Rlt_is_extensional).


Lemma Rplusresp_Rlt:(x,y:R_as_CField')(Rlt' x y)->
			(z:R_as_CField')(Rlt' x[+]z y[+]z).
 Intros.
 Red.
 Red in H.
 Case H.
 Intros e H0.
 Elim H0.
 Intros.
 Exists e.
 Split.
 Assumption.
 Case H2.
 Intros N H3.
 Exists N.
 Intros.
 Change (e[:<]((CS_seq a_COrdField y m)[+](CS_seq a_COrdField z m))[-]
		((CS_seq a_COrdField x m)[+](CS_seq a_COrdField z m))).
 Step_Rat_less_rht (CS_seq a_COrdField y m)[-](CS_seq a_COrdField x m).
 Apply H3.
 Assumption.
Qed.


Lemma Rmult_resp_pos_Rlt:(x,y:R_as_CField')(Rlt' (Zero::R_as_CField') x)->
	 (Rlt' (Zero::R_as_CField') y)->(Rlt' (Zero::R_as_CField') x[*]y).
 Red.
 Intros.
 Red in H. 
 Red in H0.
 Case H.
 Intros e1 H1.
 Elim H1.
 Intros.
 Case H0.
 Intros e2 H01.
 Elim H01.
 Intros H02 H03.
 Exists (e1[*]e2).
 Split.
 Apply mult_resp_pos.
 Assumption.
 Assumption.
 Case H3.
 Intros N1 H4.
 Case H03.
 Intros N2 H04.
 Exists (plus N1 N2).
 Intros.
 Change ((e1[*]e2)[:<] ((CS_seq a_COrdField x m)[*](CS_seq a_COrdField 
 		y m))[-]Zero).
 Step_Rat_less_rht (CS_seq a_COrdField x m)[*](CS_seq a_COrdField y m).
 Apply less_transitive_unfolded with 
 			F:=a_COrdField
			y:=e1[*](CS_seq a_COrdField y m).
 Apply mult_resp_less_lft.
 Step_Rat_less_rht  (CS_seq a_COrdField y m)[-]Zero.
 Change (e2 [:<] (CS_seq a_COrdField y m)[-]
	(CS_seq a_COrdField Zero::R_as_CField' m)).
 Apply H04.
 Apply le_trans with m:=(plus N1 N2).
 Apply le_plus_r.
 Assumption.
 Assumption.
 
 Apply mult_resp_less.
 Step_Rat_less_rht  (CS_seq a_COrdField x m)[-]Zero.
 Change (e1 [:<] (CS_seq a_COrdField x m)[-]
	(CS_seq a_COrdField Zero::R_as_CField' m)). 
 Apply H4.
 Apply le_trans with m:=(plus N1 N2).
 Apply le_plus_l.
 Assumption.

 Apply less_transitive_unfolded with F:=a_COrdField y:=e2. 
 Assumption.
 Step_Rat_less_rht  (CS_seq a_COrdField y m)[-]Zero.
 Change (e2 [:<] (CS_seq a_COrdField y m)[-]
	(CS_seq a_COrdField Zero::R_as_CField' m)).
 Apply H04.
 Apply le_trans with m:=(plus N1 N2).
 Apply le_plus_r.
 Assumption.
Qed.

Lemma Rlt_gives_apartness:(x,y:R_as_CField')(x[#]y)<->((Rlt' x y)\/(Rlt' y x)).
 Intros.
 Red.
 Split.
 Intro.
 Assumption.
 Intro.
 Assumption.
Qed.

Definition R_is_COrdField:=(!Build_is_COrdField R_as_CField' 
	Rlt_is_CSetoid_relation Rlt_is_strictorder' Rplusresp_Rlt
	Rmult_resp_pos_Rlt Rlt_gives_apartness).

Definition R_as_COrdField:=(!Build_COrdField R_as_CField' 
	Rlt_is_CSetoid_relation R_is_COrdField).

 
End R_COrdField.