/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import javacard.security.Key;

public class XORPublicKey
implements Key {
    private byte[] key;

    public XORPublicKey(byte[] buffer, short offset, short length) {
        this.key = new byte[length];
        short i = 0;
        while (i < length) {
            this.key[i] = buffer[(short)(i + offset)];
            i = (short)(i + 1);
        }
    }

    public boolean isInitialized() {
        return true;
    }

    public void clearKey() {
        int i = 0;
        while (i < this.key.length) {
            this.key[i] = 0;
            i = (short)(i + 1);
        }
    }

    public byte getType() {
        return -119;
    }

    public short getSize() {
        return (short)(8 * this.key.length);
    }

    public byte[] getEncoded() {
        return this.key;
    }

    public void getEncoded(byte[] output, short offset) {
        short i = 0;
        while (i < (short)this.key.length) {
            output[(short)(i + offset)] = this.key[i];
            i = (short)(i + 1);
        }
    }
}

