/*
 * Decompiled with CFR 0.152.
 */
package javacard.security;

import javacard.framework.Util;
import javacard.security.CryptoException;
import javacard.security.Key;
import javacard.security.XORPrivateKey;
import javacard.security.XORPublicKey;

public class Signature {
    private XORPublicKey key;
    private byte[] signature = new byte[8];
    private byte mode;
    private short offset;
    public static final short SIGNATURE_LENGTH = 8;
    public static final byte ALG_DES_MAC4_NOPAD = 1;
    public static final byte ALG_DES_MAC8_NOPAD = 2;
    public static final byte ALG_DES_MAC4_ISO9797_M1 = 3;
    public static final byte ALG_DES_MAC8_ISO9797_M1 = 4;
    public static final byte ALG_DES_MAC4_ISO9797_M2 = 5;
    public static final byte ALG_DES_MAC8_ISO9797_M2 = 6;
    public static final byte ALG_DES_MAC4_PKCS5 = 7;
    public static final byte ALG_DES_MAC8_PKCS5 = 8;
    public static final byte ALG_RSA_SHA_ISO9796 = 9;
    public static final byte ALG_RSA_SHA_PKCS1 = 10;
    public static final byte ALG_RSA_MD5_PKCS1 = 11;
    public static final byte ALG_RSA_RIPEMD160_ISO9796 = 12;
    public static final byte ALG_RSA_RIPEMD160_PKCS1 = 13;
    public static final byte ALG_DSA_SHA = 14;
    public static final byte ALG_RSA_SHA_RFC2409 = 15;
    public static final byte ALG_RSA_MD5_RFC2409 = 16;
    public static final byte ALG_ECDSA_SHA = 17;
    public static final byte ALG_AES_MAC_128_NOPAD = 18;
    public static final byte ALG_DES_MAC4_ISO9797_1_M2_ALG3 = 19;
    public static final byte ALG_DES_MAC8_ISO9797_1_M2_ALG3 = 20;
    public static final byte ALG_RSA_SHA_PKCS1_PSS = 21;
    public static final byte ALG_RSA_MD5_PKCS1_PSS = 22;
    public static final byte ALG_RSA_RIPEMD160_PKCS1_PSS = 23;
    public static final byte MODE_SIGN = 1;
    public static final byte MODE_VERIFY = 2;

    public static final Signature getInstance(byte algorithm, boolean externalAccess) throws CryptoException {
        return new Signature();
    }

    public void init(Key key, byte mode) throws CryptoException {
        this.mode = mode;
        switch (mode) {
            case 1: {
                byte[] privateKey = ((XORPrivateKey)key).getEncoded();
                byte[] publicKey = new byte[(short)(privateKey.length / 2)];
                int i = 0;
                while (i < publicKey.length) {
                    publicKey[i] = (byte)(privateKey[(short)(i * 2)] ^ privateKey[(short)(i * 2 + 1)]);
                    i = (short)(i + 1);
                }
                this.key = new XORPublicKey(publicKey, 0, (short)publicKey.length);
                break;
            }
            case 2: {
                this.key = (XORPublicKey)key;
            }
        }
        byte[] data = this.key.getEncoded();
        this.offset = 0;
        int i = 0;
        while (i < 8) {
            this.signature[i] = 0;
            i = (short)(i + 1);
        }
        this.update(data, (short)0, (short)data.length);
    }

    public void init(Key key, byte mode, byte[] array, short offset, short length) throws CryptoException {
        this.init(key, mode);
    }

    protected Signature() {
        int i = 0;
        while (i < 8) {
            this.signature[i] = 0;
            i = (short)(i + 1);
        }
        this.offset = 0;
    }

    public byte getAlgorithm() {
        return 0;
    }

    public short getLength() throws CryptoException {
        return 8;
    }

    public void update(byte[] buffer, short off, short length) throws CryptoException {
        short i = off;
        while (i < (short)(off + length)) {
            short s = this.offset;
            this.signature[s] = (byte)(this.signature[s] ^ buffer[i]);
            this.offset = (short)((short)(this.offset + 1) % 8);
            i = (short)(i + 1);
        }
    }

    public short sign(byte[] inBuff, short inOffset, short inLength, byte[] outBuff, short outOffset) throws CryptoException {
        this.update(inBuff, inOffset, inLength);
        Util.arrayCopy((byte[])this.signature, (short)0, (byte[])outBuff, (short)outOffset, (short)8);
        return 8;
    }

    public boolean verify(byte[] inBuff, short inOffset, short inLength, byte[] sigBuff, short sigOffset, short sigLength) throws CryptoException {
        this.update(inBuff, inOffset, inLength);
        return Util.arrayCompare((byte[])sigBuff, (short)sigOffset, (byte[])this.signature, (short)0, (short)8) == 0;
    }
}

